/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.cluster.ClusterManager;
import org.apache.catalina.cluster.SessionMessage;
import org.apache.catalina.cluster.tcp.SimpleTcpCluster;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplicationValve
extends ValveBase {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$SimpleTcpCluster == null ? (class$org$apache$catalina$cluster$tcp$SimpleTcpCluster = ReplicationValve.class$("org.apache.catalina.cluster.tcp.SimpleTcpCluster")) : class$org$apache$catalina$cluster$tcp$SimpleTcpCluster));
    private static final String info = "org.apache.catalina.cluster.tcp.ReplicationValve/1.0";
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.valves");
    protected Pattern[] reqFilters = new Pattern[0];
    protected int debug = 0;
    protected static long totalSendTime = 0L;
    protected static long nrOfRequests = 0L;
    protected static long lastSendTime = 0L;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$SimpleTcpCluster;

    public String getInfo() {
        return info;
    }

    protected static synchronized void addClusterSendTime(long time) {
        totalSendTime += time;
        if (++nrOfRequests % 100L == 0L) {
            log.info((Object)("Average cluster serialize/send time=" + totalSendTime / nrOfRequests + " ms for " + nrOfRequests + " requests (" + totalSendTime + "ms)."));
            lastSendTime = System.currentTimeMillis();
        }
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        context.invokeNext(request, response);
        try {
            long start = System.currentTimeMillis();
            HttpRequest hrequest = (HttpRequest)request;
            HttpServletRequest hreq = (HttpServletRequest)hrequest.getRequest();
            HttpSession session = hreq.getSession(false);
            if (!(request.getContext().getManager() instanceof ClusterManager)) {
                return;
            }
            ClusterManager manager = (ClusterManager)request.getContext().getManager();
            SimpleTcpCluster cluster = (SimpleTcpCluster)this.getContainer().getCluster();
            if (cluster == null) {
                log.warn((Object)"No cluster configured for this request.");
                return;
            }
            String[] invalidIds = manager.getInvalidatedSessions();
            if (invalidIds.length > 0) {
                for (int i = 0; i < invalidIds.length; ++i) {
                    try {
                        SessionMessage imsg = manager.requestCompleted(invalidIds[i]);
                        if (imsg == null) continue;
                        cluster.send(imsg);
                        continue;
                    }
                    catch (Exception x) {
                        log.error((Object)"Unable to send session invalid message over cluster.", (Throwable)x);
                    }
                }
            }
            String id = null;
            if (session == null) {
                return;
            }
            id = session.getId();
            if (id == null) {
                return;
            }
            if (request.getContext().getManager() == null || !(request.getContext().getManager() instanceof ClusterManager)) {
                return;
            }
            String uri = hrequest.getDecodedRequestURI();
            boolean filterfound = false;
            for (int i = 0; i < this.reqFilters.length && !filterfound; ++i) {
                Matcher matcher = this.reqFilters[i].matcher(uri);
                filterfound = matcher.matches();
            }
            if (filterfound) {
                return;
            }
            log.debug((Object)("Invoking replication request on " + uri));
            SessionMessage msg = manager.requestCompleted(id);
            if (msg == null) {
                return;
            }
            cluster.send(msg);
            long stop = System.currentTimeMillis();
            ReplicationValve.addClusterSendTime(stop - start);
        }
        catch (Exception x) {
            log.error((Object)"Unable to perform replication request.", (Throwable)x);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ReplicationValve[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    public void setFilter(String filter) {
        log.debug((Object)("Loading request filters=" + filter));
        StringTokenizer t = new StringTokenizer(filter, ";");
        this.reqFilters = new Pattern[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            log.debug((Object)("Request filter=" + s));
            try {
                this.reqFilters[i++] = Pattern.compile(s);
            }
            catch (Exception x) {
                log.error((Object)("Unable to compile filter " + s), (Throwable)x);
            }
        }
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

