/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.cluster.ClusterManager;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.MembershipFactory;
import org.apache.catalina.cluster.MembershipListener;
import org.apache.catalina.cluster.MembershipService;
import org.apache.catalina.cluster.SessionMessage;
import org.apache.catalina.cluster.io.ListenCallback;
import org.apache.catalina.cluster.session.ReplicationStream;
import org.apache.catalina.cluster.session.SimpleTcpReplicationManager;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.catalina.cluster.tcp.IDataSenderFactory;
import org.apache.catalina.cluster.tcp.Jdk13ReplicationListener;
import org.apache.catalina.cluster.tcp.ReplicationListener;
import org.apache.catalina.cluster.tcp.ReplicationTransmitter;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleTcpCluster
implements Cluster,
Lifecycle,
MembershipListener,
ListenCallback,
LifecycleListener {
    public static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$SimpleTcpCluster == null ? (class$org$apache$catalina$cluster$tcp$SimpleTcpCluster = SimpleTcpCluster.class$("org.apache.catalina.cluster.tcp.SimpleTcpCluster")) : class$org$apache$catalina$cluster$tcp$SimpleTcpCluster));
    protected static final String info = "SimpleTcpCluster/1.0";
    protected MembershipService service = null;
    protected String serviceclass = null;
    protected Properties svcproperties = new Properties();
    protected InetAddress tcpAddress = null;
    protected int tcpPort = 1234;
    protected int tcpThreadCount = 2;
    protected ReplicationTransmitter mReplicationTransmitter;
    protected String threadName = "SimpleTcpCluster";
    protected boolean expireSessionsOnShutdown = true;
    protected boolean printToScreen = false;
    protected boolean useDirtyFlag = false;
    protected String clusterImpName = "SimpleTcpCluster";
    protected StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster");
    protected boolean threadDone = false;
    protected String clusterName = null;
    protected Container container = null;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected int debug = 0;
    protected HashMap managers = new HashMap();
    protected HashMap allmanagers = new HashMap();
    protected long msgFrequency = 500L;
    protected long tcpSelectorTimeout = 100L;
    protected String protocol = null;
    protected String replicationMode = "synchronous";
    private long nrOfMsgsReceived = 0L;
    private long msgSendTime = 0L;
    private long lastChecked = System.currentTimeMillis();
    private boolean isJdk13 = false;
    private String managerClassName = "org.apache.catalina.cluster.session.DeltaManager";
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$SimpleTcpCluster;

    public SimpleTcpCluster() {
        try {
            this.tcpAddress = InetAddress.getLocalHost();
        }
        catch (Exception x) {
            log.error((Object)"In SimpleTcpCluster.constructor()", (Throwable)x);
        }
    }

    public String getInfo() {
        return info;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setReplicationMode(String mode) {
        String msg = IDataSenderFactory.validateMode(mode);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        log.debug((Object)("Setting replcation mode to " + mode));
        this.replicationMode = mode;
    }

    public void setClusterName(String clusterName) {
        String oldClusterName = this.clusterName;
        this.clusterName = clusterName;
        this.support.firePropertyChange("clusterName", oldClusterName, this.clusterName);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public Container getContainer() {
        return this.container;
    }

    public void setProtocol(String protocol) {
        String oldProtocol = this.protocol;
        this.protocol = protocol;
        this.support.firePropertyChange("protocol", oldProtocol, this.protocol);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Member[] getMembers() {
        return this.service.getMembers();
    }

    public synchronized Manager createManager(String name) {
        ClusterManager manager = null;
        try {
            manager = (ClusterManager)this.getClass().getClassLoader().loadClass(this.getManagerClassName()).newInstance();
        }
        catch (Exception x) {
            log.error((Object)"Unable to load class for replication manager", (Throwable)x);
            manager = new SimpleTcpReplicationManager();
        }
        manager.setName(name);
        manager.setCluster(this);
        manager.setDistributable(true);
        manager.setExpireSessionsOnShutdown(this.expireSessionsOnShutdown);
        manager.setUseDirtyFlag(this.useDirtyFlag);
        this.allmanagers.put(name, manager);
        this.managers.put(name, manager);
        return manager;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("cluster.alreadyStarted"));
        }
        log.info((Object)"Cluster is about to start");
        try {
            if (this.isJdk13) {
                Jdk13ReplicationListener mReplicationListener = new Jdk13ReplicationListener(this, this.tcpThreadCount, this.tcpAddress, this.tcpPort, this.tcpSelectorTimeout, "synchronous".equals(this.replicationMode));
                Thread t = new Thread(mReplicationListener);
                t.setName("Cluster-TcpListener");
                t.setDaemon(true);
                t.start();
            } else {
                ReplicationListener mReplicationListener = new ReplicationListener(this, this.tcpThreadCount, this.tcpAddress, this.tcpPort, this.tcpSelectorTimeout, "synchronous".equals(this.replicationMode) || "pooled".equals(this.replicationMode));
                mReplicationListener.setName("Cluster-ReplicationListener");
                mReplicationListener.setDaemon(true);
                mReplicationListener.start();
            }
            this.mReplicationTransmitter = new ReplicationTransmitter(new IDataSender[0]);
            this.mReplicationTransmitter.start();
            log.info((Object)("Sleeping for " + this.msgFrequency * 4L + " secs to establish cluster membership"));
            this.service = MembershipFactory.getMembershipService(this.serviceclass, this.svcproperties);
            this.service.addMembershipListener(this);
            this.service.start();
            Thread.currentThread();
            Thread.sleep(this.msgFrequency * 4L);
            this.started = true;
        }
        catch (Exception x) {
            log.error((Object)"Unable to start cluster.", (Throwable)x);
        }
    }

    public void send(SessionMessage msg, Member dest) {
        try {
            msg.setAddress(this.service.getLocalMember());
            Member destination = dest;
            if (destination == null && msg.getEventType() == 4 && this.service.getMembers().length > 0) {
                destination = this.service.getMembers()[0];
            }
            msg.setTimestamp(System.currentTimeMillis());
            ByteArrayOutputStream outs = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(outs);
            out.writeObject(msg);
            byte[] data = outs.toByteArray();
            if (destination != null) {
                Member tcpdest = dest;
                if (tcpdest != null && !this.service.getLocalMember().equals(tcpdest)) {
                    this.mReplicationTransmitter.sendMessage(msg.getSessionID(), data, InetAddress.getByName(tcpdest.getHost()), tcpdest.getPort());
                }
            } else {
                this.mReplicationTransmitter.sendMessage(msg.getSessionID(), data);
            }
        }
        catch (Exception x) {
            log.error((Object)"Unable to send message through tcp channel", (Throwable)x);
        }
    }

    public void send(SessionMessage msg) {
        this.send(msg, null);
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new IllegalStateException(this.sm.getString("cluster.notStarted"));
        }
    }

    public void memberAdded(Member member) {
        try {
            log.info((Object)("Replication member added:" + member));
            Member mbr = member;
            this.mReplicationTransmitter.add(IDataSenderFactory.getIDataSender(this.replicationMode, mbr));
        }
        catch (Exception x) {
            log.error((Object)"Unable to connect to replication system.", (Throwable)x);
        }
    }

    public void memberDisappeared(Member member) {
        log.info((Object)("Received member disappeared:" + member));
        try {
            Member mbr = member;
            this.mReplicationTransmitter.remove(InetAddress.getByName(mbr.getHost()), mbr.getPort());
        }
        catch (Exception x) {
            log.error((Object)"Unable remove cluster node from replication system.", (Throwable)x);
        }
    }

    public void setServiceclass(String clazz) {
        this.serviceclass = clazz;
    }

    public void setMcastAddr(String addr) {
        this.svcproperties.setProperty("mcastAddress", addr);
    }

    public void setMcastBindAddress(String bindaddr) {
        this.svcproperties.setProperty("mcastBindAddress", bindaddr);
    }

    public void setMcastPort(int port) {
        this.svcproperties.setProperty("mcastPort", String.valueOf(port));
    }

    public void setMcastFrequency(long time) {
        this.svcproperties.setProperty("msgFrequency", String.valueOf(time));
        this.msgFrequency = time;
    }

    public void setMcastDropTime(long time) {
        this.svcproperties.setProperty("memberDropTime", String.valueOf(time));
    }

    public void setTcpThreadCount(int count) {
        this.tcpThreadCount = count;
    }

    public void setTcpListenAddress(String address) {
        try {
            if ("auto".equals(address)) {
                address = InetAddress.getLocalHost().getHostAddress();
                this.tcpAddress = InetAddress.getByName(address);
            } else {
                this.tcpAddress = InetAddress.getByName(address);
            }
            this.svcproperties.setProperty("tcpListenHost", address);
        }
        catch (Exception x) {
            log.error((Object)"Unable to set listen address", (Throwable)x);
        }
    }

    public void setExpireSessionsOnShutdown(boolean expireSessionsOnShutdown) {
        this.expireSessionsOnShutdown = expireSessionsOnShutdown;
    }

    public void setPrintToScreen(boolean printToScreen) {
        this.printToScreen = printToScreen;
    }

    public void setUseDirtyFlag(boolean useDirtyFlag) {
        this.useDirtyFlag = useDirtyFlag;
    }

    public void setTcpListenPort(int port) {
        this.tcpPort = port;
        this.svcproperties.setProperty("tcpListenPort", String.valueOf(port));
    }

    public void setTcpSelectorTimeout(long timeout) {
        this.tcpSelectorTimeout = timeout;
    }

    public void messageDataReceived(byte[] data) {
        try {
            ReplicationStream stream = new ReplicationStream(new ByteArrayInputStream(data), this.getClass().getClassLoader());
            Object myobj = stream.readObject();
            if (myobj != null && myobj instanceof SessionMessage) {
                SessionMessage msg = (SessionMessage)myobj;
                this.perfMessageRecvd(msg.getTimestamp());
                String name = msg.getContextName();
                if (name == null) {
                    Iterator i = this.managers.keySet().iterator();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        ClusterManager mgr = (ClusterManager)this.managers.get(key);
                        if (mgr != null) {
                            mgr.messageDataReceived(msg);
                            continue;
                        }
                        log.debug((Object)("Context manager doesn't exist:" + key));
                    }
                } else {
                    ClusterManager mgr = (ClusterManager)this.managers.get(name);
                    if (mgr != null) {
                        mgr.messageDataReceived(msg);
                    } else {
                        log.warn((Object)("Context manager doesn't exist:" + name));
                    }
                }
            } else {
                log.warn((Object)("Received invalid message myobj=" + myobj));
            }
        }
        catch (Exception x) {
            log.error((Object)"Unable to deserialize session message.", (Throwable)x);
        }
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
    }

    public void startContext(String contextPath) throws IOException {
    }

    public void installContext(String contextPath, URL war) {
        System.out.println("\n\n\n\nCluster Install called for context:" + contextPath + "\n\n\n\n");
    }

    public void stop(String contextPath) throws IOException {
    }

    private void perfMessageRecvd(long timeSent) {
        ++this.nrOfMsgsReceived;
        this.msgSendTime += System.currentTimeMillis() - timeSent;
        if (System.currentTimeMillis() - this.lastChecked > 5000L) {
            log.debug((Object)("Calc msg send time total=" + this.msgSendTime + "ms num request=" + this.nrOfMsgsReceived + " average per msg=" + this.msgSendTime / this.nrOfMsgsReceived + "ms."));
        }
    }

    public boolean getIsJdk13() {
        return this.isJdk13;
    }

    public void setIsJdk13(boolean isJdk13) {
        this.isJdk13 = isJdk13;
    }

    public String getManagerClassName() {
        return this.managerClassName;
    }

    public void setManagerClassName(String managerClassName) {
        this.managerClassName = managerClassName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

