/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.catalina.cluster.ClusterSender;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.io.XByteBuffer;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.catalina.cluster.tcp.IDataSenderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplicationTransmitter
implements ClusterSender {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$ReplicationTransmitter == null ? (class$org$apache$catalina$cluster$tcp$ReplicationTransmitter = ReplicationTransmitter.class$("org.apache.catalina.cluster.tcp.ReplicationTransmitter")) : class$org$apache$catalina$cluster$tcp$ReplicationTransmitter));
    private HashMap map = new HashMap();
    private static long nrOfRequests = 0L;
    private static long totalBytes = 0L;
    private String replicationMode;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$ReplicationTransmitter;

    private static synchronized void addStats(int length) {
        totalBytes += (long)length;
        if (++nrOfRequests % 100L == 0L) {
            log.info((Object)("Nr of bytes sent=" + totalBytes + " over " + nrOfRequests + " ==" + totalBytes / nrOfRequests + " bytes/request"));
        }
    }

    public void setReplicationMode(String mode) {
        String msg = IDataSenderFactory.validateMode(mode);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        log.debug((Object)("Setting replcation mode to " + mode));
        this.replicationMode = mode;
    }

    public synchronized void add(Member member) {
        try {
            IDataSender sender = IDataSenderFactory.getIDataSender(this.replicationMode, member);
            String key = sender.getAddress().getHostAddress() + ":" + sender.getPort();
            if (!this.map.containsKey(key)) {
                this.map.put(sender.getAddress().getHostAddress() + ":" + sender.getPort(), sender);
            }
        }
        catch (IOException x) {
            log.error((Object)"Unable to create and add a IDataSender object.", (Throwable)x);
        }
    }

    public synchronized void remove(Member member) {
        String key = member.getHost() + ":" + member.getPort();
        IDataSender toberemoved = (IDataSender)this.map.get(key);
        if (toberemoved == null) {
            return;
        }
        toberemoved.disconnect();
        this.map.remove(key);
    }

    public void start() throws IOException {
    }

    public synchronized void stop() {
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            IDataSender sender = (IDataSender)i.next().getValue();
            try {
                sender.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public IDataSender[] getSenders() {
        Iterator i = this.map.entrySet().iterator();
        Vector<IDataSender> v = new Vector<IDataSender>();
        while (i.hasNext()) {
            IDataSender sender = (IDataSender)i.next().getValue();
            if (sender == null) continue;
            v.addElement(sender);
        }
        Object[] result = new IDataSender[v.size()];
        v.copyInto(result);
        return result;
    }

    protected void sendMessageData(String sessionId, byte[] data, IDataSender sender) throws IOException {
        if (sender == null) {
            throw new IOException("Sender not available. Make sure sender information is available to the ReplicationTransmitter.");
        }
        try {
            if (!sender.isConnected()) {
                sender.connect();
            }
            sender.sendMessage(sessionId, data);
            sender.setSuspect(false);
            ReplicationTransmitter.addStats(data.length);
        }
        catch (Exception x) {
            if (!sender.getSuspect()) {
                log.warn((Object)"Unable to send replicated message, is server down?", (Throwable)x);
            }
            sender.setSuspect(true);
        }
    }

    public void sendMessage(String sessionId, byte[] indata, Member member) throws IOException {
        byte[] data = XByteBuffer.createDataPackage(indata);
        String key = member.getHost() + ":" + member.getPort();
        IDataSender sender = (IDataSender)this.map.get(key);
        this.sendMessageData(sessionId, data, sender);
    }

    public void sendMessage(String sessionId, byte[] indata) throws IOException {
        IDataSender[] senders = this.getSenders();
        byte[] data = XByteBuffer.createDataPackage(indata);
        for (int i = 0; i < senders.length; ++i) {
            IDataSender sender = senders[i];
            try {
                this.sendMessageData(sessionId, data, sender);
                continue;
            }
            catch (Exception x) {
                if (!sender.getSuspect()) {
                    log.warn((Object)("Unable to send replicated message to " + sender + ", is server down?"), (Throwable)x);
                }
                sender.setSuspect(true);
            }
        }
    }

    public String getReplicationMode() {
        return this.replicationMode;
    }

    public boolean getIsSenderSynchronized() {
        return "synchronous".equals(this.replicationMode) || "pooled".equals(this.replicationMode);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

