/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.catalina.cluster.tcp.ClusterData;
import org.apache.catalina.cluster.tcp.DataSender;
import org.apache.catalina.cluster.util.SmartQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AsyncSocketSender
extends DataSender {
    private static int threadCounter = 1;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$AsyncSocketSender == null ? (class$org$apache$catalina$cluster$tcp$AsyncSocketSender = AsyncSocketSender.class$("org.apache.catalina.cluster.tcp.AsyncSocketSender")) : class$org$apache$catalina$cluster$tcp$AsyncSocketSender));
    private static final String info = "AsyncSocketSender/2.0";
    private SmartQueue queue = new SmartQueue();
    private QueueThread queueThread = null;
    private long inQueueCounter = 0L;
    private long outQueueCounter = 0L;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$AsyncSocketSender;

    public AsyncSocketSender(String domain, InetAddress host, int port) {
        super(domain, host, port);
        this.checkThread();
    }

    public String getInfo() {
        return info;
    }

    public long getInQueueCounter() {
        return this.inQueueCounter;
    }

    public long getOutQueueCounter() {
        return this.outQueueCounter;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public long getQueuedNrOfBytes() {
        if (this.queueThread != null) {
            return this.queueThread.getQueuedNrOfBytes();
        }
        return 0L;
    }

    public void connect() throws IOException {
        super.connect();
        this.checkThread();
    }

    public void disconnect() {
        this.stopThread();
        super.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String messageid, ClusterData data) throws IOException {
        SmartQueue.SmartEntry entry = new SmartQueue.SmartEntry(messageid, data);
        this.queue.add(entry);
        AsyncSocketSender asyncSocketSender = this;
        synchronized (asyncSocketSender) {
            ++this.inQueueCounter;
            this.queueThread.incQueuedNrOfBytes(data.getMessage().length);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("AsyncSocketSender.queue.message", (Object)this.getAddress().getHostAddress(), (Object)new Integer(this.getPort()), (Object)messageid, (Object)new Long(data.getMessage().length)));
        }
    }

    public synchronized void resetStatistics() {
        super.resetStatistics();
        this.inQueueCounter = this.queue.size();
        this.outQueueCounter = 0L;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("AsyncSocketSender[");
        buf.append(this.getAddress().getHostAddress()).append(":").append(this.getPort()).append("]");
        return buf.toString();
    }

    protected void checkThread() {
        if (this.queueThread == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("AsyncSocketSender.create.thread", (Object)this.getAddress(), (Object)new Integer(this.getPort())));
            }
            this.queueThread = new QueueThread(this);
            this.queueThread.setDaemon(true);
            this.queueThread.start();
        }
    }

    protected void stopThread() {
        if (this.queueThread != null) {
            this.queueThread.stopRunning();
            this.queueThread = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class QueueThread
    extends Thread {
        AsyncSocketSender sender;
        private boolean keepRunning = true;
        private long queuedNrOfBytes = 0L;

        public QueueThread(AsyncSocketSender sender) {
            this.sender = sender;
            this.setName("Cluster-AsyncSocketSender-" + threadCounter++);
        }

        protected long getQueuedNrOfBytes() {
            return this.queuedNrOfBytes;
        }

        protected synchronized void setQueuedNrOfBytes(long queuedNrOfBytes) {
            this.queuedNrOfBytes = queuedNrOfBytes;
        }

        protected synchronized void incQueuedNrOfBytes(long size) {
            this.queuedNrOfBytes += size;
        }

        protected synchronized void decQueuedNrOfBytes(long size) {
            this.queuedNrOfBytes -= size;
        }

        public void stopRunning() {
            this.keepRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.keepRunning) {
                SmartQueue.SmartEntry entry = this.sender.queue.remove(5000L);
                if (entry == null) continue;
                int messagesize = 0;
                try {
                    ClusterData data = (ClusterData)entry.getValue();
                    messagesize = data.getMessage().length;
                    this.sender.pushMessage(data);
                    AsyncSocketSender.this.outQueueCounter++;
                }
                catch (Exception x) {
                    log.warn((Object)DataSender.sm.getString("AsyncSocketSender.send.error", entry.getKey()));
                }
                finally {
                    this.decQueuedNrOfBytes(messagesize);
                }
            }
        }
    }
}

