/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.catalina.cluster.io.XByteBuffer;
import org.apache.catalina.cluster.tcp.ClusterData;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSender
implements IDataSender {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$DataSender == null ? (class$org$apache$catalina$cluster$tcp$DataSender = DataSender.class$("org.apache.catalina.cluster.tcp.DataSender")) : class$org$apache$catalina$cluster$tcp$DataSender));
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.tcp");
    private static final String info = "DataSender/2.1";
    private InetAddress address;
    private int port;
    private String domain;
    private Socket socket = null;
    private boolean isSocketConnected = false;
    private boolean suspect;
    private long ackTimeout;
    protected long nrOfRequests = 0L;
    protected long totalBytes = 0L;
    protected long connectCounter = 0L;
    protected long disconnectCounter = 0L;
    protected long missingAckCounter = 0L;
    protected long dataResendCounter = 0L;
    protected long dataFailureCounter = 0L;
    protected boolean doProcessingStats = false;
    protected long processingTime = 0L;
    protected long minProcessingTime = Long.MAX_VALUE;
    protected long maxProcessingTime = 0L;
    protected boolean doWaitAckStats = false;
    protected long waitAckTime = 0L;
    protected long minWaitAckTime = Long.MAX_VALUE;
    protected long maxWaitAckTime = 0L;
    private long keepAliveTimeout = 60000L;
    private int keepAliveMaxRequestCount = -1;
    protected long keepAliveConnectTime = 0L;
    protected int keepAliveCount = 0;
    private boolean waitForAck = false;
    private int socketCloseCounter = 0;
    private int socketOpenCounter = 0;
    private int socketOpenFailureCounter = 0;
    private boolean resend = false;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$DataSender;

    public DataSender(String domain, InetAddress host, int port) {
        this.address = host;
        this.port = port;
        this.domain = domain;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("IDataSender.create", (Object)this.address, (Object)new Integer(port)));
        }
    }

    public String getInfo() {
        return info;
    }

    public long getNrOfRequests() {
        return this.nrOfRequests;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getAvgMessageSize() {
        return this.totalBytes / this.nrOfRequests;
    }

    public double getAvgProcessingTime() {
        return (double)this.processingTime / (double)this.nrOfRequests;
    }

    public long getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public long getMinProcessingTime() {
        return this.minProcessingTime;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public boolean isDoProcessingStats() {
        return this.doProcessingStats;
    }

    public void setDoProcessingStats(boolean doProcessingStats) {
        this.doProcessingStats = doProcessingStats;
    }

    public boolean isDoWaitAckStats() {
        return this.doWaitAckStats;
    }

    public void setDoWaitAckStats(boolean doWaitAckStats) {
        this.doWaitAckStats = doWaitAckStats;
    }

    public double getAvgWaitAckTime() {
        return (double)this.waitAckTime / (double)this.nrOfRequests;
    }

    public long getMaxWaitAckTime() {
        return this.maxWaitAckTime;
    }

    public long getMinWaitAckTime() {
        return this.minWaitAckTime;
    }

    public long getWaitAckTime() {
        return this.waitAckTime;
    }

    public long getConnectCounter() {
        return this.connectCounter;
    }

    public long getDisconnectCounter() {
        return this.disconnectCounter;
    }

    public long getMissingAckCounter() {
        return this.missingAckCounter;
    }

    public int getSocketOpenCounter() {
        return this.socketOpenCounter;
    }

    public int getSocketOpenFailureCounter() {
        return this.socketOpenFailureCounter;
    }

    public int getSocketCloseCounter() {
        return this.socketCloseCounter;
    }

    public long getDataResendCounter() {
        return this.dataResendCounter;
    }

    public long getDataFailureCounter() {
        return this.dataFailureCounter;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean isConnected() {
        return this.isSocketConnected;
    }

    protected void setSocketConnected(boolean isSocketConnected) {
        this.isSocketConnected = isSocketConnected;
    }

    public boolean isSuspect() {
        return this.suspect;
    }

    public boolean getSuspect() {
        return this.suspect;
    }

    public void setSuspect(boolean suspect) {
        this.suspect = suspect;
    }

    public long getAckTimeout() {
        return this.ackTimeout;
    }

    public void setAckTimeout(long ackTimeout) {
        this.ackTimeout = ackTimeout;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public int getKeepAliveMaxRequestCount() {
        return this.keepAliveMaxRequestCount;
    }

    public void setKeepAliveMaxRequestCount(int keepAliveMaxRequestCount) {
        this.keepAliveMaxRequestCount = keepAliveMaxRequestCount;
    }

    public long getKeepAliveConnectTime() {
        return this.keepAliveConnectTime;
    }

    public int getKeepAliveCount() {
        return this.keepAliveCount;
    }

    public boolean isWaitForAck() {
        return this.waitForAck;
    }

    public void setWaitForAck(boolean waitForAck) {
        this.waitForAck = waitForAck;
    }

    public boolean isResend() {
        return this.resend;
    }

    public void setResend(boolean resend) {
        this.resend = resend;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public synchronized void connect() throws IOException {
        this.openSocket();
        if (this.isConnected()) {
            ++this.connectCounter;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("IDataSender.connect", (Object)this.address.getHostAddress(), (Object)new Integer(this.port), (Object)new Long(this.connectCounter)));
            }
        }
    }

    public synchronized void disconnect() {
        boolean connect = this.isConnected();
        this.closeSocket();
        if (connect) {
            ++this.disconnectCounter;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("IDataSender.disconnect", (Object)this.address.getHostAddress(), (Object)new Integer(this.port), (Object)new Long(this.disconnectCounter)));
            }
        }
    }

    public synchronized boolean checkKeepAlive() {
        boolean isCloseSocket = true;
        if (this.isConnected()) {
            if (this.keepAliveTimeout > -1L && System.currentTimeMillis() - this.keepAliveConnectTime > this.keepAliveTimeout || this.keepAliveMaxRequestCount > -1 && this.keepAliveCount >= this.keepAliveMaxRequestCount) {
                this.closeSocket();
            } else {
                isCloseSocket = false;
            }
        }
        return isCloseSocket;
    }

    public synchronized void sendMessage(ClusterData data) throws IOException {
        this.pushMessage(data);
    }

    public synchronized void resetStatistics() {
        this.nrOfRequests = 0L;
        this.totalBytes = 0L;
        this.disconnectCounter = 0L;
        this.connectCounter = this.isConnected() ? 1L : 0L;
        this.missingAckCounter = 0L;
        this.dataResendCounter = 0L;
        this.dataFailureCounter = 0L;
        this.socketOpenCounter = this.isConnected() ? 1 : 0;
        this.socketOpenFailureCounter = 0;
        this.socketCloseCounter = 0;
        this.processingTime = 0L;
        this.minProcessingTime = Long.MAX_VALUE;
        this.maxProcessingTime = 0L;
        this.waitAckTime = 0L;
        this.minWaitAckTime = Long.MAX_VALUE;
        this.maxWaitAckTime = 0L;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("DataSender[");
        buf.append(this.getAddress()).append(":").append(this.getPort()).append("]");
        return buf.toString();
    }

    protected void openSocket() throws IOException, SocketException {
        if (this.isConnected()) {
            return;
        }
        try {
            this.createSocket();
            if (this.isWaitForAck()) {
                this.socket.setSoTimeout((int)this.ackTimeout);
            }
            this.isSocketConnected = true;
            ++this.socketOpenCounter;
            this.keepAliveCount = 0;
            this.keepAliveConnectTime = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("IDataSender.openSocket", (Object)this.address.getHostAddress(), (Object)new Integer(this.port), (Object)new Long(this.socketOpenCounter)));
            }
        }
        catch (IOException ex1) {
            ++this.socketOpenFailureCounter;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("IDataSender.openSocket.failure", (Object)this.address.getHostAddress(), (Object)new Integer(this.port), (Object)new Long(this.socketOpenFailureCounter)), (Throwable)ex1);
            }
            throw ex1;
        }
    }

    protected void createSocket() throws IOException, SocketException {
        this.socket = new Socket(this.getAddress(), this.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSocket() {
        if (this.isConnected()) {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.socket = null;
                }
            }
            this.keepAliveCount = 0;
            this.isSocketConnected = false;
            ++this.socketCloseCounter;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("IDataSender.closeSocket", (Object)this.address.getHostAddress(), (Object)new Integer(this.port), (Object)new Long(this.socketCloseCounter)));
            }
        }
    }

    protected void addStats(int length) {
        ++this.nrOfRequests;
        this.totalBytes += (long)length;
        if (log.isInfoEnabled() && this.nrOfRequests % 100L == 0L) {
            log.info((Object)sm.getString("IDataSender.stats", new Object[]{this.getAddress().getHostAddress(), new Integer(this.getPort()), new Long(this.totalBytes), new Long(this.nrOfRequests), new Long(this.totalBytes / this.nrOfRequests), new Long(this.getProcessingTime()), new Double(this.getAvgProcessingTime())}));
        }
    }

    protected void addProcessingStats(long startTime) {
        long time = System.currentTimeMillis() - startTime;
        if (time < this.minProcessingTime) {
            this.minProcessingTime = time;
        }
        if (time > this.maxProcessingTime) {
            this.maxProcessingTime = time;
        }
        this.processingTime += time;
    }

    protected void addWaitAckStats(long startTime) {
        long time = System.currentTimeMillis() - startTime;
        if (time < this.minWaitAckTime) {
            this.minWaitAckTime = time;
        }
        if (time > this.maxWaitAckTime) {
            this.maxWaitAckTime = time;
        }
        this.waitAckTime += time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void pushMessage(ClusterData data) throws IOException {
        long time = 0L;
        if (this.doProcessingStats) {
            time = System.currentTimeMillis();
        }
        boolean messageTransfered = false;
        DataSender dataSender = this;
        synchronized (dataSender) {
            this.checkKeepAlive();
            if (!this.isConnected()) {
                this.openSocket();
            }
        }
        IOException exception = null;
        try {
            try {
                this.writeData(data);
                messageTransfered = true;
            }
            catch (IOException x) {
                if (data.getResend() == 1 || data.getResend() == 2 && this.isResend()) {
                    ++this.dataResendCounter;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)sm.getString("IDataSender.send.again", (Object)this.address.getHostAddress(), (Object)new Integer(this.port)), (Throwable)x);
                    }
                    DataSender dataSender2 = this;
                    synchronized (dataSender2) {
                        this.closeSocket();
                        this.openSocket();
                    }
                    try {
                        this.writeData(data);
                        messageTransfered = true;
                    }
                    catch (IOException xx) {
                        exception = xx;
                        throw xx;
                    }
                } else {
                    exception = x;
                }
                Object var10_6 = null;
                ++this.keepAliveCount;
                this.checkKeepAlive();
                if (this.doProcessingStats) {
                    this.addProcessingStats(time);
                }
                if (messageTransfered) {
                    this.addStats(data.getMessage().length);
                    if (!log.isTraceEnabled()) return;
                    log.trace((Object)sm.getString("IDataSender.send.message", (Object)this.address.getHostAddress(), (Object)new Integer(this.port), (Object)data.getUniqueId(), (Object)new Long(data.getMessage().length)));
                    return;
                }
                ++this.dataFailureCounter;
                if (!log.isWarnEnabled()) return;
                log.warn((Object)sm.getString("IDataSender.send.lost", (Object)this.address.getHostAddress(), (Object)new Integer(this.port), (Object)data.getType(), (Object)data.getUniqueId()), (Throwable)exception);
                return;
            }
            Object var10_5 = null;
            ++this.keepAliveCount;
            this.checkKeepAlive();
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            ++this.keepAliveCount;
            this.checkKeepAlive();
            if (this.doProcessingStats) {
                this.addProcessingStats(time);
            }
            if (messageTransfered) {
                this.addStats(data.getMessage().length);
                if (!log.isTraceEnabled()) throw throwable;
                log.trace((Object)sm.getString("IDataSender.send.message", (Object)this.address.getHostAddress(), (Object)new Integer(this.port), (Object)data.getUniqueId(), (Object)new Long(data.getMessage().length)));
                throw throwable;
            }
            ++this.dataFailureCounter;
            if (!log.isWarnEnabled()) throw throwable;
            log.warn((Object)sm.getString("IDataSender.send.lost", (Object)this.address.getHostAddress(), (Object)new Integer(this.port), (Object)data.getType(), (Object)data.getUniqueId()), (Throwable)exception);
            throw throwable;
        }
        if (this.doProcessingStats) {
            this.addProcessingStats(time);
        }
        if (messageTransfered) {
            this.addStats(data.getMessage().length);
            if (!log.isTraceEnabled()) return;
            log.trace((Object)sm.getString("IDataSender.send.message", (Object)this.address.getHostAddress(), (Object)new Integer(this.port), (Object)data.getUniqueId(), (Object)new Long(data.getMessage().length)));
            return;
        }
        ++this.dataFailureCounter;
        if (!log.isWarnEnabled()) return;
        log.warn((Object)sm.getString("IDataSender.send.lost", (Object)this.address.getHostAddress(), (Object)new Integer(this.port), (Object)data.getType(), (Object)data.getUniqueId()), (Throwable)exception);
    }

    protected void writeData(ClusterData data) throws IOException {
        OutputStream out = this.socket.getOutputStream();
        out.write(XByteBuffer.START_DATA);
        out.write(XByteBuffer.toBytes(data.getCompress()));
        out.write(XByteBuffer.toBytes(data.getMessage().length));
        out.write(data.getMessage());
        out.write(XByteBuffer.END_DATA);
        out.flush();
        if (this.isWaitForAck()) {
            this.waitForAck(this.ackTimeout);
        }
    }

    protected void waitForAck(long timeout) throws IOException {
        long time = 0L;
        if (this.doWaitAckStats) {
            time = System.currentTimeMillis();
        }
        try {
            int bytesRead = 0;
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("IDataSender.ack.start", (Object)this.getAddress(), (Object)new Integer(this.socket.getLocalPort())));
            }
            int i = this.socket.getInputStream().read();
            while (i != -1 && i != 3 && bytesRead < 10) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("IDataSender.ack.read", (Object)this.getAddress(), (Object)new Integer(this.socket.getLocalPort()), (Object)new Character((char)i)));
                }
                ++bytesRead;
                i = this.socket.getInputStream().read();
            }
            if (i != 3) {
                if (i == -1) {
                    throw new IOException(sm.getString("IDataSender.ack.eof", (Object)this.getAddress(), (Object)new Integer(this.socket.getLocalPort())));
                }
                throw new IOException(sm.getString("IDataSender.ack.wrong", (Object)this.getAddress(), (Object)new Integer(this.socket.getLocalPort())));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)sm.getString("IDataSender.ack.receive", (Object)this.getAddress(), (Object)new Integer(this.socket.getLocalPort())));
            }
        }
        catch (IOException x) {
            ++this.missingAckCounter;
            log.warn((Object)sm.getString("IDataSender.ack.missing", (Object)this.getAddress(), (Object)new Integer(this.socket.getLocalPort()), (Object)new Long(this.ackTimeout)), (Throwable)x);
            throw x;
        }
        finally {
            if (this.doWaitAckStats) {
                this.addWaitAckStats(time);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

