/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.mcast;

import java.net.InetAddress;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.MembershipListener;
import org.apache.catalina.cluster.MembershipService;
import org.apache.catalina.cluster.mcast.McastMember;
import org.apache.catalina.cluster.mcast.McastServiceImpl;
import org.apache.catalina.cluster.tcp.SimpleTcpCluster;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;

public class McastService
implements MembershipService,
MembershipListener {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$mcast$McastService == null ? (class$org$apache$catalina$cluster$mcast$McastService = McastService.class$("org.apache.catalina.cluster.mcast.McastService")) : class$org$apache$catalina$cluster$mcast$McastService));
    protected StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.mcast");
    private static final String info = "McastService/2.1";
    protected Properties properties = new Properties();
    protected McastServiceImpl impl;
    protected MembershipListener listener;
    protected McastMember localMember;
    private int mcastSoTimeout;
    private int mcastTTL;
    private SimpleTcpCluster cluster;
    private ObjectName objectName;
    private Registry registry;
    static /* synthetic */ Class class$org$apache$catalina$cluster$mcast$McastService;

    public McastService() {
        this.properties.setProperty("mcastClusterDomain", "catalina");
    }

    public String getInfo() {
        return info;
    }

    public void setObjectName(ObjectName name) {
        this.objectName = name;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setProperties(Properties properties) {
        this.hasProperty(properties, "mcastPort");
        this.hasProperty(properties, "mcastAddress");
        this.hasProperty(properties, "mcastClusterDomain");
        this.hasProperty(properties, "memberDropTime");
        this.hasProperty(properties, "msgFrequency");
        this.hasProperty(properties, "tcpListenPort");
        this.hasProperty(properties, "tcpListenHost");
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setCatalinaCluster(SimpleTcpCluster cluster) {
        this.cluster = cluster;
    }

    public Cluster getCatalinaCluster() {
        return this.cluster;
    }

    public String getLocalMemberName() {
        return this.localMember.toString();
    }

    public Member getLocalMember() {
        this.localMember.setMemberAliveTime(System.currentTimeMillis() - this.impl.getServiceStartTime());
        return this.localMember;
    }

    public void setLocalMemberProperties(String listenHost, int listenPort) {
        this.properties.setProperty("tcpListenHost", listenHost);
        this.properties.setProperty("tcpListenPort", String.valueOf(listenPort));
    }

    public void setMcastAddr(String addr) {
        this.properties.setProperty("mcastAddress", addr);
    }

    public String getMcastAddr() {
        return this.properties.getProperty("mcastAddress");
    }

    public void setMcastBindAddress(String bindaddr) {
        this.properties.setProperty("mcastBindAddress", bindaddr);
    }

    public String getMcastBindAddress() {
        return this.properties.getProperty("mcastBindAddress");
    }

    public void setMcastClusterDomain(String clusterDomain) {
        this.properties.setProperty("mcastClusterDomain", clusterDomain);
    }

    public String getMcastClusterDomain() {
        return this.properties.getProperty("mcastClusterDomain");
    }

    public void setMcastPort(int port) {
        this.properties.setProperty("mcastPort", String.valueOf(port));
    }

    public int getMcastPort() {
        String p = this.properties.getProperty("mcastPort");
        return new Integer(p);
    }

    public void setMcastFrequency(long time) {
        this.properties.setProperty("msgFrequency", String.valueOf(time));
    }

    public long getMcastFrequency() {
        String p = this.properties.getProperty("msgFrequency");
        return new Long(p);
    }

    public void setMcastDropTime(long time) {
        this.properties.setProperty("memberDropTime", String.valueOf(time));
    }

    public long getMcastDropTime() {
        String p = this.properties.getProperty("memberDropTime");
        return new Long(p);
    }

    protected void hasProperty(Properties properties, String name) {
        if (properties.getProperty(name) == null) {
            throw new IllegalArgumentException("Required property \"" + name + "\" is missing.");
        }
    }

    public void start() throws Exception {
        this.start(1);
        this.start(2);
        this.registerMBean();
    }

    public void start(int level) throws Exception {
        if (this.impl != null) {
            this.impl.start(level);
            return;
        }
        String host = this.getProperties().getProperty("tcpListenHost");
        String domain = this.getProperties().getProperty("mcastClusterDomain");
        int port = Integer.parseInt(this.getProperties().getProperty("tcpListenPort"));
        String name = "tcp://" + host + ":" + port;
        if (this.localMember == null) {
            this.localMember = new McastMember(name, domain, host, port, 100L);
        } else {
            this.localMember.setName(name);
            this.localMember.setDomain(domain);
            this.localMember.setHost(host);
            this.localMember.setPort(port);
            this.localMember.setMemberAliveTime(100L);
        }
        InetAddress bind = null;
        if (this.properties.getProperty("mcastBindAddress") != null) {
            bind = InetAddress.getByName(this.properties.getProperty("mcastBindAddress"));
        }
        int ttl = -1;
        int soTimeout = -1;
        if (this.properties.getProperty("mcastTTL") != null) {
            try {
                ttl = Integer.parseInt(this.properties.getProperty("mcastTTL"));
            }
            catch (Exception x) {
                log.error((Object)("Unable to parse mcastTTL=" + this.properties.getProperty("mcastTTL")), (Throwable)x);
            }
        }
        if (this.properties.getProperty("mcastSoTimeout") != null) {
            try {
                soTimeout = Integer.parseInt(this.properties.getProperty("mcastSoTimeout"));
            }
            catch (Exception x) {
                log.error((Object)("Unable to parse mcastSoTimeout=" + this.properties.getProperty("mcastSoTimeout")), (Throwable)x);
            }
        }
        this.impl = new McastServiceImpl(this.localMember, Long.parseLong(this.properties.getProperty("msgFrequency")), Long.parseLong(this.properties.getProperty("memberDropTime")), Integer.parseInt(this.properties.getProperty("mcastPort")), bind, InetAddress.getByName(this.properties.getProperty("mcastAddress")), ttl, soTimeout, this);
        this.impl.start(level);
        long memberwait = Long.parseLong(this.properties.getProperty("msgFrequency")) * 4L;
        if (log.isInfoEnabled()) {
            log.info((Object)("Sleeping for " + memberwait + " secs to establish cluster membership"));
        }
        Thread.sleep(memberwait);
    }

    public void stop() {
        try {
            if (this.impl != null) {
                this.impl.stop();
            }
        }
        catch (Exception x) {
            log.error((Object)"Unable to stop the mcast service.", (Throwable)x);
        }
        this.impl = null;
        this.unregisterMBean();
    }

    protected void initMBeans() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
            this.registry.loadMetadata((Object)this.getClass().getResourceAsStream("mbeans-descriptors.xml"));
        }
    }

    protected void registerMBean() {
        if (this.cluster != null) {
            ObjectName clusterName = this.cluster.getObjectName();
            try {
                ObjectName mcastName;
                MBeanServer mserver = this.cluster.getMBeanServer();
                this.initMBeans();
                Container container = this.cluster.getContainer();
                String name = clusterName.getDomain() + ":type=ClusterMembership";
                if (container instanceof StandardHost) {
                    name = name + ",host=" + clusterName.getKeyProperty("host");
                }
                if (mserver.isRegistered(mcastName = new ObjectName(name))) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)this.sm.getString("cluster.mbean.register.allready", (Object)mcastName));
                    }
                    return;
                }
                this.setObjectName(mcastName);
                mserver.registerMBean(this.cluster.getManagedBean(this), this.getObjectName());
                if (log.isInfoEnabled()) {
                    log.info((Object)("membership mbean registered (" + mcastName + ")"));
                }
            }
            catch (Exception e) {
                log.warn((Object)("membership mbean creation failed (" + clusterName + ")"), (Throwable)e);
            }
        }
    }

    protected void unregisterMBean() {
        if (this.cluster != null && this.getObjectName() != null) {
            try {
                MBeanServer mserver = this.cluster.getMBeanServer();
                mserver.unregisterMBean(this.getObjectName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public String[] getMembersByName() {
        String[] membernames;
        Member[] currentMembers = this.getMembers();
        if (currentMembers != null) {
            membernames = new String[currentMembers.length];
            for (int i = 0; i < currentMembers.length; ++i) {
                membernames[i] = currentMembers[i].toString();
            }
        } else {
            membernames = new String[]{};
        }
        return membernames;
    }

    public Member findMemberByName(String name) {
        Member[] currentMembers = this.getMembers();
        for (int i = 0; i < currentMembers.length; ++i) {
            if (!name.equals(currentMembers[i].toString())) continue;
            return currentMembers[i];
        }
        return null;
    }

    public boolean hasMembers() {
        if (this.impl == null || this.impl.membership == null) {
            return false;
        }
        return this.impl.membership.hasMembers();
    }

    public Member[] getMembers() {
        if (this.impl == null || this.impl.membership == null) {
            return null;
        }
        return this.impl.membership.getMembers();
    }

    public void addMembershipListener(MembershipListener listener) {
        this.listener = listener;
    }

    public void removeMembershipListener() {
        this.listener = null;
    }

    public void memberAdded(Member member) {
        if (this.listener != null) {
            this.listener.memberAdded(member);
        }
    }

    public void memberDisappeared(Member member) {
        if (this.listener != null) {
            this.listener.memberDisappeared(member);
        }
    }

    public int getMcastSoTimeout() {
        return this.mcastSoTimeout;
    }

    public void setMcastSoTimeout(int mcastSoTimeout) {
        this.mcastSoTimeout = mcastSoTimeout;
        this.properties.setProperty("mcastSoTimeout", String.valueOf(mcastSoTimeout));
    }

    public int getMcastTTL() {
        return this.mcastTTL;
    }

    public void setMcastTTL(int mcastTTL) {
        this.mcastTTL = mcastTTL;
        this.properties.setProperty("mcastTTL", String.valueOf(mcastTTL));
    }

    public static void main(String[] args) throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)"Usage McastService hostname tcpport");
        }
        McastService service = new McastService();
        Properties p = new Properties();
        p.setProperty("mcastPort", "5555");
        p.setProperty("mcastAddress", "224.10.10.10");
        p.setProperty("mcastClusterDomain", "catalina");
        p.setProperty("bindAddress", "localhost");
        p.setProperty("memberDropTime", "3000");
        p.setProperty("msgFrequency", "500");
        p.setProperty("tcpListenPort", args[1]);
        p.setProperty("tcpListenHost", args[0]);
        service.setProperties(p);
        service.start();
        Thread.sleep(3600000L);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

