/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.ClusterManager;
import org.apache.catalina.cluster.ClusterMessage;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.session.DeltaRequest;
import org.apache.catalina.cluster.session.DeltaSession;
import org.apache.catalina.cluster.session.ReplicationStream;
import org.apache.catalina.cluster.session.SessionMessage;
import org.apache.catalina.cluster.session.SessionMessageImpl;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.util.CustomObjectInputStream;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeltaManager
extends ManagerBase
implements Lifecycle,
PropertyChangeListener,
ClusterManager {
    public static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$session$DeltaManager == null ? (class$org$apache$catalina$cluster$session$DeltaManager = DeltaManager.class$("org.apache.catalina.cluster.session.DeltaManager")) : class$org$apache$catalina$cluster$session$DeltaManager));
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.session");
    private static final String info = "DeltaManager/2.0";
    private boolean started = false;
    protected static String managerName = "DeltaManager";
    protected String name = null;
    protected boolean defaultMode = false;
    private CatalinaCluster cluster = null;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private int maxActiveSessions = -1;
    private boolean expireSessionsOnShutdown = false;
    private boolean notifyListenersOnReplication = true;
    private boolean notifySessionListenersOnReplication = true;
    private boolean stateTransferred = false;
    private int stateTransferTimeout = 60;
    private boolean sendAllSessions = true;
    private boolean sendClusterDomainOnly = true;
    private int sendAllSessionsSize = 1000;
    private int sendAllSessionsWaitTime = 2000;
    private ArrayList receivedMessageQueue = new ArrayList();
    private boolean receiverQueue = false;
    private boolean stateTimestampDrop = true;
    private long stateTransferCreateSendTime;
    int rejectedSessions = 0;
    private long sessionReplaceCounter = 0L;
    long processingTime = 0L;
    private long counterReceive_EVT_GET_ALL_SESSIONS = 0L;
    private long counterSend_EVT_ALL_SESSION_DATA = 0L;
    private long counterReceive_EVT_ALL_SESSION_DATA = 0L;
    private long counterReceive_EVT_SESSION_CREATED = 0L;
    private long counterReceive_EVT_SESSION_EXPIRED = 0L;
    private long counterReceive_EVT_SESSION_ACCESSED = 0L;
    private long counterReceive_EVT_SESSION_DELTA = 0L;
    private long counterSend_EVT_GET_ALL_SESSIONS = 0L;
    private long counterSend_EVT_SESSION_CREATED = 0L;
    private long counterSend_EVT_SESSION_DELTA = 0L;
    private long counterSend_EVT_SESSION_ACCESSED = 0L;
    private long counterSend_EVT_SESSION_EXPIRED = 0L;
    private int counterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE = 0;
    private int counterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE = 0;
    private int counterNoStateTransfered = 0;
    static /* synthetic */ Class class$org$apache$catalina$cluster$session$DeltaManager;

    public String getInfo() {
        return info;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public long getCounterSend_EVT_GET_ALL_SESSIONS() {
        return this.counterSend_EVT_GET_ALL_SESSIONS;
    }

    public long getCounterSend_EVT_SESSION_ACCESSED() {
        return this.counterSend_EVT_SESSION_ACCESSED;
    }

    public long getCounterSend_EVT_SESSION_CREATED() {
        return this.counterSend_EVT_SESSION_CREATED;
    }

    public long getCounterSend_EVT_SESSION_DELTA() {
        return this.counterSend_EVT_SESSION_DELTA;
    }

    public long getCounterSend_EVT_SESSION_EXPIRED() {
        return this.counterSend_EVT_SESSION_EXPIRED;
    }

    public long getCounterSend_EVT_ALL_SESSION_DATA() {
        return this.counterSend_EVT_ALL_SESSION_DATA;
    }

    public int getCounterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE() {
        return this.counterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE;
    }

    public long getCounterReceive_EVT_ALL_SESSION_DATA() {
        return this.counterReceive_EVT_ALL_SESSION_DATA;
    }

    public long getCounterReceive_EVT_GET_ALL_SESSIONS() {
        return this.counterReceive_EVT_GET_ALL_SESSIONS;
    }

    public long getCounterReceive_EVT_SESSION_ACCESSED() {
        return this.counterReceive_EVT_SESSION_ACCESSED;
    }

    public long getCounterReceive_EVT_SESSION_CREATED() {
        return this.counterReceive_EVT_SESSION_CREATED;
    }

    public long getCounterReceive_EVT_SESSION_DELTA() {
        return this.counterReceive_EVT_SESSION_DELTA;
    }

    public long getCounterReceive_EVT_SESSION_EXPIRED() {
        return this.counterReceive_EVT_SESSION_EXPIRED;
    }

    public int getCounterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE() {
        return this.counterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public long getSessionReplaceCounter() {
        return this.sessionReplaceCounter;
    }

    public int getRejectedSessions() {
        return this.rejectedSessions;
    }

    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedSessions = rejectedSessions;
    }

    public int getCounterNoStateTransfered() {
        return this.counterNoStateTransfered;
    }

    public int getReceivedQueueSize() {
        return this.receivedMessageQueue.size();
    }

    public int getStateTransferTimeout() {
        return this.stateTransferTimeout;
    }

    public void setStateTransferTimeout(int timeoutAllSession) {
        this.stateTransferTimeout = timeoutAllSession;
    }

    public boolean getStateTransferred() {
        return this.stateTransferred;
    }

    public void setStateTransferred(boolean stateTransferred) {
        this.stateTransferred = stateTransferred;
    }

    public int getSendAllSessionsWaitTime() {
        return this.sendAllSessionsWaitTime;
    }

    public void setSendAllSessionsWaitTime(int sendAllSessionsWaitTime) {
        this.sendAllSessionsWaitTime = sendAllSessionsWaitTime;
    }

    public boolean isSendClusterDomainOnly() {
        return this.sendClusterDomainOnly;
    }

    public void setSendClusterDomainOnly(boolean sendClusterDomainOnly) {
        this.sendClusterDomainOnly = sendClusterDomainOnly;
    }

    public boolean isStateTimestampDrop() {
        return this.stateTimestampDrop;
    }

    public void setStateTimestampDrop(boolean isTimestampDrop) {
        this.stateTimestampDrop = isTimestampDrop;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public void setMaxActiveSessions(int max) {
        int oldMaxActiveSessions = this.maxActiveSessions;
        this.maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", new Integer(oldMaxActiveSessions), new Integer(this.maxActiveSessions));
    }

    public boolean isSendAllSessions() {
        return this.sendAllSessions;
    }

    public void setSendAllSessions(boolean sendAllSessions) {
        this.sendAllSessions = sendAllSessions;
    }

    public int getSendAllSessionsSize() {
        return this.sendAllSessionsSize;
    }

    public void setSendAllSessionsSize(int sendAllSessionsSize) {
        this.sendAllSessionsSize = sendAllSessionsSize;
    }

    public boolean isNotifySessionListenersOnReplication() {
        return this.notifySessionListenersOnReplication;
    }

    public void setNotifySessionListenersOnReplication(boolean notifyListenersCreateSessionOnReplication) {
        this.notifySessionListenersOnReplication = notifyListenersCreateSessionOnReplication;
    }

    public boolean isExpireSessionsOnShutdown() {
        return this.expireSessionsOnShutdown;
    }

    public void setExpireSessionsOnShutdown(boolean expireSessionsOnShutdown) {
        this.expireSessionsOnShutdown = expireSessionsOnShutdown;
    }

    public boolean isNotifyListenersOnReplication() {
        return this.notifyListenersOnReplication;
    }

    public void setNotifyListenersOnReplication(boolean notifyListenersOnReplication) {
        this.notifyListenersOnReplication = notifyListenersOnReplication;
    }

    public boolean isDefaultMode() {
        return this.defaultMode;
    }

    public void setDefaultMode(boolean defaultMode) {
        this.defaultMode = defaultMode;
    }

    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public Session createSession(String sessionId) {
        return this.createSession(sessionId, true);
    }

    public Session createSession(String sessionId, boolean distribute) {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            ++this.rejectedSessions;
            throw new IllegalStateException(sm.getString("deltaManager.createSession.ise"));
        }
        DeltaSession session = (DeltaSession)super.createSession(sessionId);
        session.resetDeltaRequest();
        if (distribute) {
            this.sendCreateSession(session.getId(), session);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.createSession.newSession", (Object)session.getId(), (Object)new Integer(this.sessions.size())));
        }
        return session;
    }

    protected void sendCreateSession(String sessionId, DeltaSession session) {
        if (this.cluster.getMembers().length > 0) {
            SessionMessageImpl msg = new SessionMessageImpl(this.getName(), 1, null, sessionId, sessionId + "-" + System.currentTimeMillis());
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("deltaManager.sendMessage.newSession", (Object)this.name, (Object)sessionId));
            }
            ++this.counterSend_EVT_SESSION_CREATED;
            this.send(msg);
        }
        session.resetDeltaRequest();
    }

    protected void send(SessionMessage msg) {
        if (this.cluster != null) {
            if (this.isSendClusterDomainOnly()) {
                this.cluster.sendClusterDomain(msg);
            } else {
                this.cluster.send(msg);
            }
        }
    }

    public Session createEmptySession() {
        return this.getNewDeltaSession();
    }

    protected DeltaSession getNewDeltaSession() {
        return new DeltaSession(this);
    }

    protected DeltaRequest loadDeltaRequest(DeltaSession session, byte[] data) throws ClassNotFoundException, IOException {
        ByteArrayInputStream fis = null;
        ReplicationStream ois = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        if (this.container != null) {
            loader = this.container.getLoader();
        }
        classLoader = loader != null ? loader.getClassLoader() : Thread.currentThread().getContextClassLoader();
        fis = new ByteArrayInputStream(data);
        ois = new ReplicationStream(fis, classLoader);
        session.getDeltaRequest().readExternal(ois);
        ois.close();
        return session.getDeltaRequest();
    }

    protected byte[] unloadDeltaRequest(DeltaRequest deltaRequest) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        deltaRequest.writeExternal(oos);
        oos.flush();
        oos.close();
        return bos.toByteArray();
    }

    /*
     * Loose catch block
     */
    protected void deserializeSessions(byte[] data) throws ClassNotFoundException, IOException {
        block17: {
            ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
            ObjectInputStream ois = null;
            ois = this.openDeserializeObjectStream(data);
            Integer count = (Integer)ois.readObject();
            int n = count;
            for (int i = 0; i < n; ++i) {
                DeltaSession session = (DeltaSession)this.createEmptySession();
                session.readObjectData(ois);
                session.setManager(this);
                session.setValid(true);
                session.setPrimarySession(false);
                session.access();
                session.setAccessCount(0);
                session.resetDeltaRequest();
                if (this.findSession(session.getIdInternal()) == null) {
                    ++this.sessionCounter;
                } else {
                    ++this.sessionReplaceCounter;
                    if (log.isWarnEnabled()) {
                        log.warn((Object)sm.getString("deltaManager.loading.existing.session", (Object)session.getIdInternal()));
                    }
                }
                this.add(session);
            }
            Object var9_10 = null;
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException f) {
                // empty catch block
            }
            ois = null;
            if (originalLoader != null) {
                Thread.currentThread().setContextClassLoader(originalLoader);
            }
            break block17;
            {
                catch (ClassNotFoundException e) {
                    log.error((Object)sm.getString("deltaManager.loading.cnfe", (Object)e), (Throwable)e);
                    throw e;
                }
                catch (IOException e) {
                    log.error((Object)sm.getString("deltaManager.loading.ioe", (Object)e), (Throwable)e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException f) {
                    // empty catch block
                }
                ois = null;
                if (originalLoader != null) {
                    Thread.currentThread().setContextClassLoader(originalLoader);
                }
                throw throwable;
            }
        }
    }

    protected ObjectInputStream openDeserializeObjectStream(byte[] data) throws IOException {
        ObjectInputStream ois = null;
        ByteArrayInputStream fis = null;
        try {
            Loader loader = null;
            ClassLoader classLoader = null;
            fis = new ByteArrayInputStream(data);
            BufferedInputStream bis = new BufferedInputStream(fis);
            if (this.container != null) {
                loader = this.container.getLoader();
            }
            if (loader != null) {
                classLoader = loader.getClassLoader();
            }
            if (classLoader != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("deltaManager.loading.withContextClassLoader", (Object)this.getName()));
                }
                ois = new CustomObjectInputStream((InputStream)bis, classLoader);
                Thread.currentThread().setContextClassLoader(classLoader);
            } else {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("deltaManager.loading.withoutClassLoader", (Object)this.getName()));
                }
                ois = new ObjectInputStream(bis);
            }
        }
        catch (IOException e) {
            log.error((Object)sm.getString("deltaManager.loading.ioe", (Object)e), (Throwable)e);
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException f) {
                    // empty catch block
                }
                ois = null;
            }
            throw e;
        }
        return ois;
    }

    /*
     * Loose catch block
     */
    protected byte[] serializeSessions(Session[] currentSessions) throws IOException {
        ByteArrayOutputStream fos;
        block9: {
            fos = null;
            ObjectOutputStream oos = null;
            fos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(new BufferedOutputStream(fos));
            oos.writeObject(new Integer(currentSessions.length));
            for (int i = 0; i < currentSessions.length; ++i) {
                ((DeltaSession)currentSessions[i]).writeObjectData(oos);
            }
            oos.flush();
            Object var6_6 = null;
            if (oos == null) break block9;
            try {
                oos.close();
            }
            catch (IOException f) {
                // empty catch block
            }
            oos = null;
            {
                break block9;
                catch (IOException e) {
                    log.error((Object)sm.getString("deltaManager.unloading.ioe", (Object)e), (Throwable)e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException f) {
                        // empty catch block
                    }
                    oos = null;
                }
                throw throwable;
            }
        }
        return fos.toByteArray();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.init();
        }
        if (this.started) {
            return;
        }
        this.started = true;
        this.lifecycle.fireLifecycleEvent("start", null);
        String dummy = this.generateSessionId();
        try {
            Container host;
            Container context;
            CatalinaCluster cluster = this.getCluster();
            if (cluster == null && (context = this.getContainer()) != null && context instanceof Context && (host = context.getParent()) != null && host instanceof Host) {
                cluster = host.getCluster();
                if (cluster != null && cluster instanceof CatalinaCluster) {
                    this.setCluster(cluster);
                } else {
                    Container engine = host.getParent();
                    if (engine != null && engine instanceof Engine) {
                        cluster = engine.getCluster();
                        if (cluster != null && cluster instanceof CatalinaCluster) {
                            this.setCluster(cluster);
                        }
                    } else {
                        cluster = null;
                    }
                }
            }
            if (cluster == null) {
                log.error((Object)sm.getString("deltaManager.noCluster", (Object)this.getName()));
                return;
            }
            if (log.isInfoEnabled()) {
                String type = "unknown";
                if (cluster.getContainer() instanceof Host) {
                    type = "Host";
                } else if (cluster.getContainer() instanceof Engine) {
                    type = "Engine";
                }
                log.info((Object)sm.getString("deltaManager.registerCluster", (Object)this.getName(), (Object)type, (Object)cluster.getClusterName()));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("deltaManager.startClustering", (Object)this.getName()));
            }
            cluster.addManager(this.getName(), this);
            this.getAllClusterSessions();
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("deltaManager.managerLoad"), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void getAllClusterSessions() {
        if (this.cluster != null && this.cluster.getMembers().length > 0) {
            ArrayList arrayList;
            long beforeSendTime = System.currentTimeMillis();
            Member mbr = this.findSessionMasterMember();
            if (mbr == null) {
                return;
            }
            SessionMessageImpl msg = new SessionMessageImpl(this.getName(), 4, null, "GET-ALL", "GET-ALL-" + this.getName());
            msg.setResend(0);
            msg.setTimestamp(beforeSendTime);
            this.stateTransferCreateSendTime = beforeSendTime;
            ++this.counterSend_EVT_GET_ALL_SESSIONS;
            this.stateTransferred = false;
            try {
                ArrayList arrayList2 = this.receivedMessageQueue;
                synchronized (arrayList2) {
                    this.receiverQueue = true;
                }
                this.cluster.send(msg, mbr);
                if (log.isWarnEnabled()) {
                    log.warn((Object)sm.getString("deltaManager.waitForSessionState", (Object)this.getName(), (Object)mbr));
                }
                this.waitForSendAllSessions(beforeSendTime);
                Object var8_6 = null;
                arrayList = this.receivedMessageQueue;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                ArrayList arrayList3 = this.receivedMessageQueue;
                synchronized (arrayList3) {
                    Iterator iter = this.receivedMessageQueue.iterator();
                    while (iter.hasNext()) {
                        SessionMessage smsg = (SessionMessage)iter.next();
                        if (!this.stateTimestampDrop) {
                            this.messageReceived(smsg, smsg.getAddress() != null ? smsg.getAddress() : null);
                            continue;
                        }
                        if (smsg.getEventType() != 4 && smsg.getTimestamp() >= this.stateTransferCreateSendTime) {
                            this.messageReceived(smsg, smsg.getAddress() != null ? smsg.getAddress() : null);
                            continue;
                        }
                        if (!log.isWarnEnabled()) continue;
                        log.warn((Object)sm.getString("deltaManager.dropMessage", (Object)this.getName(), (Object)smsg.getEventTypeString(), (Object)new Date(this.stateTransferCreateSendTime), (Object)new Date(smsg.getTimestamp())));
                    }
                    this.receivedMessageQueue.clear();
                    this.receiverQueue = false;
                }
                throw throwable;
            }
            synchronized (arrayList) {
                Iterator iter = this.receivedMessageQueue.iterator();
                while (iter.hasNext()) {
                    SessionMessage smsg = (SessionMessage)iter.next();
                    if (!this.stateTimestampDrop) {
                        this.messageReceived(smsg, smsg.getAddress() != null ? smsg.getAddress() : null);
                        continue;
                    }
                    if (smsg.getEventType() != 4 && smsg.getTimestamp() >= this.stateTransferCreateSendTime) {
                        this.messageReceived(smsg, smsg.getAddress() != null ? smsg.getAddress() : null);
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)sm.getString("deltaManager.dropMessage", (Object)this.getName(), (Object)smsg.getEventTypeString(), (Object)new Date(this.stateTransferCreateSendTime), (Object)new Date(smsg.getTimestamp())));
                }
                this.receivedMessageQueue.clear();
                this.receiverQueue = false;
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("deltaManager.noMembers", (Object)this.getName()));
        }
    }

    protected Member findSessionMasterMember() {
        Member mbr = null;
        Member[] mbrs = this.cluster.getMembers();
        String localMemberDomain = this.cluster.getMembershipService().getLocalMember().getDomain();
        if (this.isSendClusterDomainOnly()) {
            for (int i = 0; mbr == null && i < mbrs.length; ++i) {
                Member member = mbrs[i];
                if (!localMemberDomain.equals(member.getDomain())) continue;
                mbr = member;
            }
        } else if (mbrs.length != 0) {
            mbr = mbrs[0];
        }
        if (mbr == null && log.isWarnEnabled()) {
            log.warn((Object)sm.getString("deltaManager.noMasterMember", (Object)this.getName(), (Object)localMemberDomain));
        }
        if (mbr != null && log.isDebugEnabled()) {
            log.warn((Object)sm.getString("deltaManager.foundMasterMember", (Object)this.getName(), (Object)mbr));
        }
        return mbr;
    }

    protected void waitForSendAllSessions(long beforeSendTime) {
        long reqStart;
        long reqNow = reqStart = System.currentTimeMillis();
        boolean isTimeout = false;
        if (this.getStateTransferTimeout() > 0) {
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception sleep) {
                    // empty catch block
                }
                reqNow = System.currentTimeMillis();
                boolean bl = isTimeout = reqNow - reqStart > (long)(1000 * this.getStateTransferTimeout());
            } while (!this.getStateTransferred() && !isTimeout);
        } else if (this.getStateTransferTimeout() == -1) {
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception sleep) {
                    // empty catch block
                }
            } while (!this.getStateTransferred());
            reqNow = System.currentTimeMillis();
        }
        if (isTimeout || !this.getStateTransferred()) {
            ++this.counterNoStateTransfered;
            log.error((Object)sm.getString("deltaManager.noSessionState", (Object)this.getName(), (Object)new Date(beforeSendTime), (Object)new Long(reqNow - beforeSendTime)));
        } else if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("deltaManager.sessionReceived", (Object)this.getName(), (Object)new Date(beforeSendTime), (Object)new Long(reqNow - beforeSendTime)));
        }
    }

    public void stop() throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.stopped", (Object)this.getName()));
        }
        if (!this.started) {
            throw new LifecycleException(sm.getString("deltaManager.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("deltaManager.expireSessions", (Object)this.getName()));
        }
        Session[] sessions = this.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            DeltaSession session = (DeltaSession)sessions[i];
            if (!session.isValid()) continue;
            try {
                session.expire(true, this.isExpireSessionsOnShutdown());
                continue;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        this.random = null;
        this.getCluster().removeManager(this.getName(), this);
        if (this.initialized) {
            this.destroy();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        Context context = (Context)event.getSource();
        if (event.getPropertyName().equals("sessionTimeout")) {
            try {
                this.setMaxInactiveInterval((Integer)event.getNewValue() * 60);
            }
            catch (NumberFormatException e) {
                log.error((Object)sm.getString("deltaManager.sessionTimeout", event.getNewValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageDataReceived(ClusterMessage cmsg) {
        if (cmsg != null && cmsg instanceof SessionMessage) {
            SessionMessage msg = (SessionMessage)cmsg;
            switch (msg.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 13: {
                    ArrayList arrayList = this.receivedMessageQueue;
                    synchronized (arrayList) {
                        if (this.receiverQueue) {
                            this.receivedMessageQueue.add(msg);
                            return;
                        }
                        break;
                    }
                }
            }
            this.messageReceived(msg, msg.getAddress() != null ? msg.getAddress() : null);
        }
    }

    public ClusterMessage requestCompleted(String sessionId) {
        try {
            long replDelta;
            DeltaSession session = (DeltaSession)this.findSession(sessionId);
            DeltaRequest deltaRequest = session.getDeltaRequest();
            SessionMessageImpl msg = null;
            if (deltaRequest.getSize() > 0) {
                ++this.counterSend_EVT_SESSION_DELTA;
                byte[] data = this.unloadDeltaRequest(deltaRequest);
                msg = new SessionMessageImpl(this.name, 13, data, sessionId, sessionId + "-" + System.currentTimeMillis());
                session.resetDeltaRequest();
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("deltaManager.createMessage.delta", (Object)this.getName(), (Object)sessionId));
                }
            } else if (!session.isPrimarySession()) {
                ++this.counterSend_EVT_SESSION_ACCESSED;
                msg = new SessionMessageImpl(this.getName(), 3, null, sessionId, sessionId + "-" + System.currentTimeMillis());
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("deltaManager.createMessage.accessChangePrimary", (Object)this.getName(), (Object)sessionId));
                }
            }
            session.setPrimarySession(true);
            if (msg == null && (replDelta = System.currentTimeMillis() - session.getLastTimeReplicated()) > (long)(this.getMaxInactiveInterval() * 1000)) {
                ++this.counterSend_EVT_SESSION_ACCESSED;
                msg = new SessionMessageImpl(this.getName(), 3, null, sessionId, sessionId + "-" + System.currentTimeMillis());
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("deltaManager.createMessage.access", (Object)this.getName(), (Object)sessionId));
                }
            }
            if (msg != null) {
                session.setLastTimeReplicated(System.currentTimeMillis());
            }
            return msg;
        }
        catch (IOException x) {
            log.error((Object)sm.getString("deltaManager.createMessage.unableCreateDeltaRequest", (Object)sessionId), (Throwable)x);
            return null;
        }
    }

    public synchronized void resetStatistics() {
        this.processingTime = 0L;
        this.expiredSessions = 0;
        this.rejectedSessions = 0;
        this.sessionReplaceCounter = 0L;
        this.counterNoStateTransfered = 0;
        this.maxActive = this.getActiveSessions();
        this.sessionCounter = this.getActiveSessions();
        this.counterReceive_EVT_ALL_SESSION_DATA = 0L;
        this.counterReceive_EVT_GET_ALL_SESSIONS = 0L;
        this.counterReceive_EVT_SESSION_ACCESSED = 0L;
        this.counterReceive_EVT_SESSION_CREATED = 0L;
        this.counterReceive_EVT_SESSION_DELTA = 0L;
        this.counterReceive_EVT_SESSION_EXPIRED = 0L;
        this.counterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE = 0;
        this.counterSend_EVT_ALL_SESSION_DATA = 0L;
        this.counterSend_EVT_GET_ALL_SESSIONS = 0L;
        this.counterSend_EVT_SESSION_ACCESSED = 0L;
        this.counterSend_EVT_SESSION_CREATED = 0L;
        this.counterSend_EVT_SESSION_DELTA = 0L;
        this.counterSend_EVT_SESSION_EXPIRED = 0L;
        this.counterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE = 0;
    }

    public void load() {
    }

    public void unload() {
    }

    protected void sessionExpired(String id) {
        ++this.counterSend_EVT_SESSION_EXPIRED;
        SessionMessageImpl msg = new SessionMessageImpl(this.getName(), 2, null, id, id + "-EXPIRED-MSG");
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.createMessage.expire", (Object)this.getName(), (Object)id));
        }
        this.send(msg);
    }

    public void expireAllLocalSessions() {
        long timeNow = System.currentTimeMillis();
        Session[] sessions = this.findSessions();
        int expireDirect = 0;
        int expireIndirect = 0;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start expire all sessions " + this.getName() + " at " + timeNow + " sessioncount " + sessions.length));
        }
        for (int i = 0; i < sessions.length; ++i) {
            DeltaSession session;
            if (!(sessions[i] instanceof DeltaSession) || !(session = (DeltaSession)sessions[i]).isPrimarySession()) continue;
            if (session.isValid()) {
                session.expire();
                ++expireDirect;
                continue;
            }
            ++expireIndirect;
        }
        long timeEnd = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("End expire sessions " + this.getName() + " exipre processingTime " + (timeEnd - timeNow) + " expired direct sessions: " + expireDirect + " expired direct sessions: " + expireIndirect));
        }
    }

    public String[] getInvalidatedSessions() {
        return new String[0];
    }

    protected boolean checkSenderDomain(SessionMessage msg, Member sender) {
        String localMemberDomain = this.cluster.getMembershipService().getLocalMember().getDomain();
        boolean sameDomain = localMemberDomain.equals(sender.getDomain());
        if (!sameDomain && log.isWarnEnabled()) {
            log.warn((Object)sm.getString("deltaManager.receiveMessage.fromWrongDomain", new Object[]{this.getName(), msg.getEventTypeString(), sender, sender.getDomain(), localMemberDomain}));
        }
        return sameDomain;
    }

    protected void messageReceived(SessionMessage msg, Member sender) {
        if (this.isSendClusterDomainOnly() && !this.checkSenderDomain(msg, sender)) {
            return;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("deltaManager.receiveMessage.eventType", (Object)this.getName(), (Object)msg.getEventTypeString(), (Object)sender));
            }
            switch (msg.getEventType()) {
                case 4: {
                    this.handleGET_ALL_SESSIONS(msg, sender);
                    break;
                }
                case 12: {
                    this.handleALL_SESSION_DATA(msg, sender);
                    break;
                }
                case 14: {
                    this.handleALL_SESSION_TRANSFERCOMPLETE(msg, sender);
                    break;
                }
                case 1: {
                    this.handleSESSION_CREATED(msg, sender);
                    break;
                }
                case 2: {
                    this.handleSESSION_EXPIRRED(msg, sender);
                    break;
                }
                case 3: {
                    this.handleSESSION_ACCESSED(msg, sender);
                    break;
                }
                case 13: {
                    this.handleSESSION_DELTA(msg, sender);
                    break;
                }
            }
        }
        catch (Exception x) {
            log.error((Object)sm.getString("deltaManager.receiveMessage.error", (Object)this.getName()), (Throwable)x);
        }
    }

    protected void handleALL_SESSION_TRANSFERCOMPLETE(SessionMessage msg, Member sender) {
        ++this.counterReceive_EVT_ALL_SESSION_TRANSFERCOMPLETE;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.receiveMessage.transfercomplete", (Object)this.getName(), (Object)sender.getHost(), (Object)new Integer(sender.getPort())));
        }
        this.stateTransferCreateSendTime = msg.getTimestamp();
        this.stateTransferred = true;
    }

    protected void handleSESSION_DELTA(SessionMessage msg, Member sender) throws IOException, ClassNotFoundException {
        ++this.counterReceive_EVT_SESSION_DELTA;
        byte[] delta = msg.getSession();
        DeltaSession session = (DeltaSession)this.findSession(msg.getSessionID());
        if (session != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("deltaManager.receiveMessage.delta", (Object)this.getName(), (Object)msg.getSessionID()));
            }
            DeltaRequest dreq = this.loadDeltaRequest(session, delta);
            dreq.execute(session, this.notifyListenersOnReplication);
            session.setPrimarySession(false);
        }
    }

    protected void handleSESSION_ACCESSED(SessionMessage msg, Member sender) throws IOException {
        ++this.counterReceive_EVT_SESSION_ACCESSED;
        DeltaSession session = (DeltaSession)this.findSession(msg.getSessionID());
        if (session != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("deltaManager.receiveMessage.accessed", (Object)this.getName(), (Object)msg.getSessionID()));
            }
            session.access();
            session.setPrimarySession(false);
            session.endAccess();
        }
    }

    protected void handleSESSION_EXPIRRED(SessionMessage msg, Member sender) throws IOException {
        ++this.counterReceive_EVT_SESSION_EXPIRED;
        DeltaSession session = (DeltaSession)this.findSession(msg.getSessionID());
        if (session != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("deltaManager.receiveMessage.expired", (Object)this.getName(), (Object)msg.getSessionID()));
            }
            session.expire(this.notifySessionListenersOnReplication, false);
        }
    }

    protected void handleSESSION_CREATED(SessionMessage msg, Member sender) {
        ++this.counterReceive_EVT_SESSION_CREATED;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.receiveMessage.createNewSession", (Object)this.getName(), (Object)msg.getSessionID()));
        }
        DeltaSession session = (DeltaSession)this.createEmptySession();
        session.setManager(this);
        session.setValid(true);
        session.setPrimarySession(false);
        session.access();
        if (this.notifySessionListenersOnReplication) {
            session.setId(msg.getSessionID());
        } else {
            session.setIdInternal(msg.getSessionID());
        }
        session.resetDeltaRequest();
        session.endAccess();
    }

    protected void handleALL_SESSION_DATA(SessionMessage msg, Member sender) throws ClassNotFoundException, IOException {
        ++this.counterReceive_EVT_ALL_SESSION_DATA;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.receiveMessage.allSessionDataBegin", (Object)this.getName()));
        }
        byte[] data = msg.getSession();
        this.deserializeSessions(data);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.receiveMessage.allSessionDataAfter", (Object)this.getName()));
        }
    }

    protected void handleGET_ALL_SESSIONS(SessionMessage msg, Member sender) throws IOException {
        ++this.counterReceive_EVT_GET_ALL_SESSIONS;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.receiveMessage.unloadingBegin", (Object)this.getName()));
        }
        Session[] currentSessions = this.findSessions();
        long findSessionTimestamp = System.currentTimeMillis();
        if (this.isSendAllSessions()) {
            this.sendSessions(sender, currentSessions, findSessionTimestamp);
        } else {
            int len = currentSessions.length < this.getSendAllSessionsSize() ? currentSessions.length : this.getSendAllSessionsSize();
            Session[] sendSessions = new Session[len];
            for (int i = 0; i < currentSessions.length; i += this.getSendAllSessionsSize()) {
                len = i + this.getSendAllSessionsSize() > currentSessions.length ? currentSessions.length - i : this.getSendAllSessionsSize();
                System.arraycopy(currentSessions, i, sendSessions, 0, len);
                this.sendSessions(sender, sendSessions, findSessionTimestamp);
                if (this.getSendAllSessionsWaitTime() <= 0) continue;
                try {
                    Thread.sleep(this.getSendAllSessionsWaitTime());
                    continue;
                }
                catch (Exception sleep) {
                    // empty catch block
                }
            }
        }
        SessionMessageImpl newmsg = new SessionMessageImpl(this.name, 14, null, "SESSION-STATE-TRANSFERED", "SESSION-STATE-TRANSFERED" + this.getName());
        newmsg.setTimestamp(findSessionTimestamp);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.createMessage.allSessionTransfered", (Object)this.getName()));
        }
        ++this.counterSend_EVT_ALL_SESSION_TRANSFERCOMPLETE;
        this.cluster.send(newmsg, sender);
    }

    protected void sendSessions(Member sender, Session[] currentSessions, long sendTimestamp) throws IOException {
        byte[] data = this.serializeSessions(currentSessions);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.receiveMessage.unloadingAfter", (Object)this.getName()));
        }
        SessionMessageImpl newmsg = new SessionMessageImpl(this.name, 12, data, "SESSION-STATE", "SESSION-STATE-" + this.getName());
        newmsg.setTimestamp(sendTimestamp);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("deltaManager.createMessage.allSessionData", (Object)this.getName()));
        }
        ++this.counterSend_EVT_ALL_SESSION_DATA;
        this.cluster.send(newmsg, sender);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

