/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.ClusterDeployer;
import org.apache.catalina.cluster.ClusterManager;
import org.apache.catalina.cluster.ClusterMessage;
import org.apache.catalina.cluster.ClusterReceiver;
import org.apache.catalina.cluster.ClusterSender;
import org.apache.catalina.cluster.ClusterValve;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.MembershipListener;
import org.apache.catalina.cluster.MembershipService;
import org.apache.catalina.cluster.MessageListener;
import org.apache.catalina.cluster.mcast.McastService;
import org.apache.catalina.cluster.session.ClusterSessionListener;
import org.apache.catalina.cluster.session.DeltaManager;
import org.apache.catalina.cluster.tcp.ReplicationTransmitter;
import org.apache.catalina.cluster.tcp.ReplicationValve;
import org.apache.catalina.cluster.tcp.SendMessageData;
import org.apache.catalina.cluster.tcp.SocketReplicationListener;
import org.apache.catalina.cluster.util.IDynamicProperty;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;
import org.apache.tomcat.util.IntrospectionUtils;

public class SimpleTcpCluster
implements CatalinaCluster,
Lifecycle,
MembershipListener,
LifecycleListener,
IDynamicProperty {
    public static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$SimpleTcpCluster == null ? (class$org$apache$catalina$cluster$tcp$SimpleTcpCluster = SimpleTcpCluster.class$("org.apache.catalina.cluster.tcp.SimpleTcpCluster")) : class$org$apache$catalina$cluster$tcp$SimpleTcpCluster));
    protected static final String info = "SimpleTcpCluster/2.2";
    public static final String BEFORE_MEMBERREGISTER_EVENT = "before_member_register";
    public static final String AFTER_MEMBERREGISTER_EVENT = "after_member_register";
    public static final String BEFORE_MANAGERREGISTER_EVENT = "before_manager_register";
    public static final String AFTER_MANAGERREGISTER_EVENT = "after_manager_register";
    public static final String BEFORE_MANAGERUNREGISTER_EVENT = "before_manager_unregister";
    public static final String AFTER_MANAGERUNREGISTER_EVENT = "after_manager_unregister";
    public static final String BEFORE_MEMBERUNREGISTER_EVENT = "before_member_unregister";
    public static final String AFTER_MEMBERUNREGISTER_EVENT = "after_member_unregister";
    public static final String SEND_MESSAGE_FAILURE_EVENT = "send_message_failure";
    public static final String RECEIVE_MESSAGE_FAILURE_EVENT = "receive_message_failure";
    protected MembershipService membershipService = null;
    protected String clusterImpName = "SimpleTcpCluster";
    protected StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.tcp");
    protected String clusterName;
    protected Container container = null;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private MBeanServer mserver = null;
    private Registry registry = null;
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Map managers = new HashMap();
    private String managerClassName = "org.apache.catalina.cluster.session.DeltaManager";
    private ClusterSender clusterSender;
    private ClusterReceiver clusterReceiver;
    private List valves = new ArrayList();
    private ClusterDeployer clusterDeployer;
    private boolean defaultMode = true;
    protected List clusterListeners = new ArrayList();
    private boolean notifyLifecycleListenerOnFailure = false;
    private ObjectName objectName = null;
    private Map properties = new HashMap();
    private String clusterLogName = "org.apache.catalina.cluster.tcp.SimpleTcpCluster";
    private boolean doClusterLog = false;
    private Log clusterLog = null;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$SimpleTcpCluster;
    static /* synthetic */ Class class$org$apache$catalina$Valve;

    public String getInfo() {
        return info;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        if (this.clusterName == null && this.container != null) {
            return this.container.getName();
        }
        return this.clusterName;
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public Container getContainer() {
        return this.container;
    }

    public boolean isNotifyLifecycleListenerOnFailure() {
        return this.notifyLifecycleListenerOnFailure;
    }

    public void setNotifyLifecycleListenerOnFailure(boolean notifyListenerOnFailure) {
        boolean oldNotifyListenerOnFailure = this.notifyLifecycleListenerOnFailure;
        this.notifyLifecycleListenerOnFailure = notifyListenerOnFailure;
        this.support.firePropertyChange("notifyLifecycleListenerOnFailure", oldNotifyListenerOnFailure, this.notifyLifecycleListenerOnFailure);
    }

    public boolean isDefaultMode() {
        return this.defaultMode;
    }

    public void setDefaultMode(boolean defaultMode) {
        this.defaultMode = defaultMode;
    }

    public String getManagerClassName() {
        if (this.managerClassName != null) {
            return this.managerClassName;
        }
        return (String)this.getProperty("manager.className");
    }

    public void setManagerClassName(String managerClassName) {
        this.managerClassName = managerClassName;
    }

    public ClusterSender getClusterSender() {
        return this.clusterSender;
    }

    public void setClusterSender(ClusterSender clusterSender) {
        this.clusterSender = clusterSender;
    }

    public ClusterReceiver getClusterReceiver() {
        return this.clusterReceiver;
    }

    public void setClusterReceiver(ClusterReceiver clusterReceiver) {
        this.clusterReceiver = clusterReceiver;
    }

    public MembershipService getMembershipService() {
        return this.membershipService;
    }

    public void setMembershipService(MembershipService membershipService) {
        this.membershipService = membershipService;
    }

    public void addValve(Valve valve) {
        if (valve instanceof ClusterValve) {
            this.valves.add(valve);
        }
    }

    public Valve[] getValves() {
        return this.valves.toArray(new Valve[this.valves.size()]);
    }

    public MessageListener[] findClusterListeners() {
        if (this.clusterListeners.size() > 0) {
            MessageListener[] listener = new MessageListener[this.clusterListeners.size()];
            this.clusterListeners.toArray(listener);
            return listener;
        }
        return new MessageListener[0];
    }

    public void addClusterListener(MessageListener listener) {
        if (listener != null && !this.clusterListeners.contains(listener)) {
            this.clusterListeners.add(listener);
            listener.setCluster(this);
        }
    }

    public void removeClusterListener(MessageListener listener) {
        if (listener != null) {
            this.clusterListeners.remove(listener);
            listener.setCluster(null);
        }
    }

    public ClusterDeployer getClusterDeployer() {
        return this.clusterDeployer;
    }

    public void setClusterDeployer(ClusterDeployer clusterDeployer) {
        this.clusterDeployer = clusterDeployer;
    }

    public boolean hasMembers() {
        return this.membershipService.hasMembers();
    }

    public Member[] getMembers() {
        return this.membershipService.getMembers();
    }

    public Member getLocalMember() {
        return this.membershipService.getLocalMember();
    }

    public void setProperty(String name, String value) {
        this.setProperty(name, (Object)value);
    }

    public void setProperty(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)this.sm.getString("SimpleTcpCluster.setProperty", (Object)name, value, this.properties.get(name)));
        }
        this.properties.put(name, value);
        if (this.started && name.startsWith("manager")) {
            String key = name.substring("manager".length() + 1);
            String pvalue = value.toString();
            Iterator iter = this.managers.values().iterator();
            while (iter.hasNext()) {
                Manager manager = (Manager)iter.next();
                if (!(manager instanceof DeltaManager) || !((ClusterManager)manager).isDefaultMode()) continue;
                IntrospectionUtils.setProperty((Object)manager, (String)key, (String)pvalue);
            }
        }
    }

    public Object getProperty(String key) {
        if (log.isTraceEnabled()) {
            log.trace((Object)this.sm.getString("SimpleTcpCluster.getProperty", (Object)key));
        }
        return this.properties.get(key);
    }

    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    protected void transferProperty(String prefix, Object bean) {
        if (prefix != null) {
            Iterator iter = this.getPropertyNames();
            while (iter.hasNext()) {
                String pkey = (String)iter.next();
                if (!pkey.startsWith(prefix)) continue;
                String key = pkey.substring(prefix.length() + 1);
                Object value = this.getProperty(pkey);
                IntrospectionUtils.setProperty((Object)bean, (String)key, (String)value.toString());
            }
        }
    }

    public Map getManagers() {
        return this.managers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Manager createManager(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating ClusterManager for context " + name + " using class " + this.getManagerClassName()));
        }
        Manager manager = null;
        try {
            try {
                manager = (Manager)this.getClass().getClassLoader().loadClass(this.getManagerClassName()).newInstance();
            }
            catch (Exception x) {
                log.error((Object)"Unable to load class for replication manager", (Throwable)x);
                manager = new DeltaManager();
                Object var5_4 = null;
                if (manager == null) return manager;
                manager.setDistributable(true);
                if (!(manager instanceof ClusterManager)) return manager;
                ClusterManager cmanager = (ClusterManager)manager;
                cmanager.setDefaultMode(true);
                cmanager.setName(this.getManagerName(name, manager));
                cmanager.setCluster(this);
                return manager;
            }
            Object var5_3 = null;
            if (manager == null) return manager;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (manager == null) throw throwable;
            manager.setDistributable(true);
            if (!(manager instanceof ClusterManager)) throw throwable;
            ClusterManager cmanager = (ClusterManager)manager;
            cmanager.setDefaultMode(true);
            cmanager.setName(this.getManagerName(name, manager));
            cmanager.setCluster(this);
            throw throwable;
        }
        manager.setDistributable(true);
        if (!(manager instanceof ClusterManager)) return manager;
        ClusterManager cmanager = (ClusterManager)manager;
        cmanager.setDefaultMode(true);
        cmanager.setName(this.getManagerName(name, manager));
        cmanager.setCluster(this);
        return manager;
    }

    public void removeManager(String name, Manager manager) {
        if (manager != null) {
            this.lifecycle.fireLifecycleEvent(BEFORE_MANAGERUNREGISTER_EVENT, (Object)manager);
            this.managers.remove(this.getManagerName(name, manager));
            if (manager instanceof ClusterManager) {
                ((ClusterManager)manager).setCluster(null);
            }
            this.lifecycle.fireLifecycleEvent(AFTER_MANAGERUNREGISTER_EVENT, (Object)manager);
        }
    }

    public void addManager(String name, Manager manager) {
        if (!manager.getDistributable()) {
            log.warn((Object)("Manager with name " + name + " is not distributable, can't add as cluster manager"));
            return;
        }
        this.lifecycle.fireLifecycleEvent(BEFORE_MANAGERREGISTER_EVENT, (Object)manager);
        String clusterName = this.getManagerName(name, manager);
        if (manager instanceof ClusterManager) {
            ClusterManager cmanager = (ClusterManager)manager;
            cmanager.setName(clusterName);
            cmanager.setCluster(this);
            if (cmanager.isDefaultMode()) {
                this.transferProperty("manager", cmanager);
            }
        }
        this.managers.put(clusterName, manager);
        this.lifecycle.fireLifecycleEvent(AFTER_MANAGERREGISTER_EVENT, (Object)manager);
    }

    private String getManagerName(String name, Manager manager) {
        Container host;
        Container context;
        String clusterName = name;
        if (this.getContainer() instanceof Engine && (context = manager.getContainer()) != null && context instanceof Context && (host = ((Context)context).getParent()) != null && host instanceof Host) {
            clusterName = host.getName() + name;
        }
        return clusterName;
    }

    public Manager getManager(String name) {
        return (Manager)this.managers.get(name);
    }

    public void backgroundProcess() {
        if (this.clusterDeployer != null) {
            this.clusterDeployer.backgroundProcess();
        }
        if (this.clusterSender != null) {
            this.clusterSender.backgroundProcess();
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if (log.isTraceEnabled()) {
            log.trace((Object)this.sm.getString("SimpleTcpCluster.event.log", (Object)lifecycleEvent.getType(), lifecycleEvent.getData()));
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("cluster.alreadyStarted"));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Cluster is about to start");
        }
        this.getClusterLog();
        this.lifecycle.fireLifecycleEvent("before_start", (Object)this);
        try {
            if (this.isDefaultMode() && this.valves.size() == 0) {
                this.createDefaultClusterValves();
            }
            this.registerClusterValve();
            this.registerMBeans();
            if (this.isDefaultMode() && this.clusterListeners.size() == 0) {
                this.createDefaultClusterListener();
            }
            if (this.isDefaultMode() && this.clusterReceiver == null) {
                this.createDefaultClusterReceiver();
            }
            if (this.isDefaultMode() && this.clusterSender == null) {
                this.createDefaultClusterSender();
            }
            if (this.clusterReceiver != null) {
                this.clusterReceiver.setSendAck(this.clusterSender.isWaitForAck());
                this.clusterReceiver.setCompress(this.clusterSender.isCompress());
                this.clusterReceiver.setCatalinaCluster(this);
                this.clusterReceiver.start();
            }
            if (this.clusterSender != null && this.clusterReceiver != null) {
                this.clusterSender.setCatalinaCluster(this);
                this.clusterSender.start();
            }
            if (this.isDefaultMode() && this.membershipService == null) {
                this.createDefaultMembershipService();
            }
            if (this.membershipService != null && this.clusterReceiver != null) {
                this.membershipService.setLocalMemberProperties(this.clusterReceiver.getHost(), this.clusterReceiver.getPort());
                this.membershipService.addMembershipListener(this);
                this.membershipService.setCatalinaCluster(this);
                this.membershipService.start();
                try {
                    if (this.clusterDeployer != null) {
                        this.clusterDeployer.setCluster(this);
                        this.clusterDeployer.start();
                    }
                }
                catch (Throwable x) {
                    log.fatal((Object)"Unable to retrieve the container deployer. Cluster deployment disabled.", x);
                }
            }
            this.started = true;
            this.lifecycle.fireLifecycleEvent("after_start", (Object)this);
        }
        catch (Exception x) {
            log.error((Object)"Unable to start cluster.", (Throwable)x);
            throw new LifecycleException((Throwable)x);
        }
    }

    protected void createDefaultMembershipService() {
        if (log.isInfoEnabled()) {
            log.info((Object)this.sm.getString("SimpleTcpCluster.default.addMembershipService", (Object)this.getClusterName()));
        }
        McastService mService = new McastService();
        mService.setMcastAddr("228.0.0.4");
        mService.setMcastPort(8012);
        mService.setMcastFrequency(1000L);
        mService.setMcastDropTime(30000L);
        this.transferProperty("service", mService);
        this.setMembershipService(mService);
    }

    protected void createDefaultClusterSender() {
        if (log.isInfoEnabled()) {
            log.info((Object)this.sm.getString("SimpleTcpCluster.default.addClusterSender", (Object)this.getClusterName()));
        }
        ReplicationTransmitter sender = new ReplicationTransmitter();
        sender.setReplicationMode("fastasyncqueue");
        sender.setDoTransmitterProcessingStats(true);
        sender.setProperty("doProcessingStats", "true");
        this.transferProperty("sender", sender);
        this.setClusterSender(sender);
    }

    protected void createDefaultClusterReceiver() {
        if (log.isInfoEnabled()) {
            log.info((Object)this.sm.getString("SimpleTcpCluster.default.addClusterReceiver", (Object)this.getClusterName()));
        }
        SocketReplicationListener receiver = new SocketReplicationListener();
        receiver.setTcpListenAddress("auto");
        receiver.setDoReceivedProcessingStats(true);
        receiver.setTcpListenPort(8015);
        receiver.setTcpListenMaxPort(8019);
        this.transferProperty("receiver", receiver);
        this.setClusterReceiver(receiver);
    }

    protected void createDefaultClusterListener() {
        if (log.isInfoEnabled()) {
            log.info((Object)this.sm.getString("SimpleTcpCluster.default.addClusterListener", (Object)this.getClusterName()));
        }
        ClusterSessionListener listener = new ClusterSessionListener();
        this.transferProperty("listener", listener);
        this.addClusterListener(listener);
    }

    protected void createDefaultClusterValves() {
        if (log.isInfoEnabled()) {
            log.info((Object)this.sm.getString("SimpleTcpCluster.default.addClusterValves", (Object)this.getClusterName()));
        }
        ReplicationValve valve = new ReplicationValve();
        valve.setFilter(".*\\.gif;.*\\.js;.*\\.css;.*\\.png;.*\\.jpeg;.*\\.jpg;.*\\.htm;.*\\.html;.*\\.txt;");
        valve.setPrimaryIndicator(true);
        this.transferProperty("valve", valve);
        this.addValve((Valve)valve);
    }

    protected void registerClusterValve() throws Exception {
        Iterator iter = this.valves.iterator();
        while (iter.hasNext()) {
            ClusterValve valve = (ClusterValve)iter.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoking addValve on " + this.getContainer() + " with class=" + valve.getClass().getName()));
            }
            if (valve != null) {
                IntrospectionUtils.callMethodN((Object)this.getContainer(), (String)"addValve", (Object[])new Object[]{valve}, (Class[])new Class[]{class$org$apache$catalina$Valve == null ? SimpleTcpCluster.class$("org.apache.catalina.Valve") : class$org$apache$catalina$Valve});
            }
            valve.setCluster(this);
        }
    }

    protected void unregisterClusterValve() throws Exception {
        Iterator iter = this.valves.iterator();
        while (iter.hasNext()) {
            ClusterValve valve = (ClusterValve)iter.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoking removeValve on " + this.getContainer() + " with class=" + valve.getClass().getName()));
            }
            if (valve != null) {
                IntrospectionUtils.callMethodN((Object)this.getContainer(), (String)"removeValve", (Object[])new Object[]{valve}, (Class[])new Class[]{class$org$apache$catalina$Valve == null ? SimpleTcpCluster.class$("org.apache.catalina.Valve") : class$org$apache$catalina$Valve});
            }
            valve.setCluster(this);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new IllegalStateException(this.sm.getString("cluster.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("before_stop", (Object)this);
        if (this.clusterDeployer != null) {
            this.clusterDeployer.stop();
        }
        if (this.membershipService != null) {
            this.membershipService.stop();
            this.membershipService.removeMembershipListener();
        }
        if (this.clusterSender != null) {
            try {
                this.clusterSender.stop();
            }
            catch (Exception x) {
                log.error((Object)"Unable to stop cluster sender.", (Throwable)x);
            }
        }
        if (this.clusterReceiver != null) {
            try {
                this.clusterReceiver.stop();
                this.clusterReceiver.setCatalinaCluster(null);
            }
            catch (Exception x) {
                log.error((Object)"Unable to stop cluster receiver.", (Throwable)x);
            }
        }
        this.unregisterMBeans();
        try {
            this.unregisterClusterValve();
        }
        catch (Exception x) {
            log.error((Object)"Unable to stop cluster valve.", (Throwable)x);
        }
        this.started = false;
        this.lifecycle.fireLifecycleEvent("after_stop", (Object)this);
        this.clusterLog = null;
    }

    public void sendClusterDomain(ClusterMessage msg) {
        long start = 0L;
        if (this.doClusterLog) {
            start = System.currentTimeMillis();
        }
        try {
            msg.setAddress(this.membershipService.getLocalMember());
            this.clusterSender.sendMessageClusterDomain(msg);
        }
        catch (Exception x) {
            if (this.notifyLifecycleListenerOnFailure) {
                this.lifecycle.fireLifecycleEvent(SEND_MESSAGE_FAILURE_EVENT, (Object)new SendMessageData(msg, null, x));
            }
            log.error((Object)"Unable to send message through cluster sender.", (Throwable)x);
        }
        if (this.doClusterLog) {
            this.logSendMessage(msg, start, null);
        }
    }

    public void send(ClusterMessage msg) {
        this.send(msg, null);
    }

    public void sendToMember(ClusterMessage msg, String dest) {
        Member member = this.getMembershipService().findMemberByName(dest);
        if (member != null) {
            this.send(msg, member);
        } else {
            log.error((Object)("sendToMember: member " + dest + " not found!"));
        }
    }

    public void send(ClusterMessage msg, Member dest) {
        long start = 0L;
        if (this.doClusterLog) {
            start = System.currentTimeMillis();
        }
        try {
            msg.setAddress(this.membershipService.getLocalMember());
            if (dest != null) {
                if (!this.membershipService.getLocalMember().equals(dest)) {
                    this.clusterSender.sendMessage(msg, dest);
                } else {
                    log.error((Object)("Unable to send message to local member " + msg));
                }
            } else {
                this.clusterSender.sendMessage(msg);
            }
        }
        catch (Exception x) {
            if (this.notifyLifecycleListenerOnFailure) {
                this.lifecycle.fireLifecycleEvent(SEND_MESSAGE_FAILURE_EVENT, (Object)new SendMessageData(msg, dest, x));
            }
            log.error((Object)"Unable to send message through cluster sender.", (Throwable)x);
        }
        if (this.doClusterLog) {
            this.logSendMessage(msg, start, dest);
        }
    }

    public void memberAdded(Member member) {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)("Replication member added:" + member));
            }
            this.lifecycle.fireLifecycleEvent(BEFORE_MEMBERREGISTER_EVENT, (Object)member);
            this.clusterSender.add(member);
            this.lifecycle.fireLifecycleEvent(AFTER_MEMBERREGISTER_EVENT, (Object)member);
        }
        catch (Exception x) {
            log.error((Object)"Unable to connect to replication system.", (Throwable)x);
        }
    }

    public void memberDisappeared(Member member) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Received member disappeared:" + member));
        }
        try {
            this.lifecycle.fireLifecycleEvent(BEFORE_MEMBERUNREGISTER_EVENT, (Object)member);
            this.clusterSender.remove(member);
            this.lifecycle.fireLifecycleEvent(AFTER_MEMBERUNREGISTER_EVENT, (Object)member);
        }
        catch (Exception x) {
            log.error((Object)"Unable remove cluster node from replication system.", (Throwable)x);
        }
    }

    public void receive(ClusterMessage message) {
        long start = 0L;
        if (this.doClusterLog) {
            start = System.currentTimeMillis();
        }
        if (log.isDebugEnabled() && message != null) {
            log.debug((Object)("Assuming clocks are synched: Replication for " + message.getUniqueId() + " took=" + (System.currentTimeMillis() - message.getTimestamp()) + " ms."));
        }
        boolean accepted = false;
        if (message != null) {
            Iterator iter = this.clusterListeners.iterator();
            while (iter.hasNext()) {
                MessageListener listener = (MessageListener)iter.next();
                if (!listener.accept(message)) continue;
                accepted = true;
                listener.messageReceived(message);
            }
        }
        if (!accepted && log.isDebugEnabled()) {
            if (this.notifyLifecycleListenerOnFailure) {
                Member dest = message.getAddress();
                this.lifecycle.fireLifecycleEvent(RECEIVE_MESSAGE_FAILURE_EVENT, (Object)new SendMessageData(message, dest, null));
            }
            log.debug((Object)("Message " + message.toString() + " from type " + message.getClass().getName() + " transfered but no listener registered"));
        }
        if (this.doClusterLog) {
            this.logReceiveMessage(message, start, accepted);
        }
    }

    public String getClusterLogName() {
        return this.clusterLogName;
    }

    public void setClusterLogName(String clusterLogName) {
        this.clusterLogName = clusterLogName;
    }

    public boolean isDoClusterLog() {
        return this.doClusterLog;
    }

    public void setDoClusterLog(boolean doClusterLog) {
        this.doClusterLog = doClusterLog;
    }

    public Log getLogger() {
        return log;
    }

    public Log getClusterLog() {
        if (this.clusterLog == null && this.clusterLogName != null && !"".equals(this.clusterLogName)) {
            this.clusterLog = LogFactory.getLog((String)this.clusterLogName);
        }
        return this.clusterLog;
    }

    protected void logReceiveMessage(ClusterMessage message, long start, boolean accepted) {
        if (this.clusterLog != null && this.clusterLog.isInfoEnabled()) {
            this.clusterLog.info((Object)this.sm.getString("SimpleTcpCluster.log.receive", new Object[]{new Date(start), new Long(System.currentTimeMillis() - start), message.getAddress().getHost(), new Integer(message.getAddress().getPort()), message.getUniqueId(), new Boolean(accepted)}));
        }
    }

    protected void logSendMessage(ClusterMessage message, long start, Member dest) {
        if (this.clusterLog != null && this.clusterLog.isInfoEnabled()) {
            if (dest != null) {
                this.clusterLog.info((Object)this.sm.getString("SimpleTcpCluster.log.send", new Object[]{new Date(start), new Long(System.currentTimeMillis() - start), dest.getHost(), new Integer(dest.getPort()), message.getUniqueId()}));
            } else {
                this.clusterLog.info((Object)this.sm.getString("SimpleTcpCluster.log.send.all", new Object[]{new Date(start), new Long(System.currentTimeMillis() - start), message.getUniqueId()}));
            }
        }
    }

    protected void registerMBeans() {
        try {
            this.getMBeanServer();
            String domain = this.mserver.getDefaultDomain();
            String name = ":type=Cluster";
            if (this.container instanceof StandardHost) {
                domain = ((StandardHost)this.container).getDomain();
                name = name + ",host=" + this.container.getName();
            } else if (this.container instanceof StandardEngine) {
                domain = ((StandardEngine)this.container).getDomain();
            }
            ObjectName clusterName = new ObjectName(domain + name);
            if (this.mserver.isRegistered(clusterName)) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)this.sm.getString("cluster.mbean.register.allready", (Object)clusterName));
                }
                return;
            }
            this.setObjectName(clusterName);
            this.mserver.registerMBean(this.getManagedBean(this), this.getObjectName());
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void unregisterMBeans() {
        if (this.mserver != null) {
            try {
                this.mserver.unregisterMBean(this.getObjectName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public MBeanServer getMBeanServer() throws Exception {
        if (this.mserver == null) {
            this.mserver = MBeanServerFactory.findMBeanServer(null).size() > 0 ? MBeanServerFactory.findMBeanServer(null).get(0) : MBeanServerFactory.createMBeanServer();
            this.registry = Registry.getRegistry(null, null);
            this.registry.loadMetadata((Object)this.getClass().getResourceAsStream("mbeans-descriptors.xml"));
        }
        return this.mserver;
    }

    public ModelMBean getManagedBean(Object object) throws Exception {
        ModelMBean mbean = null;
        if (this.registry != null) {
            ManagedBean managedBean = this.registry.findManagedBean(object.getClass().getName());
            mbean = managedBean.createMBean(object);
        }
        return mbean;
    }

    public void setObjectName(ObjectName name) {
        this.objectName = name;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setProtocol(String protocol) {
    }

    public String getProtocol() {
        return null;
    }

    public void startContext(String contextPath) throws IOException {
    }

    public void installContext(String contextPath, URL war) {
    }

    public void stop(String contextPath) throws IOException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

