/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public final class ReplicationStream
extends ObjectInputStream {
    private ClassLoader classLoader = null;

    public ReplicationStream(InputStream stream, ClassLoader classLoader) throws IOException {
        super(stream);
        this.classLoader = classLoader;
    }

    public Class resolveClass(ObjectStreamClass classDesc) throws ClassNotFoundException, IOException {
        String name = classDesc.getName();
        boolean tryRepFirst = name.startsWith("org.apache.catalina.cluster");
        try {
            if (tryRepFirst) {
                return this.findReplicationClass(name);
            }
            return this.findWebappClass(name);
        }
        catch (Exception x) {
            if (tryRepFirst) {
                return this.findWebappClass(name);
            }
            return this.findReplicationClass(name);
        }
    }

    public Class findReplicationClass(String name) throws ClassNotFoundException, IOException {
        return Class.forName(name, false, this.getClass().getClassLoader());
    }

    public Class findWebappClass(String name) throws ClassNotFoundException, IOException {
        return Class.forName(name, false, this.classLoader);
    }
}

