/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSender
implements IDataSender {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$DataSender == null ? (class$org$apache$catalina$cluster$tcp$DataSender = DataSender.class$("org.apache.catalina.cluster.tcp.DataSender")) : class$org$apache$catalina$cluster$tcp$DataSender));
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.tcp");
    private static final String info = "DataSender/1.2";
    private InetAddress address;
    private int port;
    private Socket sc = null;
    private boolean isSocketConnected = false;
    private boolean suspect;
    private long ackTimeout;
    protected long nrOfRequests = 0L;
    protected long totalBytes = 0L;
    protected long connectCounter = 0L;
    protected long disconnectCounter = 0L;
    protected long missingAckCounter = 0L;
    protected long dataResendCounter = 0L;
    protected boolean doProcessingStats = false;
    protected long processingTime = 0L;
    protected long minProcessingTime = Long.MAX_VALUE;
    protected long maxProcessingTime = 0L;
    private long keepAliveTimeout = 60000L;
    private int keepAliveMaxRequestCount = 100;
    private long keepAliveConnectTime = 0L;
    private int keepAliveCount = 0;
    private boolean waitForAck = true;
    private int socketCloseCounter;
    private int socketOpenCounter;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$DataSender;

    public DataSender(InetAddress host, int port) {
        this.address = host;
        this.port = port;
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("IDataSender.create", (Object)this.address, (Object)new Integer(port)));
        }
    }

    public String getInfo() {
        return info;
    }

    public long getNrOfRequests() {
        return this.nrOfRequests;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getAvgProcessingTime() {
        return this.processingTime / this.nrOfRequests;
    }

    public long getMaxProcessingTime() {
        return this.maxProcessingTime;
    }

    public long getMinProcessingTime() {
        return this.minProcessingTime;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public boolean isDoProcessingStats() {
        return this.doProcessingStats;
    }

    public void setDoProcessingStats(boolean doProcessingStats) {
        this.doProcessingStats = doProcessingStats;
    }

    public long getConnectCounter() {
        return this.connectCounter;
    }

    public long getDisconnectCounter() {
        return this.disconnectCounter;
    }

    public long getMissingAckCounter() {
        return this.missingAckCounter;
    }

    public int getSocketOpenCounter() {
        return this.socketOpenCounter;
    }

    public int getSocketCloseCounter() {
        return this.socketCloseCounter;
    }

    public long getDataResendCounter() {
        return this.dataResendCounter;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isConnected() {
        return this.isSocketConnected;
    }

    protected void setSocketConnected(boolean isSocketConnected) {
        this.isSocketConnected = isSocketConnected;
    }

    public boolean isSuspect() {
        return this.suspect;
    }

    public boolean getSuspect() {
        return this.suspect;
    }

    public void setSuspect(boolean suspect) {
        this.suspect = suspect;
    }

    public long getAckTimeout() {
        return this.ackTimeout;
    }

    public void setAckTimeout(long ackTimeout) {
        this.ackTimeout = ackTimeout;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public int getKeepAliveMaxRequestCount() {
        return this.keepAliveMaxRequestCount;
    }

    public void setKeepAliveMaxRequestCount(int keepAliveMaxRequestCount) {
        this.keepAliveMaxRequestCount = keepAliveMaxRequestCount;
    }

    public long getKeepAliveConnectTime() {
        return this.keepAliveConnectTime;
    }

    public int getKeepAliveCount() {
        return this.keepAliveCount;
    }

    public boolean isWaitForAck() {
        return this.waitForAck;
    }

    public void setWaitForAck(boolean waitForAck) {
        this.waitForAck = waitForAck;
    }

    public void connect() throws IOException {
        ++this.connectCounter;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("IDataSender.connect", (Object)this.address.getHostAddress(), (Object)new Integer(this.port)));
        }
        this.openSocket();
    }

    public void disconnect() {
        ++this.disconnectCounter;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("IDataSender.disconnect", (Object)this.address.getHostAddress(), (Object)new Integer(this.port)));
        }
        this.closeSocket();
    }

    public boolean checkIfCloseSocket() {
        boolean isCloseSocket = true;
        long ctime = System.currentTimeMillis() - this.keepAliveConnectTime;
        if (this.keepAliveTimeout > -1L && ctime > this.keepAliveTimeout || this.keepAliveMaxRequestCount > -1 && this.keepAliveCount >= this.keepAliveMaxRequestCount) {
            this.closeSocket();
        } else {
            isCloseSocket = false;
        }
        return isCloseSocket;
    }

    public synchronized void sendMessage(String messageid, byte[] data) throws IOException {
        this.pushMessage(messageid, data);
    }

    public synchronized void resetStatistics() {
        this.nrOfRequests = 0L;
        this.totalBytes = 0L;
        this.disconnectCounter = 0L;
        this.connectCounter = this.isConnected() ? 1L : 0L;
        this.missingAckCounter = 0L;
        this.dataResendCounter = 0L;
        this.socketOpenCounter = this.isConnected() ? 1 : 0;
        this.socketCloseCounter = 0;
        this.processingTime = 0L;
        this.minProcessingTime = Long.MAX_VALUE;
        this.maxProcessingTime = 0L;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("DataSender[");
        buf.append(this.getAddress()).append(":").append(this.getPort()).append("]");
        return buf.toString();
    }

    protected void openSocket() throws IOException, SocketException {
        ++this.socketOpenCounter;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("IDataSender.openSocket", (Object)this.address.getHostAddress(), (Object)new Integer(this.port)));
        }
        this.sc = new Socket(this.getAddress(), this.getPort());
        if (this.isWaitForAck()) {
            this.sc.setSoTimeout((int)this.ackTimeout);
        }
        this.isSocketConnected = true;
        this.keepAliveCount = 0;
        this.keepAliveConnectTime = System.currentTimeMillis();
    }

    protected void closeSocket() {
        if (this.isSocketConnected) {
            ++this.socketCloseCounter;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("IDataSender.closeSocket", (Object)this.address.getHostAddress(), (Object)new Integer(this.port)));
            }
            try {
                this.sc.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isSocketConnected = false;
        }
    }

    protected void addStats(int length) {
        ++this.nrOfRequests;
        this.totalBytes += (long)length;
        if (log.isDebugEnabled() && this.nrOfRequests % 100L == 0L) {
            log.debug((Object)sm.getString("IDataSender.stats", new Object[]{this.getAddress().getHostAddress(), new Integer(this.getPort()), new Long(this.totalBytes), new Long(this.nrOfRequests), new Long(this.totalBytes / this.nrOfRequests), new Long(this.getProcessingTime()), new Long(this.getAvgProcessingTime())}));
        }
    }

    protected void addProcessingStats(long startTime) {
        long time = System.currentTimeMillis() - startTime;
        if (time < this.minProcessingTime) {
            this.minProcessingTime = time;
        }
        if (time > this.maxProcessingTime) {
            this.maxProcessingTime = time;
        }
        this.processingTime += time;
    }

    protected synchronized void pushMessage(String messageid, byte[] data) throws IOException {
        long time;
        block8: {
            time = 0L;
            if (this.doProcessingStats) {
                time = System.currentTimeMillis();
            }
            this.checkIfCloseSocket();
            if (!this.isConnected()) {
                this.openSocket();
            }
            try {
                this.sc.getOutputStream().write(data);
                this.sc.getOutputStream().flush();
                if (this.isWaitForAck()) {
                    this.waitForAck(this.ackTimeout);
                }
            }
            catch (IOException x) {
                ++this.dataResendCounter;
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("IDataSender.send.again", (Object)this.address.getHostAddress(), (Object)new Integer(this.port)));
                }
                this.closeSocket();
                this.openSocket();
                this.sc.getOutputStream().write(data);
                this.sc.getOutputStream().flush();
                if (!this.isWaitForAck()) break block8;
                this.waitForAck(this.ackTimeout);
            }
        }
        ++this.keepAliveCount;
        this.checkIfCloseSocket();
        if (this.doProcessingStats) {
            this.addProcessingStats(time);
        }
        this.addStats(data.length);
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("IDataSender.send.message", (Object)this.address.getHostAddress(), (Object)new Integer(this.port), (Object)messageid, (Object)new Long(data.length)));
        }
    }

    protected void waitForAck(long timeout) throws IOException {
        try {
            int i = this.sc.getInputStream().read();
            while (i != -1 && i != 3) {
                i = this.sc.getInputStream().read();
            }
        }
        catch (SocketTimeoutException x) {
            ++this.missingAckCounter;
            log.warn((Object)sm.getString("IDataSender.missing.ack", (Object)this.getAddress(), (Object)new Integer(this.getPort()), (Object)new Long(this.ackTimeout)));
            throw x;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

