/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.catalina.cluster.tcp.DataSender;
import org.apache.catalina.cluster.util.FastQueue;
import org.apache.catalina.cluster.util.IQueue;
import org.apache.catalina.cluster.util.LinkObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastAsyncSocketSender
extends DataSender {
    private static int threadCounter = 1;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$FastAsyncSocketSender == null ? (class$org$apache$catalina$cluster$tcp$FastAsyncSocketSender = FastAsyncSocketSender.class$("org.apache.catalina.cluster.tcp.FastAsyncSocketSender")) : class$org$apache$catalina$cluster$tcp$FastAsyncSocketSender));
    private static final String info = "FastAsyncSocketSender/1.1";
    private FastQueue queue = new FastQueue();
    private FastQueueThread queueThread = null;
    private long inQueueCounter = 0L;
    private long outQueueCounter = 0L;
    private long queuedNrOfBytes = 0L;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$FastAsyncSocketSender;

    public FastAsyncSocketSender(InetAddress host, int port) {
        super(host, port);
        this.checkThread();
    }

    public String getInfo() {
        return info;
    }

    public long getQueueAddWaitTimeout() {
        return this.queue.getAddWaitTimeout();
    }

    public void setQueueAddWaitTimeout(long timeout) {
        this.queue.setAddWaitTimeout(timeout);
    }

    public long getQueueRemoveWaitTimeout() {
        return this.queue.getRemoveWaitTimeout();
    }

    public void setRemoveWaitTimeout(long timeout) {
        this.queue.setRemoveWaitTimeout(timeout);
    }

    public boolean isQueueCheckLock() {
        return this.queue.isCheckLock();
    }

    public void setQueueCheckLock(boolean checkLock) {
        this.queue.setCheckLock(checkLock);
    }

    public boolean isQueueDoStats() {
        return this.queue.isDoStats();
    }

    public void setQueueDoStats(boolean doStats) {
        this.queue.setDoStats(doStats);
    }

    public boolean isQueueTimeWait() {
        return this.queue.isTimeWait();
    }

    public void setQueueTimeWait(boolean timeWait) {
        this.queue.setTimeWait(timeWait);
    }

    public int getMaxQueueLength() {
        return this.queue.getMaxQueueLength();
    }

    public void setMaxQueueLength(int length) {
        this.queue.setMaxQueueLength(length);
    }

    public long getQueueAddWaitTime() {
        return this.queue.getAddWait();
    }

    public long getQueueRemoveWaitTime() {
        return this.queue.getRemoveWait();
    }

    public long getInQueueCounter() {
        return this.inQueueCounter;
    }

    public long getOutQueueCounter() {
        return this.outQueueCounter;
    }

    public int getQueueSize() {
        return this.queue.getSize();
    }

    public long getQueuedNrOfBytes() {
        return this.queuedNrOfBytes;
    }

    public void connect() throws IOException {
        super.connect();
        this.checkThread();
        this.queue.start();
    }

    public void disconnect() {
        this.stopThread();
        this.queue.stop();
        super.disconnect();
    }

    public synchronized void sendMessage(String messageid, byte[] data) throws IOException {
        this.queue.add(messageid, data);
        ++this.inQueueCounter;
        this.queuedNrOfBytes += (long)data.length;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("AsyncSocketSender.queue.message", (Object)this.getAddress().getHostAddress(), (Object)new Integer(this.getPort()), (Object)messageid, (Object)new Long(data.length)));
        }
    }

    public synchronized void resetStatistics() {
        super.resetStatistics();
        this.inQueueCounter = this.queue.getSize();
        this.outQueueCounter = 0L;
        this.queue.resetStatistics();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("FastAsyncSocketSender[");
        buf.append(this.getAddress().getHostAddress()).append(":").append(this.getPort()).append("]");
        return buf.toString();
    }

    protected void checkThread() {
        if (this.queueThread == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("AsyncSocketSender.create.thread", (Object)this.getAddress(), (Object)new Integer(this.getPort())));
            }
            this.queueThread = new FastQueueThread(this, this.queue);
            this.queueThread.setDaemon(true);
            this.queueThread.start();
        }
    }

    protected void stopThread() {
        if (this.queueThread != null) {
            this.queueThread.stopRunning();
            this.queueThread = null;
        }
    }

    protected void reduceQueuedCounter(int size) {
        this.queuedNrOfBytes -= (long)size;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FastQueueThread
    extends Thread {
        private IQueue queue = null;
        private FastAsyncSocketSender sender = null;
        private boolean keepRunning = true;

        private FastQueueThread(FastAsyncSocketSender sender, IQueue queue) {
            this.setName("Cluster-FastAsyncSocketSender-" + threadCounter++);
            this.queue = queue;
            this.sender = sender;
        }

        public void stopRunning() {
            this.keepRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.keepRunning) {
                LinkObject entry = this.queue.remove();
                if (entry != null) {
                    do {
                        int messagesize = 0;
                        try {
                            byte[] data = (byte[])entry.data();
                            messagesize = data.length;
                            this.sender.pushMessage((String)entry.getKey(), data);
                            FastAsyncSocketSender.this.outQueueCounter++;
                        }
                        catch (Exception x) {
                            log.warn((Object)DataSender.sm.getString("AsyncSocketSender.send.error", entry.getKey()), (Throwable)x);
                        }
                        finally {
                            FastAsyncSocketSender.this.reduceQueuedCounter(messagesize);
                        }
                    } while ((entry = entry.next()) != null);
                    continue;
                }
                log.error((Object)DataSender.sm.getString("AsyncSocketSender.queue.empty", (Object)this.sender.getAddress(), (Object)new Integer(this.sender.getPort())));
            }
        }
    }
}

