/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.tcp.AsyncSocketSender;
import org.apache.catalina.cluster.tcp.FastAsyncSocketSender;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.catalina.cluster.tcp.PooledSocketSender;
import org.apache.catalina.cluster.tcp.SocketSender;

public class IDataSenderFactory {
    public static final String SYNC_MODE = "synchronous";
    public static final String ASYNC_MODE = "asynchronous";
    public static final String POOLED_SYNC_MODE = "pooled";
    public static final String FAST_ASYNC_QUEUE_MODE = "fastasyncqueue";

    private IDataSenderFactory() {
    }

    public static synchronized IDataSender getIDataSender(String mode, Member mbr) throws IOException {
        if (SYNC_MODE.equals(mode)) {
            return new SocketSender(InetAddress.getByName(mbr.getHost()), mbr.getPort());
        }
        if (ASYNC_MODE.equals(mode)) {
            return new AsyncSocketSender(InetAddress.getByName(mbr.getHost()), mbr.getPort());
        }
        if (FAST_ASYNC_QUEUE_MODE.equals(mode)) {
            return new FastAsyncSocketSender(InetAddress.getByName(mbr.getHost()), mbr.getPort());
        }
        if (POOLED_SYNC_MODE.equals(mode)) {
            return new PooledSocketSender(InetAddress.getByName(mbr.getHost()), mbr.getPort());
        }
        throw new IOException("Invalid replication mode=" + mode);
    }

    public static String validateMode(String mode) {
        if (SYNC_MODE.equals(mode) || ASYNC_MODE.equals(mode) || FAST_ASYNC_QUEUE_MODE.equals(mode) || POOLED_SYNC_MODE.equals(mode)) {
            return null;
        }
        return "Replication mode has to be 'synchronous', 'fastasyncqueue', 'asynchronous' or 'pooled'";
    }
}

