/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.catalina.cluster.io.Jdk13ObjectReader;
import org.apache.catalina.cluster.io.ListenCallback;
import org.apache.catalina.cluster.tcp.ThreadPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Jdk13ReplicationListener
implements Runnable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$Jdk13ReplicationListener == null ? (class$org$apache$catalina$cluster$tcp$Jdk13ReplicationListener = Jdk13ReplicationListener.class$("org.apache.catalina.cluster.tcp.Jdk13ReplicationListener")) : class$org$apache$catalina$cluster$tcp$Jdk13ReplicationListener));
    private ThreadPool pool = null;
    private boolean doListen = false;
    private ListenCallback callback;
    private InetAddress bind;
    private int port;
    private long timeout = 0L;
    ServerSocket serverSocket = null;
    private boolean sendAck = true;
    private boolean compress = true;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$Jdk13ReplicationListener;

    public Jdk13ReplicationListener(ListenCallback callback, int poolSize, InetAddress bind, int port, long timeout, boolean sendAck) {
        this.sendAck = sendAck;
        this.callback = callback;
        this.bind = bind;
        this.port = port;
        this.timeout = timeout;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isSendAck() {
        return this.sendAck;
    }

    public void setSendAck(boolean sendAck) {
        this.sendAck = sendAck;
    }

    public void run() {
        try {
            this.listen();
        }
        catch (Exception x) {
            log.fatal((Object)"Unable to start cluster listener.", (Throwable)x);
        }
    }

    public void listen() throws Exception {
        this.doListen = true;
        this.serverSocket = new ServerSocket();
        this.serverSocket.bind(new InetSocketAddress(this.bind, this.port));
        while (this.doListen) {
            Socket socket = this.serverSocket.accept();
            ClusterListenThread t = new ClusterListenThread(socket, new Jdk13ObjectReader(socket, this.callback, this.compress), this.sendAck);
            t.setDaemon(true);
            t.start();
        }
        this.serverSocket.close();
    }

    public void stopListening() {
        this.doListen = false;
        try {
            this.serverSocket.close();
        }
        catch (Exception x) {
            log.error((Object)"Unable to stop the replication listen socket", (Throwable)x);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class ClusterListenThread
    extends Thread {
        private Socket socket;
        private Jdk13ObjectReader reader;
        private boolean keepRunning = true;
        private boolean sendAck;
        private static byte[] ACK_COMMAND = new byte[]{6, 2, 3};

        ClusterListenThread(Socket socket, Jdk13ObjectReader reader, boolean sendAck) {
            this.socket = socket;
            this.reader = reader;
            this.sendAck = sendAck;
        }

        public void run() {
            try {
                byte[] buffer = new byte[1024];
                while (this.keepRunning) {
                    InputStream in = this.socket.getInputStream();
                    int cnt = in.read(buffer);
                    int ack = 0;
                    if (cnt > 0) {
                        ack = this.reader.append(buffer, 0, cnt);
                    }
                    if (!this.sendAck) continue;
                    while (ack > 0) {
                        this.sendAck();
                        --ack;
                    }
                }
            }
            catch (Exception x) {
                this.keepRunning = false;
                log.error((Object)"Unable to read data from client, disconnecting.", (Throwable)x);
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void sendAck() throws IOException {
            this.socket.getOutputStream().write(ACK_COMMAND);
        }
    }
}

