/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.cluster.ClusterSender;
import org.apache.catalina.cluster.Member;
import org.apache.catalina.cluster.io.XByteBuffer;
import org.apache.catalina.cluster.tcp.IDataSender;
import org.apache.catalina.cluster.tcp.IDataSenderFactory;
import org.apache.catalina.cluster.tcp.SimpleTcpCluster;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;

public class ReplicationTransmitter
implements ClusterSender {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$ReplicationTransmitter == null ? (class$org$apache$catalina$cluster$tcp$ReplicationTransmitter = ReplicationTransmitter.class$("org.apache.catalina.cluster.tcp.ReplicationTransmitter")) : class$org$apache$catalina$cluster$tcp$ReplicationTransmitter));
    private static final String info = "ReplicationTransmitter/1.3";
    protected StringManager sm = StringManager.getManager((String)"org.apache.catalina.cluster.tcp");
    private Map map = new HashMap();
    private long nrOfRequests = 0L;
    private long totalBytes = 0L;
    private long failureCounter = 0L;
    private String replicationMode;
    private long ackTimeout = 15000L;
    private boolean waitForAck = true;
    private boolean autoConnect = true;
    private boolean compress = true;
    private Map properties = new HashMap();
    private SimpleTcpCluster cluster;
    private ObjectName objectName;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$ReplicationTransmitter;

    public String getInfo() {
        return info;
    }

    public long getNrOfRequests() {
        return this.nrOfRequests;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getFailureCounter() {
        return this.failureCounter;
    }

    public String getReplicationMode() {
        return this.replicationMode;
    }

    public void setReplicationMode(String mode) {
        String msg = IDataSenderFactory.validateMode(mode);
        if (msg == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting replcation mode to " + mode));
            }
        } else {
            throw new IllegalArgumentException(msg);
        }
        this.replicationMode = mode;
    }

    public void setObjectName(ObjectName name) {
        this.objectName = name;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compressMessageData) {
        this.compress = compressMessageData;
    }

    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    public void setAutoConnect(boolean autoConnect) {
        this.autoConnect = autoConnect;
        this.setProperty("autoConnect", String.valueOf(autoConnect));
    }

    public long getAckTimeout() {
        return this.ackTimeout;
    }

    public void setAckTimeout(long ackTimeout) {
        this.ackTimeout = ackTimeout;
        this.setProperty("ackTimeout", String.valueOf(ackTimeout));
    }

    public boolean isWaitForAck() {
        return this.waitForAck;
    }

    public void setWaitForAck(boolean waitForAck) {
        this.waitForAck = waitForAck;
        this.setProperty("waitForAck", String.valueOf(waitForAck));
    }

    public void setCatalinaCluster(SimpleTcpCluster cluster) {
        this.cluster = cluster;
    }

    public boolean getIsSenderSynchronized() {
        return "synchronous".equals(this.replicationMode) || "pooled".equals(this.replicationMode);
    }

    public void setProperty(String name, Object value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)this.sm.getString("ReplicationTransmitter.setProperty", (Object)name, value));
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String key) {
        if (log.isTraceEnabled()) {
            log.trace((Object)this.sm.getString("ReplicationTransmitter.getProperty", (Object)key));
        }
        return this.properties.get(key);
    }

    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public void sendMessage(String sessionId, byte[] indata, Member member) throws IOException {
        byte[] data = this.convertSenderData(indata);
        String key = this.getKey(member);
        IDataSender sender = (IDataSender)this.map.get(key);
        this.sendMessageData(sessionId, data, sender);
    }

    public void sendMessage(String sessionId, byte[] indata) throws IOException {
        IDataSender[] senders = this.getSenders();
        byte[] data = this.convertSenderData(indata);
        for (int i = 0; i < senders.length; ++i) {
            IDataSender sender = senders[i];
            try {
                this.sendMessageData(sessionId, data, sender);
                continue;
            }
            catch (Exception x) {
                if (!sender.getSuspect()) {
                    log.warn((Object)("Unable to send replicated message to " + sender + ", is server down?"), (Throwable)x);
                }
                sender.setSuspect(true);
            }
        }
    }

    public void start() throws IOException {
        if (this.cluster != null) {
            ObjectName clusterName = this.cluster.getObjectName();
            try {
                MBeanServer mserver = this.cluster.getMBeanServer();
                ObjectName transmitterName = new ObjectName(clusterName.getDomain() + ":type=ClusterSender,host=" + clusterName.getKeyProperty("host"));
                if (mserver.isRegistered(transmitterName)) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)this.sm.getString("cluster.mbean.register.allready", (Object)transmitterName));
                    }
                    return;
                }
                this.setObjectName(transmitterName);
                mserver.registerMBean(this.cluster.getManagedBean(this), this.getObjectName());
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
        }
    }

    public synchronized void stop() {
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            IDataSender sender = (IDataSender)i.next().getValue();
            try {
                this.unregisterSenderMBean(sender);
                sender.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            i.remove();
        }
        if (this.cluster != null && this.getObjectName() != null) {
            try {
                MBeanServer mserver = this.cluster.getMBeanServer();
                mserver.unregisterMBean(this.getObjectName());
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }

    public IDataSender[] getSenders() {
        Iterator iter = this.map.entrySet().iterator();
        IDataSender[] array = new IDataSender[this.map.size()];
        int i = 0;
        while (iter.hasNext()) {
            IDataSender sender = (IDataSender)iter.next().getValue();
            if (sender != null) {
                array[i] = sender;
            }
            ++i;
        }
        return array;
    }

    public ObjectName[] getSenderObjectNames() {
        Iterator iter = this.map.entrySet().iterator();
        ObjectName[] array = new ObjectName[this.map.size()];
        int i = 0;
        while (iter.hasNext()) {
            IDataSender sender = (IDataSender)iter.next().getValue();
            if (sender != null) {
                array[i] = this.getSenderObjectName(sender);
            }
            ++i;
        }
        return array;
    }

    public synchronized void resetStatistics() {
        this.nrOfRequests = 0L;
        this.totalBytes = 0L;
        this.failureCounter = 0L;
    }

    public synchronized void add(Member member) {
        try {
            String key = this.getKey(member);
            if (!this.map.containsKey(key)) {
                IDataSender sender = IDataSenderFactory.getIDataSender(this.replicationMode, member);
                this.transferSenderProperty(sender);
                this.map.put(key, sender);
                this.registerSenderMBean(member, sender);
            }
        }
        catch (IOException x) {
            log.error((Object)"Unable to create and add a IDataSender object.", (Throwable)x);
        }
    }

    public synchronized void remove(Member member) {
        String key = this.getKey(member);
        IDataSender toberemoved = (IDataSender)this.map.get(key);
        if (toberemoved == null) {
            return;
        }
        this.unregisterSenderMBean(toberemoved);
        toberemoved.disconnect();
        this.map.remove(key);
    }

    protected synchronized void addStats(int length) {
        ++this.nrOfRequests;
        this.totalBytes += (long)length;
        if (log.isDebugEnabled() && this.nrOfRequests % 100L == 0L) {
            log.debug((Object)("Nr of bytes sent=" + this.totalBytes + " over " + this.nrOfRequests + "; avg=" + this.totalBytes / this.nrOfRequests + " bytes/request; failures=" + this.failureCounter));
        }
    }

    protected void transferSenderProperty(IDataSender sender) {
        Iterator iter = this.getPropertyNames();
        while (iter.hasNext()) {
            String pkey = (String)iter.next();
            Object value = this.getProperty(pkey);
            IntrospectionUtils.setProperty((Object)sender, (String)pkey, (String)value.toString());
        }
    }

    protected String getKey(Member member) {
        return member.getHost() + ":" + member.getPort();
    }

    protected void unregisterSenderMBean(IDataSender sender) {
        try {
            MBeanServer mserver = this.cluster.getMBeanServer();
            if (mserver != null) {
                mserver.unregisterMBean(this.getSenderObjectName(sender));
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void registerSenderMBean(Member member, IDataSender sender) {
        if (member != null && this.cluster != null) {
            try {
                MBeanServer mserver = this.cluster.getMBeanServer();
                ObjectName senderName = this.getSenderObjectName(sender);
                if (mserver.isRegistered(senderName)) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)this.sm.getString("cluster.mbean.register.allready", (Object)senderName));
                    }
                    return;
                }
                mserver.registerMBean(this.cluster.getManagedBean(sender), senderName);
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
        }
    }

    protected ObjectName getSenderObjectName(IDataSender sender) {
        ObjectName senderName = null;
        try {
            ObjectName clusterName = this.cluster.getObjectName();
            MBeanServer mserver = this.cluster.getMBeanServer();
            senderName = new ObjectName(clusterName.getDomain() + ":type=IDataSender,host=" + clusterName.getKeyProperty("host") + ",senderAddress=" + sender.getAddress().getHostAddress() + ",senderPort=" + sender.getPort());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        return senderName;
    }

    protected byte[] convertSenderData(byte[] data) throws IOException {
        return XByteBuffer.createDataPackage(data, this.isCompress());
    }

    protected void sendMessageData(String sessionId, byte[] data, IDataSender sender) throws IOException {
        if (sender == null) {
            throw new IOException("Sender not available. Make sure sender information is available to the ReplicationTransmitter.");
        }
        try {
            if (this.autoConnect && !sender.isConnected()) {
                sender.connect();
            }
            sender.sendMessage(sessionId, data);
            sender.setSuspect(false);
            this.addStats(data.length);
        }
        catch (Exception x) {
            if (log.isWarnEnabled() && !sender.getSuspect()) {
                log.warn((Object)"Unable to send replicated message, is server down?", (Throwable)x);
            }
            sender.setSuspect(true);
            ++this.failureCounter;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

