/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.cluster.CatalinaCluster;
import org.apache.catalina.cluster.ClusterManager;
import org.apache.catalina.cluster.ClusterMessage;
import org.apache.catalina.cluster.ClusterSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplicationValve
extends ValveBase {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$ReplicationValve == null ? (class$org$apache$catalina$cluster$tcp$ReplicationValve = ReplicationValve.class$("org.apache.catalina.cluster.tcp.ReplicationValve")) : class$org$apache$catalina$cluster$tcp$ReplicationValve));
    private static final String info = "org.apache.catalina.cluster.tcp.ReplicationValve/1.1";
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.valves");
    protected Pattern[] reqFilters = new Pattern[0];
    protected String filter;
    protected long totalRequestTime = 0L;
    protected long totalSendTime = 0L;
    protected long nrOfRequests = 0L;
    protected long lastSendTime = 0L;
    protected boolean primaryIndicator = false;
    protected String primaryIndicatorName = "org.apache.catalina.cluster.tcp.isPrimarySession";
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$ReplicationValve;

    public String getInfo() {
        return info;
    }

    protected synchronized void addClusterSendTime(long requestTime, long clusterTime) {
        this.totalSendTime += clusterTime;
        this.totalRequestTime += requestTime;
        ++this.nrOfRequests;
        if (this.nrOfRequests % 100L == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Average request time=" + this.totalRequestTime / this.nrOfRequests + " ms for " + "Cluster overhead time=" + this.totalSendTime / this.nrOfRequests + " ms for " + this.nrOfRequests + " requests (Request=" + this.totalRequestTime + "ms Cluster=" + this.totalSendTime + "ms)."));
            }
            this.lastSendTime = System.currentTimeMillis();
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        long totalstart = System.currentTimeMillis();
        if (this.primaryIndicator) {
            this.createPrimaryIndicator(request);
        }
        this.getNext().invoke(request, response);
        try {
            ClusterMessage msg;
            long start = System.currentTimeMillis();
            HttpSession session = request.getSession(false);
            if (!(request.getContext().getManager() instanceof ClusterManager)) {
                return;
            }
            ClusterManager manager = (ClusterManager)request.getContext().getManager();
            CatalinaCluster cluster = (CatalinaCluster)this.getContainer().getCluster();
            if (cluster == null) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"No cluster configured for this request.");
                }
                return;
            }
            String[] invalidIds = manager.getInvalidatedSessions();
            if (invalidIds.length > 0) {
                for (int i = 0; i < invalidIds.length; ++i) {
                    try {
                        ClusterMessage imsg = manager.requestCompleted(invalidIds[i]);
                        if (imsg == null) continue;
                        cluster.send(imsg);
                        continue;
                    }
                    catch (Exception x) {
                        log.error((Object)"Unable to send session invalid message over cluster.", (Throwable)x);
                    }
                }
            }
            String id = null;
            if (session == null) {
                return;
            }
            id = session.getId();
            if (id == null) {
                return;
            }
            if (request.getContext().getManager() == null || !(request.getContext().getManager() instanceof ClusterManager)) {
                return;
            }
            String uri = request.getDecodedRequestURI();
            boolean filterfound = false;
            for (int i = 0; i < this.reqFilters.length && !filterfound; ++i) {
                Matcher matcher = this.reqFilters[i].matcher(uri);
                filterfound = matcher.matches();
            }
            if (filterfound) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoking replication request on " + uri));
            }
            if ((msg = manager.requestCompleted(id)) == null) {
                return;
            }
            cluster.send(msg);
            long stop = System.currentTimeMillis();
            this.addClusterSendTime(stop - totalstart, stop - start);
        }
        catch (Exception x) {
            log.error((Object)"Unable to perform replication request.", (Throwable)x);
        }
    }

    protected void createPrimaryIndicator(Request request) throws IOException {
        String id = request.getRequestedSessionId();
        if (id != null && id.length() > 0) {
            Manager manager = request.getContext().getManager();
            Session session = manager.findSession(id);
            if (session instanceof ClusterSession) {
                ClusterSession cses = (ClusterSession)session;
                if (cses != null) {
                    Boolean isPrimary = new Boolean(cses.isPrimarySession());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Primarity of session " + id + " in request attribute " + this.primaryIndicatorName + " is " + isPrimary));
                    }
                    request.setAttribute(this.primaryIndicatorName, (Object)isPrimary);
                }
            } else if (log.isDebugEnabled()) {
                if (session != null) {
                    log.debug((Object)("Found session " + id + " but it is not a ClusterSession."));
                } else {
                    log.debug((Object)("Requested session " + id + " is invalid."));
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ReplicationValve[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    public void setFilter(String filter) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading request filters=" + filter));
        }
        this.filter = filter;
        StringTokenizer t = new StringTokenizer(filter, ";");
        this.reqFilters = new Pattern[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Request filter=" + s));
            }
            try {
                this.reqFilters[i++] = Pattern.compile(s);
            }
            catch (Exception x) {
                log.error((Object)("Unable to compile filter " + s), (Throwable)x);
            }
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isPrimaryIndicator() {
        return this.primaryIndicator;
    }

    public void setPrimaryIndicator(boolean primaryIndicator) {
        this.primaryIndicator = primaryIndicator;
    }

    public String getPrimaryIndicatorName() {
        return this.primaryIndicatorName;
    }

    public void setPrimaryIndicatorName(String primaryIndicatorName) {
        this.primaryIndicatorName = primaryIndicatorName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

