/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.cluster.tcp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.catalina.cluster.io.ObjectReader;
import org.apache.catalina.cluster.tcp.WorkerThread;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpReplicationThread
extends WorkerThread {
    private static final byte[] ACK_COMMAND = new byte[]{6, 2, 3};
    private static Log log = LogFactory.getLog((Class)(class$org$apache$catalina$cluster$tcp$TcpReplicationThread == null ? (class$org$apache$catalina$cluster$tcp$TcpReplicationThread = TcpReplicationThread.class$("org.apache.catalina.cluster.tcp.TcpReplicationThread")) : class$org$apache$catalina$cluster$tcp$TcpReplicationThread));
    private ByteBuffer buffer = ByteBuffer.allocate(1024);
    private SelectionKey key;
    private boolean waitForAck = true;
    static /* synthetic */ Class class$org$apache$catalina$cluster$tcp$TcpReplicationThread;

    TcpReplicationThread() {
    }

    public synchronized void run() {
        while (this.doRun) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"TCP worker thread interrupted in cluster", (Throwable)e);
                }
                Thread.interrupted();
            }
            if (this.key == null) continue;
            try {
                this.drainChannel(this.key);
            }
            catch (Exception e) {
                log.error((Object)("TCP Worker thread in cluster caught '" + e + "' closing channel"), (Throwable)e);
                try {
                    this.key.channel().close();
                }
                catch (IOException ex) {
                    log.error((Object)"Unable to close channel.", (Throwable)ex);
                }
                this.key.selector().wakeup();
            }
            this.key = null;
            this.pool.returnWorker(this);
        }
    }

    synchronized void serviceChannel(SelectionKey key, boolean waitForAck) {
        this.key = key;
        this.waitForAck = waitForAck;
        key.interestOps(key.interestOps() & 0xFFFFFFFE);
        key.interestOps(key.interestOps() & 0xFFFFFFFB);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainChannel(SelectionKey key) throws Exception {
        Object mutex;
        int count;
        boolean packetReceived = false;
        SocketChannel channel = (SocketChannel)key.channel();
        this.buffer.clear();
        ObjectReader reader = (ObjectReader)key.attachment();
        while ((count = channel.read(this.buffer)) > 0) {
            this.buffer.flip();
            reader.append(this.buffer.array(), 0, count);
            this.buffer.clear();
        }
        if (this.waitForAck) {
            for (int pkgcnt = reader.execute(); pkgcnt > 0; --pkgcnt) {
                this.sendAck(key, channel);
            }
        }
        if (count < 0) {
            channel.close();
            return;
        }
        Object object = mutex = this.getPool().getInterestOpsMutex();
        synchronized (object) {
            key.selector().wakeup();
            int resumeOps = key.interestOps() | 1;
            key.interestOps(resumeOps);
        }
    }

    private void sendAck(SelectionKey key, SocketChannel channel) {
        try {
            channel.write(ByteBuffer.wrap(ACK_COMMAND));
        }
        catch (IOException x) {
            log.warn((Object)("Unable to send ACK back through channel, channel disconnected?: " + x.getMessage()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

