/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.sql.DataSource;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.util.StringManager;
import org.apache.naming.ContextBindings;

public class DataSourceRealm
extends RealmBase {
    private StringBuffer preparedRoles = null;
    private StringBuffer preparedCredentials = null;
    protected String dataSourceName = null;
    protected static final String info = "org.apache.catalina.realm.DataSourceRealm/1.0";
    protected boolean localDataSource = false;
    protected static final String name = "DataSourceRealm";
    protected String roleNameCol = null;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.realm");
    protected String userCredCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userTable = null;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public boolean getLocalDataSource() {
        return this.localDataSource;
    }

    public void setLocalDataSource(boolean localDataSource) {
        this.localDataSource = localDataSource;
    }

    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    public void setRoleNameCol(String roleNameCol) {
        this.roleNameCol = roleNameCol;
    }

    public String getUserCredCol() {
        return this.userCredCol;
    }

    public void setUserCredCol(String userCredCol) {
        this.userCredCol = userCredCol;
    }

    public String getUserNameCol() {
        return this.userNameCol;
    }

    public void setUserNameCol(String userNameCol) {
        this.userNameCol = userNameCol;
    }

    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    public void setUserRoleTable(String userRoleTable) {
        this.userRoleTable = userRoleTable;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }

    public Principal authenticate(String username, String credentials) {
        Connection dbConnection = null;
        try {
            dbConnection = this.open();
            if (dbConnection == null) {
                return null;
            }
            Principal principal = this.authenticate(dbConnection, username, credentials);
            if (!dbConnection.getAutoCommit()) {
                dbConnection.commit();
            }
            this.close(dbConnection);
            dbConnection = null;
            return principal;
        }
        catch (SQLException e) {
            this.container.getLogger().error((Object)sm.getString("dataSourceRealm.exception"), (Throwable)e);
            if (dbConnection != null) {
                this.close(dbConnection);
            }
            return null;
        }
    }

    protected Principal authenticate(Connection dbConnection, String username, String credentials) {
        if (username == null) {
            return null;
        }
        String dbCredentials = this.getPassword(username);
        boolean validated = false;
        validated = this.hasMessageDigest() ? this.digest(credentials).equalsIgnoreCase(dbCredentials) : this.digest(credentials).equals(dbCredentials);
        if (validated) {
            if (this.container.getLogger().isTraceEnabled()) {
                this.container.getLogger().trace((Object)sm.getString("dataSourceRealm.authenticateSuccess", (Object)username));
            }
        } else {
            if (this.container.getLogger().isDebugEnabled()) {
                this.container.getLogger().trace((Object)sm.getString("dataSourceRealm.authenticateFailure", (Object)username));
            }
            return null;
        }
        ArrayList list = this.getRoles(username);
        return new GenericPrincipal((Realm)this, username, credentials, (List)list);
    }

    protected void close(Connection dbConnection) {
        if (dbConnection == null) {
            return;
        }
        try {
            dbConnection.close();
        }
        catch (SQLException e) {
            this.container.getLogger().error((Object)sm.getString("dataSourceRealm.close"), (Throwable)e);
        }
    }

    protected Connection open() {
        try {
            Context context = null;
            if (this.localDataSource) {
                context = ContextBindings.getClassLoader();
                context = (Context)context.lookup("comp/env");
            } else {
                StandardServer server = (StandardServer)ServerFactory.getServer();
                context = server.getGlobalNamingContext();
            }
            DataSource dataSource = (DataSource)context.lookup(this.dataSourceName);
            return dataSource.getConnection();
        }
        catch (Exception e) {
            this.container.getLogger().error((Object)sm.getString("dataSourceRealm.exception"), (Throwable)e);
            return null;
        }
    }

    private PreparedStatement credentials(Connection dbConnection, String username) throws SQLException {
        PreparedStatement credentials = dbConnection.prepareStatement(this.preparedCredentials.toString());
        credentials.setString(1, username);
        return credentials;
    }

    protected String getName() {
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String getPassword(String username) {
        String dbCredentials;
        Connection dbConnection;
        PreparedStatement stmt;
        ResultSet rs;
        block24: {
            rs = null;
            stmt = null;
            Object list = null;
            dbConnection = null;
            dbConnection = this.open();
            if (dbConnection == null) {
                return null;
            }
            dbCredentials = null;
            stmt = this.credentials(dbConnection, username);
            rs = stmt.executeQuery();
            if (rs.next()) {
                dbCredentials = rs.getString(1);
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            if (dbCredentials != null) break block24;
            String string = null;
            Object var9_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (!dbConnection.getAutoCommit()) {
                    dbConnection.commit();
                }
            }
            catch (SQLException e2) {
                this.container.getLogger().error((Object)sm.getString("datasourceRealm.getPassword.exception", (Object)username));
            }
            this.close(dbConnection);
            dbConnection = null;
            return string;
        }
        String string = dbCredentials = dbCredentials.trim();
        Object var9_11 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (!dbConnection.getAutoCommit()) {
                dbConnection.commit();
            }
        }
        catch (SQLException e2) {
            this.container.getLogger().error((Object)sm.getString("datasourceRealm.getPassword.exception", (Object)username));
        }
        this.close(dbConnection);
        dbConnection = null;
        return string;
        catch (SQLException e) {
            try {
                this.container.getLogger().error((Object)sm.getString("datasourceRealm.getPassword.exception", (Object)username));
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (!dbConnection.getAutoCommit()) {
                        dbConnection.commit();
                    }
                }
                catch (SQLException e2) {
                    this.container.getLogger().error((Object)sm.getString("datasourceRealm.getPassword.exception", (Object)username));
                }
                this.close(dbConnection);
                dbConnection = null;
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (!dbConnection.getAutoCommit()) {
                    dbConnection.commit();
                }
            }
            catch (SQLException e2) {
                this.container.getLogger().error((Object)sm.getString("datasourceRealm.getPassword.exception", (Object)username));
            }
            this.close(dbConnection);
            dbConnection = null;
            {
            }
        }
        return null;
    }

    protected Principal getPrincipal(String username) {
        return new GenericPrincipal((Realm)this, username, this.getPassword(username), (List)this.getRoles(username));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected ArrayList getRoles(String username) {
        ResultSet rs = null;
        PreparedStatement stmt = null;
        Connection dbConnection = null;
        dbConnection = this.open();
        if (dbConnection == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        stmt = this.roles(dbConnection, username);
        rs = stmt.executeQuery();
        while (rs.next()) {
            String role = rs.getString(1);
            if (role == null) continue;
            list.add(role.trim());
        }
        ArrayList<String> arrayList = list;
        Object var8_8 = null;
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e2) {
            this.container.getLogger().error((Object)sm.getString("datasourceRealm.getRoles.exception", (Object)username));
        }
        return arrayList;
        catch (SQLException e) {
            try {
                this.container.getLogger().error((Object)sm.getString("datasourceRealm.getRoles.exception", (Object)username));
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    this.container.getLogger().error((Object)sm.getString("datasourceRealm.getRoles.exception", (Object)username));
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                this.container.getLogger().error((Object)sm.getString("datasourceRealm.getRoles.exception", (Object)username));
            }
        }
        return null;
    }

    private PreparedStatement roles(Connection dbConnection, String username) throws SQLException {
        PreparedStatement roles = dbConnection.prepareStatement(this.preparedRoles.toString());
        roles.setString(1, username);
        return roles;
    }

    public void start() throws LifecycleException {
        this.preparedRoles = new StringBuffer("SELECT ");
        this.preparedRoles.append(this.roleNameCol);
        this.preparedRoles.append(" FROM ");
        this.preparedRoles.append(this.userRoleTable);
        this.preparedRoles.append(" WHERE ");
        this.preparedRoles.append(this.userNameCol);
        this.preparedRoles.append(" = ?");
        this.preparedCredentials = new StringBuffer("SELECT ");
        this.preparedCredentials.append(this.userCredCol);
        this.preparedCredentials.append(" FROM ");
        this.preparedCredentials.append(this.userTable);
        this.preparedCredentials.append(" WHERE ");
        this.preparedCredentials.append(this.userNameCol);
        this.preparedCredentials.append(" = ?");
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
    }
}

