/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http;

import java.io.IOException;
import org.apache.catalina.connector.RequestStream;
import org.apache.catalina.connector.http.HttpRequestImpl;
import org.apache.catalina.connector.http.HttpResponseImpl;

public class HttpRequestStream
extends RequestStream {
    protected boolean chunk = false;
    protected boolean endChunk = false;
    protected byte[] chunkBuffer = null;
    protected int chunkLength = 0;
    protected int chunkPos = 0;
    protected boolean http11 = false;

    public HttpRequestStream(HttpRequestImpl request, HttpResponseImpl response) {
        super(request);
        String transferEncoding = request.getHeader("Transfer-Encoding");
        this.http11 = request.getProtocol().equals("HTTP/1.1");
        boolean bl = this.chunk = transferEncoding != null && transferEncoding.indexOf("chunked") != -1;
        if (!this.chunk && this.length == -1) {
            response.addHeader("Connection", "close");
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException(RequestStream.sm.getString("requestStream.close.closed"));
        }
        if (this.chunk) {
            while (!this.endChunk) {
                int b = this.read();
                if (b >= 0) {
                    continue;
                }
                break;
            }
        } else if (this.http11 && this.length > 0) {
            while (this.count < this.length) {
                int b = this.read();
                if (b >= 0) {
                    continue;
                }
                break;
            }
        }
        this.closed = true;
    }

    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(RequestStream.sm.getString("requestStream.read.closed"));
        }
        if (this.chunk) {
            if (this.endChunk) {
                return -1;
            }
            if (!(this.chunkBuffer != null && this.chunkPos < this.chunkLength || this.fillChunkBuffer())) {
                return -1;
            }
            return this.chunkBuffer[this.chunkPos++] & 0xFF;
        }
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.chunk) {
            int avail = this.chunkLength - this.chunkPos;
            if (avail == 0) {
                this.fillChunkBuffer();
            }
            if ((avail = this.chunkLength - this.chunkPos) == 0) {
                return -1;
            }
            int toCopy = avail;
            if (avail > len) {
                toCopy = len;
            }
            System.arraycopy(this.chunkBuffer, this.chunkPos, b, off, toCopy);
            this.chunkPos += toCopy;
            return toCopy;
        }
        return super.read(b, off, len);
    }

    private synchronized boolean fillChunkBuffer() throws IOException {
        this.chunkPos = 0;
        try {
            String numberValue = this.readLineFromStream();
            if (numberValue != null) {
                numberValue = numberValue.trim();
            }
            this.chunkLength = Integer.parseInt(numberValue, 16);
        }
        catch (NumberFormatException e) {
            this.chunkLength = 0;
            this.chunk = false;
            this.close();
            return false;
        }
        if (this.chunkLength == 0) {
            String trailingLine = this.readLineFromStream();
            while (!trailingLine.equals("")) {
                trailingLine = this.readLineFromStream();
            }
            this.endChunk = true;
            return false;
        }
        if (this.chunkBuffer == null || this.chunkLength > this.chunkBuffer.length) {
            this.chunkBuffer = new byte[this.chunkLength];
        }
        int nbRead = 0;
        int currentRead = 0;
        while (nbRead < this.chunkLength) {
            try {
                currentRead = this.stream.read(this.chunkBuffer, nbRead, this.chunkLength - nbRead);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IOException();
            }
            if (currentRead < 0) {
                throw new IOException(RequestStream.sm.getString("requestStream.read.error"));
            }
            nbRead += currentRead;
        }
        String string = this.readLineFromStream();
        return true;
    }

    private String readLineFromStream() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ch;
            if ((ch = super.read()) < 0) {
                if (sb.length() != 0) break;
                return null;
            }
            if (ch == 13) continue;
            if (ch == 10) break;
            sb.append((char)ch);
        }
        return sb.toString();
    }
}

