/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.catalina.ValveContext;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public class StandardPipeline
implements Pipeline,
Contained,
Lifecycle,
ValveContext {
    protected Valve basic = null;
    protected Container container = null;
    protected int debug = 0;
    protected String info = "org.apache.catalina.core.StandardPipeline/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected boolean started = false;
    protected ThreadLocal state = new ThreadLocal();
    protected Valve[] valves = new Valve[0];

    public StandardPipeline() {
        this(null);
    }

    public StandardPipeline(Container container) {
        this.setContainer(container);
    }

    public String getInfo() {
        return this.info;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public synchronized void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardPipeline.alreadyStarted"));
        }
        this.started = true;
        int i = 0;
        while (i < this.valves.length) {
            if (this.valves[i] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.valves[i])).start();
            }
            ++i;
        }
        if (this.basic != null && this.basic instanceof Lifecycle) {
            ((Lifecycle)((Object)this.basic)).start();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
    }

    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardPipeline.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.basic != null && this.basic instanceof Lifecycle) {
            ((Lifecycle)((Object)this.basic)).stop();
        }
        int i = 0;
        while (i < this.valves.length) {
            if (this.valves[i] instanceof Lifecycle) {
                ((Lifecycle)((Object)this.valves[i])).stop();
            }
            ++i;
        }
    }

    public Valve getBasic() {
        return this.basic;
    }

    public void setBasic(Valve valve) {
        Valve oldBasic = this.basic;
        if (oldBasic == valve) {
            return;
        }
        if (oldBasic != null) {
            if (this.started && oldBasic instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)oldBasic)).stop();
                }
                catch (LifecycleException e) {
                    this.log("StandardPipeline.setBasic: stop", e);
                }
            }
            if (oldBasic instanceof Contained) {
                try {
                    ((Contained)((Object)oldBasic)).setContainer(null);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        if (valve == null) {
            return;
        }
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException e) {
                this.log("StandardPipeline.setBasic: start", e);
                return;
            }
        }
        this.basic = valve;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValve(Valve valve) {
        if (valve instanceof Contained) {
            ((Contained)((Object)valve)).setContainer(this.container);
        }
        if (this.started && valve instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)valve)).start();
            }
            catch (LifecycleException e) {
                this.log("StandardPipeline.addValve: start: ", e);
            }
        }
        Valve[] valveArray = this.valves;
        synchronized (this.valves) {
            Valve[] results = new Valve[this.valves.length + 1];
            System.arraycopy(this.valves, 0, results, 0, this.valves.length);
            results[this.valves.length] = valve;
            this.valves = results;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Valve[] getValves() {
        if (this.basic == null) {
            return this.valves;
        }
        Valve[] valveArray = this.valves;
        synchronized (this.valves) {
            Valve[] results = new Valve[this.valves.length + 1];
            System.arraycopy(this.valves, 0, results, 0, this.valves.length);
            results[this.valves.length] = this.basic;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return results;
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.state.set(new Integer(0));
        this.invokeNext(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValve(Valve valve) {
        Valve[] valveArray = this.valves;
        synchronized (this.valves) {
            block13: {
                int j = -1;
                int i = 0;
                while (i < this.valves.length) {
                    if (valve == this.valves[i]) {
                        j = i;
                        break;
                    }
                    ++i;
                }
                if (j < 0) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                Valve[] results = new Valve[this.valves.length - 1];
                int n = 0;
                int i2 = 0;
                while (i2 < this.valves.length) {
                    if (i2 != j) {
                        results[n++] = this.valves[i2];
                    }
                    ++i2;
                }
                this.valves = results;
                try {
                    if (valve instanceof Contained) {
                        ((Contained)((Object)valve)).setContainer(null);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (!this.started || !(valve instanceof Lifecycle)) break block13;
                try {
                    ((Lifecycle)((Object)valve)).stop();
                }
                catch (LifecycleException e) {
                    this.log("StandardPipeline.removeValve: stop: ", e);
                }
            }
            return;
        }
    }

    public void invokeNext(Request request, Response response) throws IOException, ServletException {
        Integer current = (Integer)this.state.get();
        int subscript = current;
        this.state.set(new Integer(subscript + 1));
        if (subscript < this.valves.length) {
            this.valves[subscript].invoke(request, response, this);
        } else if (subscript == this.valves.length && this.basic != null) {
            this.basic.invoke(request, response, this);
        } else {
            throw new ServletException(sm.getString("standardPipeline.noValve"));
        }
    }

    protected void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardPipeline[" + this.container.getName() + "]: " + message);
        } else {
            System.out.println("StandardPipeline[" + this.container.getName() + "]: " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardPipeline[" + this.container.getName() + "]: " + message, throwable);
        } else {
            System.out.println("StandardPipeline[" + this.container.getName() + "]: " + message);
            throwable.printStackTrace(System.out);
        }
    }
}

