/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

class ApplicationHttpRequest
extends HttpServletRequestWrapper {
    protected static final String[] specials = new String[]{"javax.servlet.include.request_uri", "javax.servlet.include.context_path", "javax.servlet.include.servlet_path", "javax.servlet.include.path_info", "javax.servlet.include.query_string"};
    protected HashMap attributes = new HashMap();
    protected String contextPath = null;
    protected static final String info = "org.apache.catalina.core.ApplicationHttpRequest/1.0";
    protected Map parameters = new HashMap();
    protected String pathInfo = null;
    protected String queryString = null;
    protected String requestURI = null;
    protected String servletPath = null;
    protected static StringManager sm;

    public ApplicationHttpRequest(HttpServletRequest request) {
        super(request);
        this.setRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            Object v = this.attributes.get(name);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            Enumerator enumerator = new Enumerator(this.attributes.keySet());
            return enumerator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.remove(name);
            if (!this.isSpecial(name)) {
                this.getRequest().removeAttribute(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.put(name, value);
            if (!this.isSpecial(name)) {
                this.getRequest().setAttribute(name, value);
            }
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameter(String name) {
        Map map = this.parameters;
        synchronized (map) {
            Object value;
            block8: {
                block7: {
                    block6: {
                        value = this.parameters.get(name);
                        if (value != null) break block6;
                        String string = null;
                        return string;
                    }
                    if (!(value instanceof String[])) break block7;
                    String string = ((String[])value)[0];
                    return string;
                }
                if (!(value instanceof String)) break block8;
                String string = (String)value;
                return string;
            }
            String string = value.toString();
            return string;
        }
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getParameterNames() {
        Map map = this.parameters;
        synchronized (map) {
            Enumerator enumerator = new Enumerator(this.parameters.keySet());
            return enumerator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getParameterValues(String name) {
        Map map = this.parameters;
        synchronized (map) {
            Object value;
            block8: {
                block7: {
                    block6: {
                        value = this.parameters.get(name);
                        if (value != null) break block6;
                        String[] stringArray = null;
                        return stringArray;
                    }
                    if (!(value instanceof String[])) break block7;
                    String[] stringArray = (String[])value;
                    return stringArray;
                }
                if (!(value instanceof String)) break block8;
                String[] values = new String[]{(String)value};
                String[] stringArray = values;
                return stringArray;
            }
            String[] values = new String[]{value.toString()};
            String[] stringArray = values;
            return stringArray;
        }
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map copyMap(Map orig) {
        if (orig == null) {
            return new HashMap();
        }
        HashMap dest = new HashMap();
        Map map = orig;
        synchronized (map) {
            Iterator keys = orig.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                dest.put(key, orig.get(key));
            }
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeParameters(String queryString) {
        if (queryString == null || queryString.length() < 1) {
            return;
        }
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        try {
            RequestUtil.parseParameters(queryParameters, queryString, encoding);
        }
        catch (Exception e) {
            // empty catch block
        }
        Map map = this.parameters;
        synchronized (map) {
            Iterator keys = this.parameters.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = queryParameters.get(key);
                if (value == null) {
                    queryParameters.put(key, this.parameters.get(key));
                    continue;
                }
                queryParameters.put(key, this.mergeValues(value, this.parameters.get(key)));
            }
            this.parameters = queryParameters;
        }
    }

    void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRequest(HttpServletRequest request) {
        super.setRequest((ServletRequest)request);
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.clear();
            Enumeration names = request.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if ("javax.servlet.include.request_uri".equals(name) || "javax.servlet.include.servlet_path".equals(name)) continue;
                Object value = request.getAttribute(name);
                this.attributes.put(name, value);
            }
        }
        Map map = this.parameters;
        synchronized (map) {
            this.parameters = this.copyMap(request.getParameterMap());
        }
        this.contextPath = request.getContextPath();
        this.pathInfo = request.getPathInfo();
        this.queryString = request.getQueryString();
        this.requestURI = request.getRequestURI();
        this.servletPath = request.getServletPath();
    }

    void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    protected boolean isSpecial(String name) {
        int i = 0;
        while (i < specials.length) {
            if (specials[i].equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String[] mergeValues(Object values1, Object values2) {
        int i;
        String[] values;
        ArrayList<Object> results = new ArrayList<Object>();
        if (values1 != null) {
            if (values1 instanceof String) {
                results.add(values1);
            } else if (values1 instanceof String[]) {
                values = (String[])values1;
                i = 0;
                while (i < values.length) {
                    results.add(values[i]);
                    ++i;
                }
            } else {
                results.add(values1.toString());
            }
        }
        if (values2 != null) {
            if (values2 instanceof String) {
                results.add(values2);
            } else if (values2 instanceof String[]) {
                values = (String[])values2;
                i = 0;
                while (i < values.length) {
                    results.add(values[i]);
                    ++i;
                }
            } else {
                results.add(values2.toString());
            }
        }
        values = new String[results.size()];
        return results.toArray(values);
    }

    static {
        info = info;
        sm = StringManager.getManager("org.apache.catalina.core");
    }
}

