/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Mapper;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.ProxyDirContext;

public abstract class ContainerBase
implements Container,
Lifecycle,
Pipeline {
    protected HashMap children = new HashMap();
    protected int debug = 0;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected ArrayList listeners = new ArrayList();
    protected Loader loader = null;
    protected Logger logger = null;
    protected Manager manager = null;
    protected Cluster cluster = null;
    protected Mapper mapper = null;
    protected HashMap mappers = new HashMap();
    protected String mapperClass = null;
    protected String name = null;
    protected Container parent = null;
    protected ClassLoader parentClassLoader = null;
    protected Pipeline pipeline = new StandardPipeline(this);
    protected Realm realm = null;
    protected DirContext resources = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        int oldDebug = this.debug;
        this.debug = debug;
        this.support.firePropertyChange("debug", new Integer(oldDebug), new Integer(this.debug));
    }

    public abstract String getInfo();

    public Loader getLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        if (this.parent != null) {
            return this.parent.getLoader();
        }
        return null;
    }

    public synchronized void setLoader(Loader loader) {
        Loader oldLoader = this.loader;
        if (oldLoader == loader) {
            return;
        }
        this.loader = loader;
        if (this.started && oldLoader != null && oldLoader instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldLoader)).stop();
            }
            catch (LifecycleException e) {
                this.log("ContainerBase.setLoader: stop: ", e);
            }
        }
        if (loader != null) {
            loader.setContainer(this);
        }
        if (this.started && loader != null && loader instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)loader)).start();
            }
            catch (LifecycleException e) {
                this.log("ContainerBase.setLoader: start: ", e);
            }
        }
        this.support.firePropertyChange("loader", oldLoader, this.loader);
    }

    public Logger getLogger() {
        if (this.logger != null) {
            return this.logger;
        }
        if (this.parent != null) {
            return this.parent.getLogger();
        }
        return null;
    }

    public synchronized void setLogger(Logger logger) {
        Logger oldLogger = this.logger;
        if (oldLogger == logger) {
            return;
        }
        this.logger = logger;
        if (this.started && oldLogger != null && oldLogger instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldLogger)).stop();
            }
            catch (LifecycleException e) {
                this.log("ContainerBase.setLogger: stop: ", e);
            }
        }
        if (logger != null) {
            logger.setContainer(this);
        }
        if (this.started && logger != null && logger instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)logger)).start();
            }
            catch (LifecycleException e) {
                this.log("ContainerBase.setLogger: start: ", e);
            }
        }
        this.support.firePropertyChange("logger", oldLogger, this.logger);
    }

    public Manager getManager() {
        if (this.manager != null) {
            return this.manager;
        }
        if (this.parent != null) {
            return this.parent.getManager();
        }
        return null;
    }

    public synchronized void setManager(Manager manager) {
        Manager oldManager = this.manager;
        if (oldManager == manager) {
            return;
        }
        this.manager = manager;
        if (this.started && oldManager != null && oldManager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldManager)).stop();
            }
            catch (LifecycleException e) {
                this.log("ContainerBase.setManager: stop: ", e);
            }
        }
        if (manager != null) {
            manager.setContainer(this);
        }
        if (this.started && manager != null && manager instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)manager)).start();
            }
            catch (LifecycleException e) {
                this.log("ContainerBase.setManager: start: ", e);
            }
        }
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    public Cluster getCluster() {
        if (this.cluster != null) {
            return this.cluster;
        }
        if (this.parent != null) {
            return this.parent.getCluster();
        }
        return null;
    }

    public synchronized void setCluster(Cluster cluster) {
        Cluster oldCluster = this.cluster;
        if (oldCluster == cluster) {
            return;
        }
        this.cluster = cluster;
        if (this.started && oldCluster != null && oldCluster instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldCluster)).stop();
            }
            catch (LifecycleException e) {
                this.log("ContainerBase.setCluster: stop: ", e);
            }
        }
        if (cluster != null) {
            cluster.setContainer(this);
        }
        if (this.started && cluster != null && cluster instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)cluster)).start();
            }
            catch (LifecycleException e) {
                this.log("ContainerBase.setCluster: start: ", e);
            }
        }
        this.support.firePropertyChange("cluster", oldCluster, this.cluster);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.support.firePropertyChange("name", oldName, this.name);
    }

    public Container getParent() {
        return this.parent;
    }

    public void setParent(Container container) {
        Container oldParent = this.parent;
        this.parent = container;
        this.support.firePropertyChange("parent", oldParent, this.parent);
    }

    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.parent != null) {
            return this.parent.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    public void setParentClassLoader(ClassLoader parent) {
        ClassLoader oldParentClassLoader = this.parentClassLoader;
        this.parentClassLoader = parent;
        this.support.firePropertyChange("parentClassLoader", oldParentClassLoader, this.parentClassLoader);
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public Realm getRealm() {
        if (this.realm != null) {
            return this.realm;
        }
        if (this.parent != null) {
            return this.parent.getRealm();
        }
        return null;
    }

    public synchronized void setRealm(Realm realm) {
        Realm oldRealm = this.realm;
        if (oldRealm == realm) {
            return;
        }
        this.realm = realm;
        if (this.started && oldRealm != null && oldRealm instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldRealm)).stop();
            }
            catch (LifecycleException e) {
                this.log("ContainerBase.setRealm: stop: ", e);
            }
        }
        if (realm != null) {
            realm.setContainer(this);
        }
        if (this.started && realm != null && realm instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)realm)).start();
            }
            catch (LifecycleException e) {
                this.log("ContainerBase.setRealm: start: ", e);
            }
        }
        this.support.firePropertyChange("realm", oldRealm, this.realm);
    }

    public DirContext getResources() {
        if (this.resources != null) {
            return this.resources;
        }
        if (this.parent != null) {
            return this.parent.getResources();
        }
        return null;
    }

    public synchronized void setResources(DirContext resources) {
        DirContext oldResources = this.resources;
        if (oldResources == resources) {
            return;
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.getParent() != null) {
            env.put("host", this.getParent().getName());
        }
        env.put("context", this.getName());
        this.resources = new ProxyDirContext(env, resources);
        this.support.firePropertyChange("resources", oldResources, this.resources);
    }

    public void addChild(Container child) {
        if (System.getSecurityManager() != null) {
            PrivilegedAddChild dp = new PrivilegedAddChild(child);
            AccessController.doPrivileged(dp);
        } else {
            this.addChildInternal(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildInternal(Container child) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.get(child.getName()) != null) {
                throw new IllegalArgumentException("addChild:  Child name '" + child.getName() + "' is not unique");
            }
            child.setParent(this);
            if (this.started && child instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)child)).start();
                }
                catch (LifecycleException e) {
                    this.log("ContainerBase.addChild: start: ", e);
                    throw new IllegalStateException("ContainerBase.addChild: start: " + e);
                }
            }
            this.children.put(child.getName(), child);
            this.fireContainerEvent("addChild", child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainerListener(ContainerListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMapper(Mapper mapper) {
        HashMap hashMap = this.mappers;
        synchronized (hashMap) {
            if (this.mappers.get(mapper.getProtocol()) != null) {
                throw new IllegalArgumentException("addMapper:  Protocol '" + mapper.getProtocol() + "' is not unique");
            }
            mapper.setContainer(this);
            if (this.started && mapper instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)mapper)).start();
                }
                catch (LifecycleException e) {
                    this.log("ContainerBase.addMapper: start: ", e);
                    throw new IllegalStateException("ContainerBase.addMapper: start: " + e);
                }
            }
            this.mappers.put(mapper.getProtocol(), mapper);
            this.mapper = this.mappers.size() == 1 ? mapper : null;
            this.fireContainerEvent("addMapper", mapper);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container findChild(String name) {
        if (name == null) {
            return null;
        }
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Container container = (Container)this.children.get(name);
            return container;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container[] findChildren() {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            Container[] results = new Container[this.children.size()];
            Container[] containerArray = this.children.values().toArray(results);
            return containerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerListener[] findContainerListeners() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ContainerListener[] results = new ContainerListener[this.listeners.size()];
            ContainerListener[] containerListenerArray = this.listeners.toArray(results);
            return containerListenerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mapper findMapper(String protocol) {
        if (this.mapper != null) {
            return this.mapper;
        }
        HashMap hashMap = this.mappers;
        synchronized (hashMap) {
            Mapper mapper = (Mapper)this.mappers.get(protocol);
            return mapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mapper[] findMappers() {
        HashMap hashMap = this.mappers;
        synchronized (hashMap) {
            Mapper[] results = new Mapper[this.mappers.size()];
            Mapper[] mapperArray = this.mappers.values().toArray(results);
            return mapperArray;
        }
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.pipeline.invoke(request, response);
    }

    public Container map(Request request, boolean update) {
        Mapper mapper = this.findMapper(request.getRequest().getProtocol());
        if (mapper == null) {
            return null;
        }
        return mapper.map(request, update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(Container child) {
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.get(child.getName()) == null) {
                return;
            }
            this.children.remove(child.getName());
        }
        if (this.started && child instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)child)).stop();
            }
            catch (LifecycleException e) {
                this.log("ContainerBase.removeChild: stop: ", e);
            }
        }
        this.fireContainerEvent("removeChild", child);
        child.setParent(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContainerListener(ContainerListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapper(Mapper mapper) {
        HashMap hashMap = this.mappers;
        synchronized (hashMap) {
            if (this.mappers.get(mapper.getProtocol()) == null) {
                return;
            }
            this.mappers.remove(mapper.getProtocol());
            if (this.started && mapper instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)mapper)).stop();
                }
                catch (LifecycleException e) {
                    this.log("ContainerBase.removeMapper: stop: ", e);
                    throw new IllegalStateException("ContainerBase.removeMapper: stop: " + e);
                }
            }
            if (this.mappers.size() != 1) {
                this.mapper = null;
            } else {
                Iterator values = this.mappers.values().iterator();
                this.mapper = (Mapper)values.next();
            }
            this.fireContainerEvent("removeMapper", mapper);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public synchronized void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("containerBase.alreadyStarted", this.logName()));
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.addDefaultMapper(this.mapperClass);
        this.started = true;
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).start();
        }
        if (this.logger != null && this.logger instanceof Lifecycle) {
            ((Lifecycle)((Object)this.logger)).start();
        }
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).start();
        }
        if (this.cluster != null && this.cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)this.cluster)).start();
        }
        if (this.realm != null && this.realm instanceof Lifecycle) {
            ((Lifecycle)((Object)this.realm)).start();
        }
        if (this.resources != null && this.resources instanceof Lifecycle) {
            ((Lifecycle)((Object)this.resources)).start();
        }
        Mapper[] mappers = this.findMappers();
        int i = 0;
        while (i < mappers.length) {
            if (mappers[i] instanceof Lifecycle) {
                ((Lifecycle)((Object)mappers[i])).start();
            }
            ++i;
        }
        Container[] children = this.findChildren();
        int i2 = 0;
        while (i2 < children.length) {
            if (children[i2] instanceof Lifecycle) {
                ((Lifecycle)((Object)children[i2])).start();
            }
            ++i2;
        }
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).start();
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("containerBase.notStarted", this.logName()));
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.pipeline instanceof Lifecycle) {
            ((Lifecycle)((Object)this.pipeline)).stop();
        }
        Container[] children = this.findChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Lifecycle) {
                ((Lifecycle)((Object)children[i])).stop();
            }
            ++i;
        }
        Mapper[] mappers = this.findMappers();
        int i2 = 0;
        while (i2 < mappers.length) {
            if (mappers[mappers.length - 1 - i2] instanceof Lifecycle) {
                ((Lifecycle)((Object)mappers[mappers.length - 1 - i2])).stop();
            }
            ++i2;
        }
        if (this.resources != null && this.resources instanceof Lifecycle) {
            ((Lifecycle)((Object)this.resources)).stop();
        }
        if (this.realm != null && this.realm instanceof Lifecycle) {
            ((Lifecycle)((Object)this.realm)).stop();
        }
        if (this.cluster != null && this.cluster instanceof Lifecycle) {
            ((Lifecycle)((Object)this.cluster)).stop();
        }
        if (this.manager != null && this.manager instanceof Lifecycle) {
            ((Lifecycle)((Object)this.manager)).stop();
        }
        if (this.logger != null && this.logger instanceof Lifecycle) {
            ((Lifecycle)((Object)this.logger)).stop();
        }
        if (this.loader != null && this.loader instanceof Lifecycle) {
            ((Lifecycle)((Object)this.loader)).stop();
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    public synchronized void addValve(Valve valve) {
        this.pipeline.addValve(valve);
        this.fireContainerEvent("addValve", valve);
    }

    public Valve getBasic() {
        return this.pipeline.getBasic();
    }

    public Valve[] getValves() {
        return this.pipeline.getValves();
    }

    public synchronized void removeValve(Valve valve) {
        this.pipeline.removeValve(valve);
        this.fireContainerEvent("removeValve", valve);
    }

    public void setBasic(Valve valve) {
        this.pipeline.setBasic(valve);
    }

    protected void addDefaultMapper(String mapperClass) {
        if (mapperClass == null) {
            return;
        }
        if (this.mappers.size() >= 1) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(mapperClass);
            Mapper mapper = (Mapper)clazz.newInstance();
            mapper.setProtocol("http");
            this.addMapper(mapper);
        }
        catch (Exception e) {
            this.log(sm.getString("containerBase.addDefaultMapper", mapperClass), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireContainerEvent(String type, Object data) {
        if (this.listeners.size() < 1) {
            return;
        }
        ContainerEvent event = new ContainerEvent(this, type, data);
        ContainerListener[] list = new ContainerListener[]{};
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = this.listeners.toArray(list);
        }
        int i = 0;
        while (i < list.length) {
            list[i].containerEvent(event);
            ++i;
        }
    }

    protected void log(String message) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(this.logName() + ": " + message);
        } else {
            System.out.println(this.logName() + ": " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.log(this.logName() + ": " + message, throwable);
        } else {
            System.out.println(this.logName() + ": " + message + ": " + throwable);
            throwable.printStackTrace(System.out);
        }
    }

    protected String logName() {
        String className = this.getClass().getName();
        int period = className.lastIndexOf(".");
        if (period >= 0) {
            className = className.substring(period + 1);
        }
        return className + "[" + this.getName() + "]";
    }

    protected class PrivilegedAddChild
    implements PrivilegedAction {
        private Container child;

        PrivilegedAddChild(Container child) {
            this.child = child;
        }

        public Object run() {
            ContainerBase.this.addChildInternal(this.child);
            return null;
        }
    }
}

