/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Host;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

final class StandardEngineValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardEngineValve/1.0";
    private static final StringManager sm;

    StandardEngineValve() {
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext valveContext) throws IOException, ServletException {
        if (!(request.getRequest() instanceof HttpServletRequest) || !(response.getResponse() instanceof HttpServletResponse)) {
            return;
        }
        HttpServletRequest hrequest = (HttpServletRequest)request;
        if ("HTTP/1.1".equals(hrequest.getProtocol()) && hrequest.getServerName() == null) {
            ((HttpServletResponse)response.getResponse()).sendError(400, sm.getString("standardEngine.noHostHeader", request.getRequest().getServerName()));
            return;
        }
        StandardEngine engine = (StandardEngine)this.getContainer();
        Host host = (Host)engine.map(request, true);
        if (host == null) {
            ((HttpServletResponse)response.getResponse()).sendError(400, sm.getString("standardEngine.noHost", request.getRequest().getServerName()));
            return;
        }
        host.invoke(request, response);
    }

    static {
        info = info;
        sm = StringManager.getManager("org.apache.catalina.core");
    }
}

