/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Deployer;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.util.StringManager;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;

public class StandardHostDeployer
implements Deployer {
    private Context context = null;
    private Digester digester = null;
    private ContextRuleSet contextRuleSet = null;
    protected StandardHost host = null;
    private NamingRuleSet namingRuleSet = null;
    private String overrideDocBase = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");

    public StandardHostDeployer(StandardHost host) {
        this.host = host;
    }

    public String getName() {
        return this.host.getName();
    }

    public synchronized void install(String contextPath, URL war) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        if (this.findDeployedApp(contextPath) != null) {
            throw new IllegalStateException(sm.getString("standardHost.pathUsed", contextPath));
        }
        if (war == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.warRequired"));
        }
        this.host.log(sm.getString("standardHost.installing", contextPath, war.toString()));
        String url = war.toString();
        String docBase = null;
        if (url.startsWith("jar:")) {
            url = url.substring(4, url.length() - 2);
        }
        if (url.startsWith("file://")) {
            docBase = url.substring(7);
        } else if (url.startsWith("file:")) {
            docBase = url.substring(5);
        } else {
            throw new IllegalArgumentException(sm.getString("standardHost.warURL", url));
        }
        try {
            Class<?> clazz = Class.forName(this.host.getContextClass());
            Context context = (Context)clazz.newInstance();
            context.setPath(contextPath);
            context.setDocBase(docBase);
            if (context instanceof Lifecycle) {
                clazz = Class.forName(this.host.getConfigClass());
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)((Object)context)).addLifecycleListener(listener);
            }
            this.host.fireContainerEvent("pre-install", context);
            this.host.addChild(context);
            this.host.fireContainerEvent("install", context);
        }
        catch (Exception e) {
            this.host.log(sm.getString("standardHost.installError", contextPath), e);
            throw new IOException(e.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void install(URL config, URL war) throws IOException {
        if (config == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.configRequired"));
        }
        if (!this.host.isDeployXML()) {
            throw new IllegalArgumentException(sm.getString("standardHost.configNotAllowed"));
        }
        String docBase = null;
        if (war != null) {
            String url = war.toString();
            this.host.log(sm.getString("standardHost.installingWAR", url));
            if (url.startsWith("jar:")) {
                url = url.substring(4, url.length() - 2);
            }
            if (url.startsWith("file://")) {
                docBase = url.substring(7);
            } else {
                if (!url.startsWith("file:")) throw new IllegalArgumentException(sm.getString("standardHost.warURL", url));
                docBase = url.substring(5);
            }
        }
        this.context = null;
        this.overrideDocBase = docBase;
        InputStream stream = null;
        try {
            try {
                stream = config.openStream();
                Digester digester = this.createDigester();
                digester.setDebug(this.host.getDebug());
                digester.clear();
                digester.push((Object)this);
                digester.parse(stream);
                stream.close();
                return;
            }
            catch (Exception e) {
                this.host.log(sm.getString("standardHost.installError", docBase), e);
                throw new IOException(e.toString());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public Context findDeployedApp(String contextPath) {
        return (Context)this.host.findChild(contextPath);
    }

    public String[] findDeployedApps() {
        Container[] children = this.host.findChildren();
        String[] results = new String[children.length];
        int i = 0;
        while (i < children.length) {
            results[i] = children[i].getName();
            ++i;
        }
        return results;
    }

    public void remove(String contextPath) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        Context context = this.findDeployedApp(contextPath);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathMissing", contextPath));
        }
        this.host.log(sm.getString("standardHost.removing", contextPath));
        try {
            this.host.removeChild(context);
            this.host.fireContainerEvent("remove", context);
        }
        catch (Exception e) {
            this.host.log(sm.getString("standardHost.removeError", contextPath), e);
            throw new IOException(e.toString());
        }
    }

    public void start(String contextPath) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        Context context = this.findDeployedApp(contextPath);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathMissing", contextPath));
        }
        this.host.log("standardHost.start " + contextPath);
        try {
            ((Lifecycle)((Object)context)).start();
        }
        catch (LifecycleException e) {
            this.host.log("standardHost.start " + contextPath + ": ", e);
            throw new IllegalStateException("standardHost.start " + contextPath + ": " + e);
        }
    }

    public void stop(String contextPath) throws IOException {
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        Context context = this.findDeployedApp(contextPath);
        if (context == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathMissing", contextPath));
        }
        this.host.log("standardHost.stop " + contextPath);
        try {
            ((Lifecycle)((Object)context)).stop();
        }
        catch (LifecycleException e) {
            this.host.log("standardHost.stop " + contextPath + ": ", e);
            throw new IllegalStateException("standardHost.stop " + contextPath + ": " + e);
        }
    }

    public void addChild(Container child) {
        this.context = (Context)child;
        String contextPath = this.context.getPath();
        if (contextPath == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathRequired"));
        }
        if (!contextPath.equals("") && !contextPath.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("standardHost.pathFormat", contextPath));
        }
        if (this.host.findChild(contextPath) != null) {
            throw new IllegalStateException(sm.getString("standardHost.pathUsed", contextPath));
        }
        if (this.overrideDocBase != null) {
            this.context.setDocBase(this.overrideDocBase);
        }
        this.host.fireContainerEvent("pre-install", this.context);
        this.host.addChild(child);
        this.host.fireContainerEvent("install", this.context);
    }

    public ClassLoader getParentClassLoader() {
        return this.host.getParentClassLoader();
    }

    protected Digester createDigester() {
        if (this.digester == null) {
            this.digester = new Digester();
            if (this.host.getDebug() > 0) {
                this.digester.setDebug(3);
            }
            this.digester.setValidating(false);
            this.contextRuleSet = new ContextRuleSet("");
            this.digester.addRuleSet((RuleSet)this.contextRuleSet);
            this.namingRuleSet = new NamingRuleSet("Context/");
            this.digester.addRuleSet((RuleSet)this.namingRuleSet);
        }
        return this.digester;
    }
}

