/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;

public final class StandardService
implements Lifecycle,
Service {
    private Connector[] connectors = new Connector[0];
    private Container container = null;
    private int debug = 0;
    private static final String info = "org.apache.catalina.core.StandardService/1.0";
    private boolean initialized = false;
    private String name = null;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private static final StringManager sm;
    private Server server = null;
    private boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);

    public Container getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        if (oldContainer != null && oldContainer instanceof Engine) {
            ((Engine)oldContainer).setService(null);
        }
        this.container = container;
        if (this.container != null && this.container instanceof Engine) {
            ((Engine)this.container).setService(this);
        }
        if (this.started && this.container != null && this.container instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)this.container)).start();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
        }
        Connector[] connectorArray = this.connectors;
        synchronized (connectorArray) {
            int i = 0;
            while (i < this.connectors.length) {
                this.connectors[i].setContainer(this.container);
                ++i;
            }
        }
        if (this.started && oldContainer != null && oldContainer instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)oldContainer)).stop();
            }
            catch (LifecycleException e) {
                // empty catch block
            }
        }
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getInfo() {
        return info;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (connectorArray) {
            connector.setContainer(this.container);
            connector.setService(this);
            Connector[] results = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, results, 0, this.connectors.length);
            results[this.connectors.length] = connector;
            this.connectors = results;
            if (this.initialized) {
                try {
                    connector.initialize();
                }
                catch (LifecycleException e) {
                    e.printStackTrace(System.err);
                }
            }
            if (this.started && connector instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)connector)).start();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            this.support.firePropertyChange("connector", null, connector);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public Connector[] findConnectors() {
        return this.connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnector(Connector connector) {
        Connector[] connectorArray = this.connectors;
        synchronized (connectorArray) {
            int j = -1;
            int i = 0;
            while (i < this.connectors.length) {
                if (connector == this.connectors[i]) {
                    j = i;
                    break;
                }
                ++i;
            }
            if (j < 0) {
                return;
            }
            if (this.started && this.connectors[j] instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.connectors[j])).stop();
                }
                catch (LifecycleException e) {
                    // empty catch block
                }
            }
            this.connectors[j].setContainer(null);
            connector.setService(null);
            int k = 0;
            Connector[] results = new Connector[this.connectors.length - 1];
            int i2 = 0;
            while (i2 < this.connectors.length) {
                if (i2 != j) {
                    results[k++] = this.connectors[i2];
                }
                ++i2;
            }
            this.connectors = results;
            this.support.firePropertyChange("connector", connector, null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardService[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws LifecycleException {
        Connector[] connectorArray;
        if (this.started) {
            throw new LifecycleException(sm.getString("standardService.start.started"));
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        System.out.println(sm.getString("standardService.start.name", this.name));
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        if (this.container != null) {
            connectorArray = this.container;
            synchronized (connectorArray) {
                if (this.container instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.container)).start();
                }
            }
        }
        connectorArray = this.connectors;
        synchronized (connectorArray) {
            int i = 0;
            while (i < this.connectors.length) {
                if (this.connectors[i] instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.connectors[i])).start();
                }
                ++i;
            }
        }
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardService.stop.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        System.out.println(sm.getString("standardService.stop.name", this.name));
        this.started = false;
        Connector[] connectorArray = this.connectors;
        synchronized (connectorArray) {
            int i = 0;
            while (i < this.connectors.length) {
                if (this.connectors[i] instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.connectors[i])).stop();
                }
                ++i;
            }
        }
        if (this.container != null) {
            Container container = this.container;
            synchronized (container) {
                if (this.container instanceof Lifecycle) {
                    ((Lifecycle)((Object)this.container)).stop();
                }
            }
        }
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws LifecycleException {
        if (this.initialized) {
            throw new LifecycleException(sm.getString("standardService.initialize.initialized"));
        }
        this.initialized = true;
        Connector[] connectorArray = this.connectors;
        synchronized (connectorArray) {
            int i = 0;
            while (i < this.connectors.length) {
                this.connectors[i].initialize();
                ++i;
            }
        }
    }

    static {
        info = info;
        sm = StringManager.getManager("org.apache.catalina.core");
    }
}

