/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardDefaultContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.logger.FileLogger;
import org.apache.catalina.logger.SystemErrLogger;
import org.apache.catalina.logger.SystemOutLogger;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.realm.JDBCRealm;
import org.apache.catalina.realm.JNDIRealm;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.realm.UserDatabaseRealm;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.RemoteAddrValve;
import org.apache.catalina.valves.RemoteHostValve;
import org.apache.catalina.valves.RequestDumperValve;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.modeler.BaseModelMBean;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;

public class MBeanFactory
extends BaseModelMBean {
    private static MBeanServer mserver = MBeanUtils.createServer();
    private static Registry registry = MBeanUtils.createRegistry();

    public String findObjectName(String type) {
        if (type.equals("org.apache.catalina.core.StandardContext")) {
            return "StandardContext";
        }
        if (type.equals("org.apache.catalina.core.StandardDefaultContext")) {
            return "DefaultContext";
        }
        if (type.equals("org.apache.catalina.core.StandardEngine")) {
            return "Engine";
        }
        if (type.equals("org.apache.catalina.core.StandardHost")) {
            return "Host";
        }
        return null;
    }

    private final String getPathStr(String t) {
        if (t == null || t.equals("/")) {
            return "";
        }
        return t;
    }

    public String createAccessLoggerValve(String parent) throws Exception {
        Host host;
        AccessLogValve accessLogger = new AccessLogValve();
        ObjectName pname = new ObjectName(parent);
        String type = pname.getKeyProperty("type");
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        if (type.equals("Context")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            String pathStr = this.getPathStr(pname.getKeyProperty("path"));
            Context context = (Context)host.findChild(pathStr);
            ((StandardContext)context).addValve(accessLogger);
        } else if (type.equals("Engine")) {
            ((StandardEngine)engine).addValve(accessLogger);
        } else if (type.equals("Host")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            ((StandardHost)host).addValve(accessLogger);
        }
        ManagedBean managed = registry.findManagedBean("AccessLogValve");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), accessLogger);
        return oname.toString();
    }

    public String createAjpConnector(String parent, String address, int port) throws Exception {
        Object retobj = null;
        try {
            Class<?> cls = Class.forName("org.apache.coyote.tomcat4.CoyoteConnector");
            Constructor<?> ct = cls.getConstructor(null);
            retobj = ct.newInstance(null);
            Class[] partypes1 = new Class[1];
            String str = new String();
            partypes1[0] = str.getClass();
            Method meth1 = cls.getMethod("setAddress", partypes1);
            Object[] arglist1 = new Object[]{address};
            meth1.invoke(retobj, arglist1);
            Class[] partypes2 = new Class[]{Integer.TYPE};
            Method meth2 = cls.getMethod("setPort", partypes2);
            Object[] arglist2 = new Object[]{new Integer(port)};
            meth2.invoke(retobj, arglist2);
            Class[] partypes3 = new Class[]{str.getClass()};
            Method meth3 = cls.getMethod("setProtocolHandlerClassName", partypes3);
            Object[] arglist3 = new Object[]{new String("org.apache.jk.server.JkCoyoteHandler")};
            meth3.invoke(retobj, arglist3);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        ObjectName pname = new ObjectName(parent);
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("name"));
        service.addConnector(retobj);
        ManagedBean managed = registry.findManagedBean("CoyoteConnector");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), retobj);
        return oname.toString();
    }

    public String createDefaultContext(String parent) throws Exception {
        StandardDefaultContext context = new StandardDefaultContext();
        ObjectName pname = new ObjectName(parent);
        String type = pname.getKeyProperty("type");
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        String hostName = pname.getKeyProperty("host");
        if (hostName == null) {
            engine.addDefaultContext(context);
        } else {
            Host host = (Host)engine.findChild(hostName);
            host.addDefaultContext(context);
        }
        ManagedBean managed = registry.findManagedBean("DefaultContext");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), context);
        return oname.toString();
    }

    public String createFileLogger(String parent) throws Exception {
        Host host;
        FileLogger fileLogger = new FileLogger();
        ObjectName pname = new ObjectName(parent);
        String type = pname.getKeyProperty("type");
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        if (type.equals("Context")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            String pathStr = this.getPathStr(pname.getKeyProperty("path"));
            Context context = (Context)host.findChild(pathStr);
            context.setLogger(fileLogger);
        } else if (type.equals("Engine")) {
            engine.setLogger(fileLogger);
        } else if (type.equals("Host")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            host.setLogger(fileLogger);
        }
        ManagedBean managed = registry.findManagedBean("FileLogger");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), fileLogger);
        return oname.toString();
    }

    public String createHttpConnector(String parent, String address, int port) throws Exception {
        Object retobj = null;
        try {
            Class<?> cls = Class.forName("org.apache.coyote.tomcat4.CoyoteConnector");
            Constructor<?> ct = cls.getConstructor(null);
            retobj = ct.newInstance(null);
            Class[] partypes1 = new Class[1];
            String str = new String();
            partypes1[0] = str.getClass();
            Method meth1 = cls.getMethod("setAddress", partypes1);
            Object[] arglist1 = new Object[]{address};
            meth1.invoke(retobj, arglist1);
            Class[] partypes2 = new Class[]{Integer.TYPE};
            Method meth2 = cls.getMethod("setPort", partypes2);
            Object[] arglist2 = new Object[]{new Integer(port)};
            meth2.invoke(retobj, arglist2);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        ObjectName pname = new ObjectName(parent);
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("name"));
        service.addConnector(retobj);
        ManagedBean managed = registry.findManagedBean("CoyoteConnector");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), retobj);
        return oname.toString();
    }

    public String createHttpsConnector(String parent, String address, int port) throws Exception {
        Object retobj = null;
        try {
            Class<?> cls = Class.forName("org.apache.coyote.tomcat4.CoyoteConnector");
            Constructor<?> ct = cls.getConstructor(null);
            retobj = ct.newInstance(null);
            Class[] partypes1 = new Class[1];
            String str = new String();
            partypes1[0] = str.getClass();
            Method meth1 = cls.getMethod("setAddress", partypes1);
            Object[] arglist1 = new Object[]{address};
            meth1.invoke(retobj, arglist1);
            Class[] partypes2 = new Class[]{Integer.TYPE};
            Method meth2 = cls.getMethod("setPort", partypes2);
            Object[] arglist2 = new Object[]{new Integer(port)};
            meth2.invoke(retobj, arglist2);
            Class[] partypes3 = new Class[]{str.getClass()};
            Method meth3 = cls.getMethod("setScheme", partypes3);
            Object[] arglist3 = new Object[]{new String("https")};
            meth3.invoke(retobj, arglist3);
            Class[] partypes4 = new Class[]{Boolean.TYPE};
            Method meth4 = cls.getMethod("setSecure", partypes4);
            Object[] arglist4 = new Object[]{new Boolean(true)};
            meth4.invoke(retobj, arglist4);
            Class<?> serverSocketFactoryCls = Class.forName("org.apache.catalina.net.ServerSocketFactory");
            Class<?> coyoteServerSocketFactoryCls = Class.forName("org.apache.coyote.tomcat4.CoyoteServerSocketFactory");
            Constructor<?> factoryConst = coyoteServerSocketFactoryCls.getConstructor(null);
            Object factoryObj = factoryConst.newInstance(null);
            Class[] partypes5 = new Class[]{serverSocketFactoryCls};
            Method meth5 = cls.getMethod("setFactory", partypes5);
            Object[] arglist5 = new Object[]{factoryObj};
            meth5.invoke(retobj, arglist5);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        try {
            ObjectName pname = new ObjectName(parent);
            Server server = ServerFactory.getServer();
            Service service = server.findService(pname.getKeyProperty("name"));
            service.addConnector(retobj);
        }
        catch (Exception e) {
            return null;
        }
        ManagedBean managed = registry.findManagedBean("CoyoteConnector");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), retobj);
        return oname.toString();
    }

    public String createJDBCRealm(String parent) throws Exception {
        Host host;
        JDBCRealm realm = new JDBCRealm();
        ObjectName pname = new ObjectName(parent);
        String type = pname.getKeyProperty("type");
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        if (type.equals("Context")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            String pathStr = this.getPathStr(pname.getKeyProperty("path"));
            Context context = (Context)host.findChild(pathStr);
            context.setRealm(realm);
        } else if (type.equals("Engine")) {
            engine.setRealm(realm);
        } else if (type.equals("Host")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            host.setRealm(realm);
        }
        ManagedBean managed = registry.findManagedBean("JDBCRealm");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), realm);
        return oname.toString();
    }

    public String createJNDIRealm(String parent) throws Exception {
        Host host;
        JNDIRealm realm = new JNDIRealm();
        ObjectName pname = new ObjectName(parent);
        String type = pname.getKeyProperty("type");
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        if (type.equals("Context")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            String pathStr = this.getPathStr(pname.getKeyProperty("path"));
            Context context = (Context)host.findChild(pathStr);
            context.setRealm(realm);
        } else if (type.equals("Engine")) {
            engine.setRealm(realm);
        } else if (type.equals("Host")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            host.setRealm(realm);
        }
        ManagedBean managed = registry.findManagedBean("JNDIRealm");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), realm);
        return oname.toString();
    }

    public String createMemoryRealm(String parent) throws Exception {
        Host host;
        MemoryRealm realm = new MemoryRealm();
        ObjectName pname = new ObjectName(parent);
        String type = pname.getKeyProperty("type");
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        if (type.equals("Context")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            String pathStr = this.getPathStr(pname.getKeyProperty("path"));
            Context context = (Context)host.findChild(pathStr);
            context.setRealm(realm);
        } else if (type.equals("Engine")) {
            engine.setRealm(realm);
        } else if (type.equals("Host")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            host.setRealm(realm);
        }
        ManagedBean managed = registry.findManagedBean("MemoryRealm");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), realm);
        return oname.toString();
    }

    public String createRemoteAddrValve(String parent) throws Exception {
        Host host;
        RemoteAddrValve valve = new RemoteAddrValve();
        ObjectName pname = new ObjectName(parent);
        String type = pname.getKeyProperty("type");
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        if (type.equals("Context")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            String pathStr = this.getPathStr(pname.getKeyProperty("path"));
            Context context = (Context)host.findChild(pathStr);
            ((StandardContext)context).addValve(valve);
        } else if (type.equals("Engine")) {
            ((StandardEngine)engine).addValve(valve);
        } else if (type.equals("Host")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            ((StandardHost)host).addValve(valve);
        }
        ManagedBean managed = registry.findManagedBean("RemoteAddrValve");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), valve);
        return oname.toString();
    }

    public String createRemoteHostValve(String parent) throws Exception {
        Host host;
        RemoteHostValve valve = new RemoteHostValve();
        ObjectName pname = new ObjectName(parent);
        String type = pname.getKeyProperty("type");
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        if (type.equals("Context")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            String pathStr = this.getPathStr(pname.getKeyProperty("path"));
            Context context = (Context)host.findChild(pathStr);
            ((StandardContext)context).addValve(valve);
        } else if (type.equals("Engine")) {
            ((StandardEngine)engine).addValve(valve);
        } else if (type.equals("Host")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            ((StandardHost)host).addValve(valve);
        }
        ManagedBean managed = registry.findManagedBean("RemoteHostValve");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), valve);
        return oname.toString();
    }

    public String createRequestDumperValve(String parent) throws Exception {
        Host host;
        RequestDumperValve valve = new RequestDumperValve();
        ObjectName pname = new ObjectName(parent);
        String type = pname.getKeyProperty("type");
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        if (type.equals("Context")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            String pathStr = this.getPathStr(pname.getKeyProperty("path"));
            Context context = (Context)host.findChild(pathStr);
            ((StandardContext)context).addValve(valve);
        } else if (type.equals("Engine")) {
            ((StandardEngine)engine).addValve(valve);
        } else if (type.equals("Host")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            ((StandardHost)host).addValve(valve);
        }
        ManagedBean managed = registry.findManagedBean("RequestDumperValve");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), valve);
        return oname.toString();
    }

    public String createSingleSignOn(String parent) throws Exception {
        Host host;
        SingleSignOn valve = new SingleSignOn();
        ObjectName pname = new ObjectName(parent);
        String type = pname.getKeyProperty("type");
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        if (type.equals("Context")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            String pathStr = this.getPathStr(pname.getKeyProperty("path"));
            Context context = (Context)host.findChild(pathStr);
            ((StandardContext)context).addValve(valve);
        } else if (type.equals("Engine")) {
            ((StandardEngine)engine).addValve(valve);
        } else if (type.equals("Host")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            ((StandardHost)host).addValve(valve);
        }
        ManagedBean managed = registry.findManagedBean("SingleSignOn");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), valve);
        return oname.toString();
    }

    public String createStandardContext(String parent, String path, String docBase) throws Exception {
        StandardContext context = new StandardContext();
        path = this.getPathStr(path);
        context.setPath(path);
        context.setDocBase(docBase);
        ObjectName pname = new ObjectName(parent);
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        Host host = (Host)engine.findChild(pname.getKeyProperty("host"));
        host.addChild(context);
        ManagedBean managed = registry.findManagedBean("StandardContext");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), context);
        return oname.toString();
    }

    public String createStandardEngine(String parent, String name, String defaultHost) throws Exception {
        StandardEngine engine = new StandardEngine();
        engine.setName(name);
        engine.setDefaultHost(defaultHost);
        ObjectName pname = new ObjectName(parent);
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("name"));
        service.setContainer(engine);
        ManagedBean managed = registry.findManagedBean("StandardEngine");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), engine);
        return oname.toString();
    }

    public String createStandardHost(String parent, String name, String appBase, boolean unpackWARs) throws Exception {
        StandardHost host = new StandardHost();
        host.setName(name);
        host.setAppBase(appBase);
        host.setUnpackWARs(unpackWARs);
        ObjectName pname = new ObjectName(parent);
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        engine.addChild(host);
        ManagedBean managed = registry.findManagedBean("StandardHost");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), host);
        return oname.toString();
    }

    public String createStandardManager(String parent) throws Exception {
        StandardManager manager = new StandardManager();
        ObjectName pname = new ObjectName(parent);
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        Host host = (Host)engine.findChild(pname.getKeyProperty("host"));
        String pathStr = this.getPathStr(pname.getKeyProperty("path"));
        Context context = (Context)host.findChild(pathStr);
        context.setManager(manager);
        ManagedBean managed = registry.findManagedBean("StandardManager");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), manager);
        return oname.toString();
    }

    public String createStandardService(String parent, String name) throws Exception {
        StandardService service = new StandardService();
        service.setName(name);
        Server server = ServerFactory.getServer();
        server.addService(service);
        ManagedBean managed = registry.findManagedBean("StandardService");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), service);
        return oname.toString();
    }

    public String createSystemErrLogger(String parent) throws Exception {
        Host host;
        SystemErrLogger logger = new SystemErrLogger();
        ObjectName pname = new ObjectName(parent);
        String type = pname.getKeyProperty("type");
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        if (type.equals("Context")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            String pathStr = this.getPathStr(pname.getKeyProperty("path"));
            Context context = (Context)host.findChild(pathStr);
            context.setLogger(logger);
        } else if (type.equals("Engine")) {
            engine.setLogger(logger);
        } else if (type.equals("Host")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            host.setLogger(logger);
        }
        ManagedBean managed = registry.findManagedBean("SystemErrLogger");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), logger);
        return oname.toString();
    }

    public String createSystemOutLogger(String parent) throws Exception {
        Host host;
        SystemOutLogger logger = new SystemOutLogger();
        ObjectName pname = new ObjectName(parent);
        String type = pname.getKeyProperty("type");
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        if (type.equals("Context")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            String pathStr = this.getPathStr(pname.getKeyProperty("path"));
            Context context = (Context)host.findChild(pathStr);
            context.setLogger(logger);
        } else if (type.equals("Engine")) {
            engine.setLogger(logger);
        } else if (type.equals("Host")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            host.setLogger(logger);
        }
        ManagedBean managed = registry.findManagedBean("SystemOutLogger");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), logger);
        return oname.toString();
    }

    public String createUserDatabaseRealm(String parent, String resourceName) throws Exception {
        Host host;
        UserDatabaseRealm realm = new UserDatabaseRealm();
        realm.setResourceName(resourceName);
        ObjectName pname = new ObjectName(parent);
        String type = pname.getKeyProperty("type");
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        if (type.equals("Context")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            String pathStr = this.getPathStr(pname.getKeyProperty("path"));
            Context context = (Context)host.findChild(pathStr);
            context.setRealm(realm);
        } else if (type.equals("Engine")) {
            engine.setRealm(realm);
        } else if (type.equals("Host")) {
            host = (Host)engine.findChild(pname.getKeyProperty("host"));
            host.setRealm(realm);
        }
        ManagedBean managed = registry.findManagedBean("UserDatabaseRealm");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), realm);
        return oname.toString();
    }

    public String createWebappLoader(String parent) throws Exception {
        WebappLoader loader = new WebappLoader();
        ObjectName pname = new ObjectName(parent);
        Server server = ServerFactory.getServer();
        Service service = server.findService(pname.getKeyProperty("service"));
        Engine engine = (Engine)service.getContainer();
        Host host = (Host)engine.findChild(pname.getKeyProperty("host"));
        String pathStr = this.getPathStr(pname.getKeyProperty("path"));
        Context context = (Context)host.findChild(pathStr);
        context.setLoader(loader);
        ManagedBean managed = registry.findManagedBean("WebappLoader");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), loader);
        return oname.toString();
    }

    public void removeConnector(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        Server server = ServerFactory.getServer();
        String serviceName = oname.getKeyProperty("service");
        Service service = server.findService(serviceName);
        String port = oname.getKeyProperty("port");
        String address = oname.getKeyProperty("address");
        Connector[] conns = service.findConnectors();
        int i = 0;
        while (i < conns.length) {
            Class<?> cls = conns[i].getClass();
            Method getAddrMeth = cls.getMethod("getAddress", null);
            Object addrObj = getAddrMeth.invoke((Object)conns[i], null);
            String connAddress = null;
            if (addrObj != null) {
                connAddress = addrObj.toString();
            }
            Method getPortMeth = cls.getMethod("getPort", null);
            Object portObj = getPortMeth.invoke((Object)conns[i], null);
            String connPort = new String();
            if (portObj != null) {
                connPort = portObj.toString();
            }
            if (address.equals("null") && connAddress == null && port.equals(connPort)) {
                service.removeConnector(conns[i]);
                break;
            }
            if (address.equals(connAddress) && port.equals(connPort)) {
                service.removeConnector(conns[i]);
                break;
            }
            ++i;
        }
    }

    public void removeContext(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        String serviceName = oname.getKeyProperty("service");
        String hostName = oname.getKeyProperty("host");
        String contextName = this.getPathStr(oname.getKeyProperty("path"));
        Server server = ServerFactory.getServer();
        Service service = server.findService(serviceName);
        Engine engine = (Engine)service.getContainer();
        Host host = (Host)engine.findChild(hostName);
        Context context = (Context)host.findChild(contextName);
        host.removeChild(context);
    }

    public void removeHost(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        String serviceName = oname.getKeyProperty("service");
        String hostName = oname.getKeyProperty("host");
        Server server = ServerFactory.getServer();
        Service service = server.findService(serviceName);
        Engine engine = (Engine)service.getContainer();
        Host host = (Host)engine.findChild(hostName);
        engine.removeChild(host);
    }

    public void removeLogger(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        String serviceName = oname.getKeyProperty("service");
        String hostName = oname.getKeyProperty("host");
        String path = oname.getKeyProperty("path");
        Server server = ServerFactory.getServer();
        Service service = server.findService(serviceName);
        StandardEngine engine = (StandardEngine)service.getContainer();
        if (hostName == null) {
            String sname;
            Logger logger = engine.getLogger();
            Container container = logger.getContainer();
            if (container instanceof StandardEngine && (sname = ((StandardEngine)container).getService().getName()).equals(serviceName)) {
                engine.setLogger(null);
            }
        } else if (path == null) {
            StandardHost host = (StandardHost)engine.findChild(hostName);
            Logger logger = host.getLogger();
            Container container = logger.getContainer();
            if (container instanceof StandardHost) {
                String hn = ((StandardHost)container).getName();
                StandardEngine se = (StandardEngine)((StandardHost)container).getParent();
                String sname = se.getService().getName();
                if (sname.equals(serviceName) && hn.equals(hostName)) {
                    host.setLogger(null);
                }
            }
        } else {
            StandardHost host = (StandardHost)engine.findChild(hostName);
            StandardContext context = (StandardContext)host.findChild(path = this.getPathStr(path));
            Logger logger = context.getLogger();
            Container container = logger.getContainer();
            if (container instanceof StandardContext) {
                String pathName = ((StandardContext)container).getName();
                StandardHost sh = (StandardHost)((StandardContext)container).getParent();
                String hn = sh.getName();
                StandardEngine se = (StandardEngine)sh.getParent();
                String sname = se.getService().getName();
                if (sname.equals(serviceName) && hn.equals(hostName) && pathName.equals(path)) {
                    context.setLogger(null);
                }
            }
        }
    }

    public void removeLoader(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        String serviceName = oname.getKeyProperty("service");
        String hostName = oname.getKeyProperty("host");
        String contextName = this.getPathStr(oname.getKeyProperty("path"));
        Server server = ServerFactory.getServer();
        Service service = server.findService(serviceName);
        Engine engine = (Engine)service.getContainer();
        Host host = (Host)engine.findChild(hostName);
        Context context = (Context)host.findChild(contextName);
        context.setLoader(null);
    }

    public void removeManager(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        String serviceName = oname.getKeyProperty("service");
        String hostName = oname.getKeyProperty("host");
        String contextName = this.getPathStr(oname.getKeyProperty("path"));
        Server server = ServerFactory.getServer();
        Service service = server.findService(serviceName);
        Engine engine = (Engine)service.getContainer();
        Host host = (Host)engine.findChild(hostName);
        Context context = (Context)host.findChild(contextName);
        context.setManager(null);
    }

    public void removeRealm(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        String serviceName = oname.getKeyProperty("service");
        String hostName = oname.getKeyProperty("host");
        String path = oname.getKeyProperty("path");
        Server server = ServerFactory.getServer();
        Service service = server.findService(serviceName);
        StandardEngine engine = (StandardEngine)service.getContainer();
        if (hostName == null) {
            String sname;
            Realm realm = engine.getRealm();
            Container container = realm.getContainer();
            if (container instanceof StandardEngine && (sname = ((StandardEngine)container).getService().getName()).equals(serviceName)) {
                engine.setRealm(null);
            }
        } else if (path == null) {
            StandardHost host = (StandardHost)engine.findChild(hostName);
            Realm realm = host.getRealm();
            Container container = realm.getContainer();
            if (container instanceof StandardHost) {
                String hn = ((StandardHost)container).getName();
                StandardEngine se = (StandardEngine)((StandardHost)container).getParent();
                String sname = se.getService().getName();
                if (sname.equals(serviceName) && hn.equals(hostName)) {
                    host.setRealm(null);
                }
            }
        } else {
            StandardHost host = (StandardHost)engine.findChild(hostName);
            StandardContext context = (StandardContext)host.findChild(path = this.getPathStr(path));
            Realm realm = context.getRealm();
            Container container = realm.getContainer();
            if (container instanceof StandardContext) {
                String pathName = ((StandardContext)container).getName();
                StandardHost sh = (StandardHost)((StandardContext)container).getParent();
                String hn = sh.getName();
                StandardEngine se = (StandardEngine)sh.getParent();
                String sname = se.getService().getName();
                if (sname.equals(serviceName) && hn.equals(hostName) && pathName.equals(path)) {
                    context.setRealm(null);
                }
            }
        }
    }

    public void removeService(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        String serviceName = oname.getKeyProperty("name");
        Server server = ServerFactory.getServer();
        Service service = server.findService(serviceName);
        server.removeService(service);
    }

    public void removeValve(String name) throws Exception {
        ObjectName oname = new ObjectName(name);
        String serviceName = oname.getKeyProperty("service");
        String hostName = oname.getKeyProperty("host");
        String path = oname.getKeyProperty("path");
        String sequence = oname.getKeyProperty("sequence");
        Server server = ServerFactory.getServer();
        Service service = server.findService(serviceName);
        StandardEngine engine = (StandardEngine)service.getContainer();
        if (hostName == null) {
            Valve[] valves = engine.getValves();
            int i = 0;
            while (i < valves.length) {
                Container container = ((ValveBase)valves[i]).getContainer();
                if (container instanceof StandardEngine) {
                    String sname = ((StandardEngine)container).getService().getName();
                    Integer sequenceInt = new Integer(valves[i].hashCode());
                    if (sname.equals(serviceName) && sequence.equals(sequenceInt.toString())) {
                        engine.removeValve(valves[i]);
                        break;
                    }
                }
                ++i;
            }
        } else if (path == null) {
            StandardHost host = (StandardHost)engine.findChild(hostName);
            Valve[] valves = host.getValves();
            int i = 0;
            while (i < valves.length) {
                Container container = ((ValveBase)valves[i]).getContainer();
                if (container instanceof StandardHost) {
                    String hn = ((StandardHost)container).getName();
                    StandardEngine se = (StandardEngine)((StandardHost)container).getParent();
                    String sname = se.getService().getName();
                    Integer sequenceInt = new Integer(valves[i].hashCode());
                    if (sname.equals(serviceName) && hn.equals(hostName) && sequence.equals(sequenceInt.toString())) {
                        host.removeValve(valves[i]);
                        break;
                    }
                }
                ++i;
            }
        } else {
            StandardHost host = (StandardHost)engine.findChild(hostName);
            path = this.getPathStr(path);
            StandardContext context = (StandardContext)host.findChild(path);
            Valve[] valves = context.getValves();
            int i = 0;
            while (i < valves.length) {
                Container container = ((ValveBase)valves[i]).getContainer();
                if (container instanceof StandardContext) {
                    String pathName = ((StandardContext)container).getName();
                    StandardHost sh = (StandardHost)((StandardContext)container).getParent();
                    String hn = sh.getName();
                    StandardEngine se = (StandardEngine)sh.getParent();
                    String sname = se.getService().getName();
                    Integer sequenceInt = new Integer(valves[i].hashCode());
                    if (sname.equals(serviceName) && hn.equals(hostName) && pathName.equals(path) && sequence.equals(sequenceInt.toString())) {
                        context.removeValve(valves[i]);
                        break;
                    }
                }
                ++i;
            }
        }
    }
}

