/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.net.URLDecoder;
import java.util.ArrayList;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.commons.modeler.BaseModelMBean;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.Registry;

public class NamingResourcesMBean
extends BaseModelMBean {
    protected Registry registry = MBeanUtils.createRegistry();
    protected ManagedBean managed = this.registry.findManagedBean("NamingResources");

    public String[] getEnvironments() {
        ContextEnvironment[] envs = ((NamingResources)this.resource).findEnvironments();
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < envs.length) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.managed.getDomain(), envs[i]);
                results.add(oname.toString());
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("Cannot create object name for environment " + envs[i]);
            }
            ++i;
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getResources() {
        ContextResource[] resources = ((NamingResources)this.resource).findResources();
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < resources.length) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.managed.getDomain(), resources[i]);
                results.add(oname.toString());
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("Cannot create object name for resource " + resources[i]);
            }
            ++i;
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getResourceLinks() {
        ContextResourceLink[] resourceLinks = ((NamingResources)this.resource).findResourceLinks();
        ArrayList<String> results = new ArrayList<String>();
        int i = 0;
        while (i < resourceLinks.length) {
            try {
                ObjectName oname = MBeanUtils.createObjectName(this.managed.getDomain(), resourceLinks[i]);
                results.add(oname.toString());
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("Cannot create object name for resource " + resourceLinks[i]);
            }
            ++i;
        }
        return results.toArray(new String[results.size()]);
    }

    public String addEnvironment(String envName, String type, String value) throws MalformedObjectNameException {
        NamingResources nresources = (NamingResources)this.resource;
        if (nresources == null) {
            return null;
        }
        ContextEnvironment env = nresources.findEnvironment(envName);
        if (env != null) {
            throw new IllegalArgumentException("Invalid environment name - already exists '" + envName + "'");
        }
        env = new ContextEnvironment();
        env.setName(envName);
        env.setType(type);
        env.setValue(value);
        nresources.addEnvironment(env);
        ManagedBean managed = this.registry.findManagedBean("ContextEnvironment");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), env);
        return oname.toString();
    }

    public String addResource(String resourceName, String type) throws MalformedObjectNameException {
        NamingResources nresources = (NamingResources)this.resource;
        if (nresources == null) {
            return null;
        }
        ContextResource resource = nresources.findResource(resourceName);
        if (resource != null) {
            throw new IllegalArgumentException("Invalid resource name - already exists'" + resourceName + "'");
        }
        resource = new ContextResource();
        resource.setName(resourceName);
        resource.setType(type);
        nresources.addResource(resource);
        ManagedBean managed = this.registry.findManagedBean("ContextResource");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), resource);
        return oname.toString();
    }

    public String addResourceLink(String global, String resourceLinkName, String type) throws MalformedObjectNameException {
        NamingResources nresources = (NamingResources)this.resource;
        if (nresources == null) {
            return null;
        }
        ContextResourceLink resourceLink = nresources.findResourceLink(resourceLinkName);
        if (resourceLink != null) {
            throw new IllegalArgumentException("Invalid resource link name - already exists'" + resourceLinkName + "'");
        }
        resourceLink = new ContextResourceLink();
        resourceLink.setName(resourceLinkName);
        resourceLink.setType(type);
        resourceLink.setGlobal(global);
        nresources.addResourceLink(resourceLink);
        ManagedBean managed = this.registry.findManagedBean("ContextResourceLink");
        ObjectName oname = MBeanUtils.createObjectName(managed.getDomain(), resourceLink);
        return oname.toString();
    }

    public void removeEnvironment(String envName) {
        NamingResources nresources = (NamingResources)this.resource;
        if (nresources == null) {
            return;
        }
        ContextEnvironment env = nresources.findEnvironment(envName);
        if (env == null) {
            throw new IllegalArgumentException("Invalid environment name '" + envName + "'");
        }
        nresources.removeEnvironment(envName);
    }

    public void removeResource(String resourceName) {
        resourceName = URLDecoder.decode(resourceName);
        NamingResources nresources = (NamingResources)this.resource;
        if (nresources == null) {
            return;
        }
        ContextResource resource = nresources.findResource(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("Invalid resource name '" + resourceName + "'");
        }
        nresources.removeResource(resourceName);
        nresources.removeResourceParams(resourceName);
    }

    public void removeResourceLink(String resourceLinkName) {
        resourceLinkName = URLDecoder.decode(resourceLinkName);
        NamingResources nresources = (NamingResources)this.resource;
        if (nresources == null) {
            return;
        }
        ContextResourceLink resourceLink = nresources.findResourceLink(resourceLinkName);
        if (resourceLink == null) {
            throw new IllegalArgumentException("Invalid resource Link name '" + resourceLinkName + "'");
        }
        nresources.removeResourceLink(resourceLinkName);
    }
}

