/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.security.Security;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Server;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.EngineRuleSet;
import org.apache.catalina.startup.HostRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.SetParentClassLoaderRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.xml.sax.InputSource;

public class Catalina {
    protected String configFile = "conf/server.xml";
    protected boolean debug = false;
    protected ClassLoader parentClassLoader = ClassLoader.getSystemClassLoader();
    protected Server server = null;
    protected boolean starting = false;
    protected boolean stopping = false;
    protected boolean useNaming = true;

    public static void main(String[] args) {
        new Catalina().process(args);
    }

    public void process(String[] args) {
        this.setCatalinaHome();
        this.setCatalinaBase();
        try {
            if (this.arguments(args)) {
                this.execute();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    protected boolean arguments(String[] args) {
        boolean isConfig = false;
        if (args.length < 1) {
            this.usage();
            return false;
        }
        int i = 0;
        while (i < args.length) {
            if (isConfig) {
                this.configFile = args[i];
                isConfig = false;
            } else if (args[i].equals("-config")) {
                isConfig = true;
            } else if (args[i].equals("-debug")) {
                this.debug = true;
            } else if (args[i].equals("-nonaming")) {
                this.useNaming = false;
            } else {
                if (args[i].equals("-help")) {
                    this.usage();
                    return false;
                }
                if (args[i].equals("start")) {
                    this.starting = true;
                } else if (args[i].equals("stop")) {
                    this.stopping = true;
                } else {
                    this.usage();
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    protected File configFile() {
        File file = new File(this.configFile);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.configFile);
        }
        return file;
    }

    protected Digester createStartDigester() {
        Digester digester = new Digester();
        if (this.debug) {
            digester.setDebug(999);
        }
        digester.setValidating(false);
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        digester.addObjectCreate("Server/GlobalNamingResources", "org.apache.catalina.deploy.NamingResources");
        digester.addSetProperties("Server/GlobalNamingResources");
        digester.addSetNext("Server/GlobalNamingResources", "setGlobalNamingResources", "org.apache.catalina.deploy.NamingResources");
        digester.addObjectCreate("Server/Listener", null, "className");
        digester.addSetProperties("Server/Listener");
        digester.addSetNext("Server/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service", "org.apache.catalina.core.StandardService", "className");
        digester.addSetProperties("Server/Service");
        digester.addSetNext("Server/Service", "addService", "org.apache.catalina.Service");
        digester.addObjectCreate("Server/Service/Listener", null, "className");
        digester.addSetProperties("Server/Service/Listener");
        digester.addSetNext("Server/Service/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Connector", "org.apache.catalina.connector.http.HttpConnector", "className");
        digester.addSetProperties("Server/Service/Connector");
        digester.addSetNext("Server/Service/Connector", "addConnector", "org.apache.catalina.Connector");
        digester.addObjectCreate("Server/Service/Connector/Factory", "org.apache.catalina.net.DefaultServerSocketFactory", "className");
        digester.addSetProperties("Server/Service/Connector/Factory");
        digester.addSetNext("Server/Service/Connector/Factory", "setFactory", "org.apache.catalina.net.ServerSocketFactory");
        digester.addObjectCreate("Server/Service/Connector/Listener", null, "className");
        digester.addSetProperties("Server/Service/Connector/Listener");
        digester.addSetNext("Server/Service/Connector/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/GlobalNamingResources/"));
        digester.addRuleSet((RuleSet)new EngineRuleSet("Server/Service/"));
        digester.addRuleSet((RuleSet)new HostRuleSet("Server/Service/Engine/"));
        digester.addRuleSet((RuleSet)new ContextRuleSet("Server/Service/Engine/Default"));
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/Service/Engine/DefaultContext/"));
        digester.addRuleSet((RuleSet)new ContextRuleSet("Server/Service/Engine/Host/Default"));
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/Service/Engine/Host/DefaultContext/"));
        digester.addRuleSet((RuleSet)new ContextRuleSet("Server/Service/Engine/Host/"));
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/Service/Engine/Host/Context/"));
        digester.addRule("Server/Service/Engine", (Rule)new SetParentClassLoaderRule(digester, this.parentClassLoader));
        return digester;
    }

    protected Digester createStopDigester() {
        Digester digester = new Digester();
        if (this.debug) {
            digester.setDebug(999);
        }
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        return digester;
    }

    protected void execute() throws Exception {
        if (this.starting) {
            this.start();
        } else if (this.stopping) {
            this.stop();
        }
    }

    protected void setCatalinaBase() {
        if (System.getProperty("catalina.base") != null) {
            return;
        }
        System.setProperty("catalina.base", System.getProperty("catalina.home"));
    }

    protected void setCatalinaHome() {
        if (System.getProperty("catalina.home") != null) {
            return;
        }
        System.setProperty("catalina.home", System.getProperty("user.dir"));
    }

    protected void start() {
        block18: {
            CatalinaShutdownHook shutdownHook;
            block17: {
                Digester digester = this.createStartDigester();
                File file = this.configFile();
                try {
                    InputSource is = new InputSource("file://" + file.getAbsolutePath());
                    FileInputStream fis = new FileInputStream(file);
                    is.setByteStream(fis);
                    digester.push((Object)this);
                    digester.parse(is);
                    fis.close();
                }
                catch (Exception e) {
                    System.out.println("Catalina.start: " + e);
                    e.printStackTrace(System.out);
                    System.exit(1);
                }
                if (!this.useNaming) {
                    System.setProperty("catalina.useNaming", "false");
                } else {
                    System.setProperty("catalina.useNaming", "true");
                    String value = "org.apache.naming";
                    String oldValue = System.getProperty("java.naming.factory.url.pkgs");
                    if (oldValue != null) {
                        value = value + ":" + oldValue;
                    }
                    System.setProperty("java.naming.factory.url.pkgs", value);
                    value = System.getProperty("java.naming.factory.initial");
                    if (value == null) {
                        System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
                    }
                }
                if (System.getSecurityManager() != null) {
                    String access = Security.getProperty("package.access");
                    access = access != null && access.length() > 0 ? access + "," : "sun.,";
                    Security.setProperty("package.access", access + "org.apache.catalina.,org.apache.jasper.");
                    String definition = Security.getProperty("package.definition");
                    definition = definition != null && definition.length() > 0 ? definition + "," : "sun.,";
                    Security.setProperty("package.definition", definition + "java.,org.apache.catalina.,org.apache.jasper.");
                }
                SystemLogHandler log = new SystemLogHandler(System.out);
                System.setOut((PrintStream)log);
                System.setErr((PrintStream)log);
                shutdownHook = new CatalinaShutdownHook();
                if (this.server instanceof Lifecycle) {
                    try {
                        this.server.initialize();
                        ((Lifecycle)((Object)this.server)).start();
                        try {
                            Runtime.getRuntime().addShutdownHook(shutdownHook);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        this.server.await();
                    }
                    catch (LifecycleException e) {
                        System.out.println("Catalina.start: " + e);
                        e.printStackTrace(System.out);
                        if (e.getThrowable() == null) break block17;
                        System.out.println("----- Root Cause -----");
                        e.getThrowable().printStackTrace(System.out);
                    }
                }
            }
            if (this.server instanceof Lifecycle) {
                try {
                    try {
                        Runtime.getRuntime().removeShutdownHook(shutdownHook);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    ((Lifecycle)((Object)this.server)).stop();
                }
                catch (LifecycleException e) {
                    System.out.println("Catalina.stop: " + e);
                    e.printStackTrace(System.out);
                    if (e.getThrowable() == null) break block18;
                    System.out.println("----- Root Cause -----");
                    e.getThrowable().printStackTrace(System.out);
                }
            }
        }
    }

    protected void stop() {
        Digester digester = this.createStopDigester();
        File file = this.configFile();
        try {
            InputSource is = new InputSource("file://" + file.getAbsolutePath());
            FileInputStream fis = new FileInputStream(file);
            is.setByteStream(fis);
            digester.push((Object)this);
            digester.parse(is);
            fis.close();
        }
        catch (Exception e) {
            System.out.println("Catalina.stop: " + e);
            e.printStackTrace(System.out);
            System.exit(1);
        }
        try {
            Socket socket = new Socket("127.0.0.1", this.server.getPort());
            OutputStream stream = socket.getOutputStream();
            String shutdown = this.server.getShutdown();
            int i = 0;
            while (i < shutdown.length()) {
                stream.write(shutdown.charAt(i));
                ++i;
            }
            stream.flush();
            stream.close();
            socket.close();
        }
        catch (IOException e) {
            System.out.println("Catalina.stop: " + e);
            e.printStackTrace(System.out);
            System.exit(1);
        }
    }

    protected void usage() {
        System.out.println("usage: java org.apache.catalina.startup.Catalina [ -config {pathname} ] [ -debug ] [ -nonaming ] { start | stop }");
    }

    protected class CatalinaShutdownHook
    extends Thread {
        protected CatalinaShutdownHook() {
        }

        public void run() {
            block3: {
                if (Catalina.this.server != null) {
                    try {
                        ((Lifecycle)((Object)Catalina.this.server)).stop();
                    }
                    catch (LifecycleException e) {
                        System.out.println("Catalina.stop: " + e);
                        e.printStackTrace(System.out);
                        if (e.getThrowable() == null) break block3;
                        System.out.println("----- Root Cause -----");
                        e.getThrowable().printStackTrace(System.out);
                    }
                }
            }
        }
    }
}

