/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.connector.RequestWrapper;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.CipherData;
import org.apache.catalina.valves.ValveBase;

public final class CertificatesValve
extends ValveBase
implements Lifecycle {
    protected boolean certificates = false;
    protected static final CipherData[] ciphers = new CipherData[]{new CipherData("_WITH_NULL_", 0), new CipherData("_WITH_IDEA_CBC_", 128), new CipherData("_WITH_RC2_CBC_40_", 40), new CipherData("_WITH_RC4_40_", 40), new CipherData("_WITH_RC4_128_", 128), new CipherData("_WITH_DES40_CBC_", 40), new CipherData("_WITH_DES_CBC_", 56), new CipherData("_WITH_3DES_EDE_CBC_", 168)};
    protected int debug = 0;
    protected static final String info = "org.apache.catalina.valves.CertificatesValve/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static StringManager sm;
    protected boolean started = false;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        Request actual = request;
        while (actual instanceof RequestWrapper) {
            actual = ((RequestWrapper)actual).getWrappedRequest();
        }
        if (this.certificates) {
            this.verify(request, actual);
        }
        this.expose(request, actual);
        context.invokeNext(request, response);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        String authMethod;
        Context context;
        LoginConfig loginConfig;
        if (this.started) {
            throw new LifecycleException(sm.getString("certificatesValve.alreadyStarted"));
        }
        this.started = true;
        if (this.debug >= 1) {
            this.log("Starting");
        }
        this.certificates = false;
        if (this.container instanceof Context && (loginConfig = (context = (Context)this.container).getLoginConfig()) != null && "CLIENT-CERT".equalsIgnoreCase(authMethod = loginConfig.getAuthMethod())) {
            this.certificates = true;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("certificatesValve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.debug >= 1) {
            this.log("Stopping");
        }
        this.certificates = false;
    }

    protected void expose(Request request, Request actual) {
        Object cached;
        Integer keySize;
        if (actual.getSocket() == null) {
            return;
        }
        if (!(actual.getSocket() instanceof SSLSocket)) {
            return;
        }
        SSLSocket socket = (SSLSocket)actual.getSocket();
        SSLSession session = socket.getSession();
        if (session == null) {
            return;
        }
        String cipherSuite = session.getCipherSuite();
        if (cipherSuite != null) {
            request.getRequest().setAttribute("javax.servlet.request.cipher_suite", (Object)cipherSuite);
        }
        if ((keySize = (Integer)session.getValue("javax.servlet.request.key_size")) == null) {
            int size = 0;
            int i = 0;
            while (i < ciphers.length) {
                if (cipherSuite.indexOf(CertificatesValve.ciphers[i].phrase) >= 0) {
                    size = CertificatesValve.ciphers[i].keySize;
                    break;
                }
                ++i;
            }
            keySize = new Integer(size);
            session.putValue("javax.servlet.request.key_size", keySize);
        }
        request.getRequest().setAttribute("javax.servlet.request.key_size", (Object)keySize);
        byte[] ssl_session = session.getId();
        if (ssl_session != null) {
            StringBuffer buf = new StringBuffer("");
            int x = 0;
            while (x < ssl_session.length) {
                String digit = Integer.toHexString(ssl_session[x]);
                if (digit.length() < 2) {
                    buf.append('0');
                }
                if (digit.length() > 2) {
                    digit = digit.substring(digit.length() - 2);
                }
                buf.append(digit);
                ++x;
            }
            request.getRequest().setAttribute("javax.servlet.request.ssl_session", (Object)buf.toString());
        }
        if ((cached = session.getValue("javax.servlet.request.X509Certificate")) != null) {
            request.getRequest().setAttribute("javax.servlet.request.X509Certificate", cached);
            return;
        }
        X509Certificate[] jsseCerts = null;
        java.security.cert.X509Certificate[] x509Certs = null;
        try {
            jsseCerts = session.getPeerCertificateChain();
            if (jsseCerts == null) {
                jsseCerts = new X509Certificate[]{};
            }
            x509Certs = new java.security.cert.X509Certificate[jsseCerts.length];
            int i = 0;
            while (i < x509Certs.length) {
                byte[] buffer = jsseCerts[i].getEncoded();
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                x509Certs[i] = (java.security.cert.X509Certificate)cf.generateCertificate(stream);
                ++i;
            }
        }
        catch (Throwable t) {
            return;
        }
        if (x509Certs == null || x509Certs.length < 1) {
            return;
        }
        session.putValue("javax.servlet.request.X509Certificate", x509Certs);
        this.log(" expose: Exposing converted certificates");
        request.getRequest().setAttribute("javax.servlet.request.X509Certificate", (Object)x509Certs);
    }

    protected void log(String message) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log("CertificatesValve[" + this.container.getName() + "]: " + message);
        } else {
            System.out.println("CertificatesValve[" + this.container.getName() + "]: " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.container.getLogger();
        if (logger != null) {
            logger.log("CertificatesValve[" + this.container.getName() + "]: " + message, throwable);
        } else {
            System.out.println("CertificatesValve[" + this.container.getName() + "]: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    protected void verify(Request request, Request actual) {
        if (actual.getSocket() == null) {
            return;
        }
        if (!(actual.getSocket() instanceof SSLSocket)) {
            return;
        }
        SSLSocket socket = (SSLSocket)actual.getSocket();
        SSLSession session = socket.getSession();
        if (session == null) {
            return;
        }
        X509Certificate[] jsseCerts = null;
        try {
            jsseCerts = session.getPeerCertificateChain();
            if (jsseCerts == null) {
                jsseCerts = new X509Certificate[]{};
            }
        }
        catch (SSLPeerUnverifiedException e) {
            this.log(" verify: SSLPeerUnverifiedException");
            jsseCerts = new X509Certificate[]{};
        }
        if (jsseCerts.length > 0) {
            return;
        }
        session.invalidate();
        socket.setNeedClientAuth(true);
        try {
            socket.startHandshake();
        }
        catch (IOException e) {
            this.log(" verify: ", e);
        }
        session = socket.getSession();
        if (session == null) {
            return;
        }
        try {
            jsseCerts = session.getPeerCertificateChain();
            if (jsseCerts == null) {
                jsseCerts = new X509Certificate[]{};
            }
        }
        catch (SSLPeerUnverifiedException e) {
            this.log(" verify: SSLPeerUnverifiedException");
            jsseCerts = new X509Certificate[]{};
        }
    }

    static {
        info = info;
        sm = StringManager.getManager("org.apache.catalina.valves");
    }
}

