/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.tomcat.util.compat.Action;
import org.apache.tomcat.util.compat.Jdk11Compat;
import org.apache.tomcat.util.compat.SimpleClassLoader;
import org.apache.tomcat.util.depend.DependClassLoader;

public class Jdk12Support
extends Jdk11Compat {
    public ClassLoader newClassLoaderInstance(URL[] urls, ClassLoader parent) {
        return URLClassLoader.newInstance(urls, parent);
    }

    public Object getAccessControlContext() throws Exception {
        return AccessController.getContext();
    }

    public Object doPrivileged(Action action, Object accObj) throws Exception {
        ProtectionDomain[] domain = null;
        if (accObj instanceof ProtectionDomain) {
            domain = new ProtectionDomain[]{(ProtectionDomain)accObj};
        } else if (accObj instanceof ProtectionDomain[]) {
            domain = (ProtectionDomain[])accObj;
        }
        AccessControlContext acc = null;
        acc = domain == null ? (AccessControlContext)accObj : new AccessControlContext(domain);
        if (acc == null) {
            throw new Exception("Invalid access control context ");
        }
        Object proxy = action.getProxy();
        if (proxy == null) {
            proxy = new PrivilegedProxy(action);
            action.setProxy(proxy);
        }
        try {
            return AccessController.doPrivileged((PrivilegedExceptionAction)proxy, acc);
        }
        catch (PrivilegedActionException pe) {
            Exception e = pe.getException();
            throw e;
        }
    }

    public void refreshPolicy() {
        Policy.getPolicy().refresh();
    }

    public void setContextClassLoader(ClassLoader cl) {
        Thread.currentThread().setContextClassLoader(cl);
    }

    public ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public ClassLoader getParentLoader(ClassLoader cl) {
        if (cl instanceof DependClassLoader) {
            return ((DependClassLoader)cl).getParentLoader();
        }
        if (cl instanceof SimpleClassLoader) {
            return ((SimpleClassLoader)cl).getParentLoader();
        }
        if (cl instanceof URLClassLoader) {
            return ((URLClassLoader)cl).getParent();
        }
        return null;
    }

    public URL[] getURLs(ClassLoader cl, int depth) {
        int c = 0;
        while (true) {
            if (cl instanceof DependClassLoader && cl != null) {
                cl = ((DependClassLoader)cl).getParentLoader();
                continue;
            }
            if (cl == null) break;
            if (depth == c) {
                if (cl instanceof URLClassLoader) {
                    return ((URLClassLoader)cl).getURLs();
                }
                if (cl instanceof SimpleClassLoader) {
                    return ((SimpleClassLoader)cl).getURLs();
                }
                return null;
            }
            if ((cl = this.getParentLoader(cl)) == null || depth < ++c) break;
        }
        return null;
    }

    public ResourceBundle getBundle(String name, Locale loc, ClassLoader cl) {
        if (cl == null) {
            cl = this.getContextClassLoader();
        }
        if (cl == null) {
            return ResourceBundle.getBundle(name, loc);
        }
        return ResourceBundle.getBundle(name, loc, cl);
    }

    public Object getX509Certificates(byte[] x509) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(x509);
        X509Certificate[] jsseCerts = null;
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
        jsseCerts = new X509Certificate[]{cert};
        return jsseCerts;
    }

    static class PrivilegedProxy
    implements PrivilegedExceptionAction {
        Action action;

        PrivilegedProxy(Action act) {
            this.action = act;
        }

        public Object run() throws Exception {
            return this.action.run();
        }
    }
}

