/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.BeanEndGenerator;
import org.apache.jasper.compiler.BeanGenerator;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.CharDataGenerator;
import org.apache.jasper.compiler.ClassDeclarationPhase;
import org.apache.jasper.compiler.CommentGenerator;
import org.apache.jasper.compiler.CompileException;
import org.apache.jasper.compiler.DeclarationGenerator;
import org.apache.jasper.compiler.ExpressionGenerator;
import org.apache.jasper.compiler.FileDeclarationPhase;
import org.apache.jasper.compiler.ForwardGenerator;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.GetPropertyGenerator;
import org.apache.jasper.compiler.IncludeGenerator;
import org.apache.jasper.compiler.InfoGenerator;
import org.apache.jasper.compiler.InitMethodPhase;
import org.apache.jasper.compiler.JakartaCommentGenerator;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.MappedCharDataGenerator;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.ParseEventListener;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.PluginGenerator;
import org.apache.jasper.compiler.ScriptletGenerator;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SetPropertyGenerator;
import org.apache.jasper.compiler.StaticInitializerPhase;
import org.apache.jasper.compiler.StoredCharDataGenerator;
import org.apache.jasper.compiler.TagBeginGenerator;
import org.apache.jasper.compiler.TagEndGenerator;
import org.apache.jasper.compiler.TagLibraries;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.apache.jasper.compiler.UninterpretedTagBeginGenerator;
import org.apache.jasper.compiler.UninterpretedTagEndGenerator;
import org.apache.jasper.compiler.XmlOutputter;
import org.xml.sax.Attributes;

public class JspParseEventListener
implements ParseEventListener {
    private static CommentGenerator commentGenerator = new JakartaCommentGenerator();
    protected JspReader reader;
    protected ServletWriter writer;
    JspCompilationContext ctxt;
    ParserController parserCtl;
    String jspServletBase = "HttpJspBase";
    String serviceMethodName = "_jspService";
    String servletContentType = null;
    String pageEncoding = null;
    String defaultType = null;
    String defaultCharset = null;
    String extendsClass = "";
    Vector interfaces = new Vector();
    Vector imports = new Vector();
    String error = "";
    boolean genSessionVariable = true;
    boolean singleThreaded = false;
    boolean autoFlush = true;
    Vector generators = new Vector();
    BeanRepository beanInfo;
    int bufferSize = 8192;
    boolean languageDir = false;
    boolean extendsDir = false;
    boolean sessionDir = false;
    boolean bufferDir = false;
    boolean threadsafeDir = false;
    boolean errorpageDir = false;
    boolean iserrorpageDir = false;
    boolean infoDir = false;
    boolean autoFlushDir = false;
    boolean contentTypeDir = false;
    int stringId = 0;
    Vector vector = new Vector();
    String dataFile;
    TagLibraries libraries;
    private Stack tagHandlerStack;
    private Hashtable tagVarNumbers;
    private XmlOutputter xo = new XmlOutputter();
    static final String languageStr = "language";
    static final String extendsStr = "extends";
    static final String importStr = "import";
    static final String sessionStr = "session";
    static final String bufferStr = "buffer";
    static final String autoFlushStr = "autoFlush";
    static final String isThreadSafeStr = "isThreadSafe";
    static final String infoStr = "info";
    static final String errorPageStr = "errorPage";
    static final String isErrorPageStr = "isErrorPage";
    static final String contentTypeStr = "contentType";
    static final String pageEncodingStr = "pageEncoding";
    PageDirectiveHandlerInfo[] pdhis = new PageDirectiveHandlerInfo[]{new PageDirectiveHandlerInfo("language", new LanguageHandler()), new PageDirectiveHandlerInfo("extends", new ExtendsHandler()), new PageDirectiveHandlerInfo("import", new ImportsHandler()), new PageDirectiveHandlerInfo("session", new SessionHandler()), new PageDirectiveHandlerInfo("buffer", new BufferHandler()), new PageDirectiveHandlerInfo("autoFlush", new AutoFlushHandler()), new PageDirectiveHandlerInfo("isThreadSafe", new IsThreadSafeHandler()), new PageDirectiveHandlerInfo("info", new InfoHandler()), new PageDirectiveHandlerInfo("isErrorPage", new IsErrorPageHandler()), new PageDirectiveHandlerInfo("contentType", new ContentTypeHandler()), new PageDirectiveHandlerInfo("pageEncoding", new PageEncodingHandler()), new PageDirectiveHandlerInfo("errorPage", new ErrorPageHandler())};
    static /* synthetic */ Class class$org$apache$jasper$compiler$ServiceMethodPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$FileDeclarationPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$ClassDeclarationPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$StaticInitializerPhase;
    static /* synthetic */ Class class$org$apache$jasper$compiler$InitMethodPhase;

    JspParseEventListener(JspCompilationContext ctxt, ParserController parserCtl) {
        this.reader = ctxt.getReader();
        this.writer = ctxt.getWriter();
        this.ctxt = ctxt;
        this.parserCtl = parserCtl;
        this.beanInfo = new BeanRepository(ctxt.getClassLoader());
        this.libraries = new TagLibraries(ctxt.getClassLoader());
        if (ctxt.getOptions().getLargeFile()) {
            this.dataFile = String.valueOf(ctxt.getOutputDir()) + ctxt.getServletClassName() + ".dat";
        }
    }

    final void addGenerator(Generator gen) throws JasperException {
        gen.init(this.ctxt);
        this.generators.addElement(gen);
    }

    public void beginPageProcessing() throws JasperException {
        int i = 0;
        while (i < Constants.STANDARD_IMPORTS.length) {
            this.imports.addElement(Constants.STANDARD_IMPORTS[i]);
            ++i;
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void endPageProcessing() throws JasperException {
        this.generateHeader();
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$ServiceMethodPhase != null ? class$org$apache$jasper$compiler$ServiceMethodPhase : (class$org$apache$jasper$compiler$ServiceMethodPhase = JspParseEventListener.class$("org.apache.jasper.compiler.ServiceMethodPhase")));
        this.writer.println();
        this.generateFooter();
        if (this.ctxt.getOptions().getLargeFile()) {
            try {
                ObjectOutputStream o = new ObjectOutputStream(new FileOutputStream(this.dataFile));
                char[][] tempCharArray = new char[this.vector.size()][];
                this.vector.copyInto((Object[])tempCharArray);
                o.writeObject(tempCharArray);
                o.close();
                this.writer.close();
            }
            catch (IOException ex) {
                throw new JasperException(Constants.getString((String)"jsp.error.data.file.write"), (Throwable)ex);
            }
        }
        this.ctxt.setContentType(this.servletContentType);
    }

    private void generateAll(Class phase) throws JasperException {
        int i = 0;
        while (i < this.generators.size()) {
            Generator gen = (Generator)this.generators.elementAt(i);
            if (phase.isInstance(gen)) {
                gen.generate(this.writer, phase);
            }
            ++i;
        }
    }

    private void generateFooter() throws JasperException {
        this.writer.popIndent();
        this.writer.println("} catch (Throwable t) {");
        this.writer.pushIndent();
        this.writer.println("if (out != null && out.getBufferSize() != 0)");
        this.writer.pushIndent();
        this.writer.println("out.clearBuffer();");
        this.writer.popIndent();
        this.writer.println("if (pageContext != null) pageContext.handlePageException(t);");
        this.writer.popIndent();
        this.writer.println("} finally {");
        this.writer.pushIndent();
        this.writer.println("if (_jspxFactory != null) _jspxFactory.releasePageContext(pageContext);");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
    }

    private void generateHeader() throws JasperException {
        String servletPackageName = this.ctxt.getServletPackageName();
        String servletClassName = this.ctxt.getServletClassName();
        if (!"".equals(servletPackageName) && servletPackageName != null) {
            this.writer.println("package " + servletPackageName + ";");
            this.writer.println();
        }
        Enumeration e = this.imports.elements();
        while (e.hasMoreElements()) {
            this.writer.println("import " + (String)e.nextElement() + ";");
        }
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$FileDeclarationPhase != null ? class$org$apache$jasper$compiler$FileDeclarationPhase : (class$org$apache$jasper$compiler$FileDeclarationPhase = JspParseEventListener.class$("org.apache.jasper.compiler.FileDeclarationPhase")));
        this.writer.println();
        this.writer.print("public class " + servletClassName + " extends ");
        this.writer.print(this.extendsClass.equals("") ? this.jspServletBase : this.extendsClass);
        if (this.singleThreaded) {
            this.interfaces.addElement("SingleThreadModel");
        }
        if (this.interfaces.size() != 0) {
            this.writer.println();
            this.writer.println("     implements ");
            int i = 0;
            while (i < this.interfaces.size() - 1) {
                this.writer.println(" " + this.interfaces.elementAt(i) + ",");
                ++i;
            }
            this.writer.println(" " + this.interfaces.elementAt(this.interfaces.size() - 1));
        }
        this.writer.println(" {");
        this.writer.pushIndent();
        this.writer.println();
        this.generateAll(class$org$apache$jasper$compiler$ClassDeclarationPhase != null ? class$org$apache$jasper$compiler$ClassDeclarationPhase : (class$org$apache$jasper$compiler$ClassDeclarationPhase = JspParseEventListener.class$("org.apache.jasper.compiler.ClassDeclarationPhase")));
        this.writer.println();
        this.writer.println("static {");
        this.writer.pushIndent();
        this.generateAll(class$org$apache$jasper$compiler$StaticInitializerPhase != null ? class$org$apache$jasper$compiler$StaticInitializerPhase : (class$org$apache$jasper$compiler$StaticInitializerPhase = JspParseEventListener.class$("org.apache.jasper.compiler.StaticInitializerPhase")));
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println("public " + servletClassName + "( ) {");
        this.writer.println("}");
        this.writer.println();
        this.writer.println("private static boolean _jspx_inited = false;");
        this.writer.println();
        this.writer.println("public final void _jspx_init() throws org.apache.jasper.runtime.JspException {");
        this.writer.pushIndent();
        this.generateAll(class$org$apache$jasper$compiler$InitMethodPhase != null ? class$org$apache$jasper$compiler$InitMethodPhase : (class$org$apache$jasper$compiler$InitMethodPhase = JspParseEventListener.class$("org.apache.jasper.compiler.InitMethodPhase")));
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println();
        this.writer.println("public void " + this.serviceMethodName + "(" + "HttpServletRequest request, " + "HttpServletResponse  response)");
        this.writer.println("    throws java.io.IOException, ServletException {");
        this.writer.pushIndent();
        this.writer.println();
        this.writer.println("JspFactory _jspxFactory = null;");
        this.writer.println("PageContext pageContext = null;");
        if (this.genSessionVariable) {
            this.writer.println("HttpSession session = null;");
        }
        if (this.ctxt.isErrorPage()) {
            this.writer.println("Throwable exception = (Throwable) request.getAttribute(\"javax.servlet.jsp.jspException\");");
        }
        this.writer.println("ServletContext application = null;");
        this.writer.println("ServletConfig config = null;");
        this.writer.println("JspWriter out = null;");
        this.writer.println("Object page = this;");
        this.writer.println("String  _value = null;");
        this.writer.println("try {");
        this.writer.pushIndent();
        this.writer.println();
        this.writer.println("if (_jspx_inited == false) {");
        this.writer.pushIndent();
        this.writer.println("synchronized (this) {");
        this.writer.pushIndent();
        this.writer.println("if (_jspx_inited == false) {");
        this.writer.pushIndent();
        this.writer.println("_jspx_init();");
        this.writer.println("_jspx_inited = true;");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.popIndent();
        this.writer.println("}");
        this.writer.println("_jspxFactory = JspFactory.getDefaultFactory();");
        if (this.servletContentType == null) {
            this.servletContentType = String.valueOf(this.defaultType) + (this.pageEncoding == null ? this.defaultCharset : this.pageEncoding);
        }
        this.writer.println("response.setContentType(" + this.writer.quoteString(this.servletContentType) + ");");
        this.writer.println("pageContext = _jspxFactory.getPageContext(this, request, response,");
        this.writer.println("\t\t\t" + this.writer.quoteString(this.error) + ", " + this.genSessionVariable + ", " + this.bufferSize + ", " + this.autoFlush + ");");
        this.writer.println();
        this.writer.println("application = pageContext.getServletContext();");
        this.writer.println("config = pageContext.getServletConfig();");
        if (this.genSessionVariable) {
            this.writer.println("session = pageContext.getSession();");
        }
        this.writer.println("out = pageContext.getOut();");
    }

    private Stack getTagHandlerStack() {
        if (this.tagHandlerStack == null) {
            this.tagHandlerStack = new Stack();
        }
        return this.tagHandlerStack;
    }

    public TagLibraries getTagLibraries() {
        return this.libraries;
    }

    private Hashtable getTagVarNumbers() {
        if (this.tagVarNumbers == null) {
            this.tagVarNumbers = new Hashtable();
        }
        return this.tagVarNumbers;
    }

    public void handleBean(Mark start, Mark stop, Attributes attrs) throws JasperException {
        this.handleBean(start, stop, attrs, false);
    }

    public void handleBean(Mark start, Mark stop, Attributes attrs, boolean isXml) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new BeanGenerator(start, attrs, this.beanInfo, this.genSessionVariable, isXml), start, stop);
        this.addGenerator(gen);
        this.xo.append("jsp:useBean", attrs, false);
    }

    public void handleBeanEnd(Mark start, Mark stop, Attributes attrs) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new BeanEndGenerator(), start, stop);
        this.addGenerator(gen);
        this.xo.append("jsp:useBean");
    }

    public void handleCharData(Mark start, Mark stop, char[] chars) throws JasperException {
        GeneratorBase cdg = this.ctxt.getOptions().getLargeFile() ? new StoredCharDataGenerator(this.vector, this.dataFile, this.stringId++, chars) : (this.ctxt.getOptions().getMappedFile() ? new MappedCharDataGenerator(chars) : new CharDataGenerator(chars));
        GeneratorWrapper gen = new GeneratorWrapper(cdg, start, stop);
        this.addGenerator(gen);
    }

    public void handleComment(Mark start, Mark stop, char[] text) throws JasperException {
        Constants.message((String)"jsp.message.htmlcomment", (Object[])new Object[]{text}, (int)4);
    }

    public void handleDeclaration(Mark start, Mark stop, Attributes attrs, char[] text) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new DeclarationGenerator(text), start, stop);
        this.addGenerator(gen);
        this.xo.append("jsp:declaration", attrs, text);
    }

    public void handleDirective(String directive, Mark start, Mark stop, Attributes attrs) throws JasperException {
        Constants.message((String)"jsp.message.handling_directive", (Object[])new Object[]{directive, attrs}, (int)4);
        if (directive.equals("page")) {
            int attrsLength = attrs.getLength();
            int j = 0;
            while (j < attrsLength) {
                String attr = attrs.getQName(j);
                int i = 0;
                while (i < this.pdhis.length) {
                    PageDirectiveHandlerInfo pdhi = this.pdhis[i];
                    if (attr.equals(pdhi.attribute)) {
                        String value = attrs.getValue(j);
                        pdhi.handler.handlePageDirectiveAttribute(this, value, start, stop);
                    }
                    ++i;
                }
                ++j;
            }
        }
        if (this.bufferSize == 0 && !this.autoFlush) {
            throw new CompileException(start, Constants.getString((String)"jsp.error.page.bad_b_and_a_combo"));
        }
        if (directive.equals("taglib")) {
            String uri = attrs.getValue("uri");
            String prefix = attrs.getValue("prefix");
            this.processTaglibDirective(uri, prefix);
            this.xo.addRootNamespaces(prefix, uri);
        } else if (directive.equals("include")) {
            String file = attrs.getValue("file");
            if (file == null) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.include.missing.file"));
            }
            try {
                this.parserCtl.parse(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.file.not.found", (Object[])new Object[]{file}));
            }
            catch (Exception ex) {
                throw new CompileException(start, ex.getMessage());
            }
        } else if (!directive.equals("include")) {
            this.xo.append("jsp:directive." + directive, attrs, true);
        }
    }

    public void handleExpression(Mark start, Mark stop, Attributes attrs, char[] text) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new ExpressionGenerator(text), start, stop);
        this.addGenerator(gen);
        this.xo.append("jsp:expression", attrs, text);
    }

    public void handleForward(Mark start, Mark stop, Attributes attrs, Hashtable param) throws JasperException {
        this.handleForward(start, stop, attrs, param, false);
    }

    public void handleForward(Mark start, Mark stop, Attributes attrs, Hashtable param, boolean isXml) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new ForwardGenerator(start, attrs, param, isXml), start, stop);
        this.addGenerator(gen);
        this.xo.append("jsp:forward", attrs, false);
        this.xo.append("jsp:param", param);
        this.xo.append("jsp:forward");
    }

    public void handleGetProperty(Mark start, Mark stop, Attributes attrs) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new GetPropertyGenerator(start, stop, attrs, this.beanInfo), start, stop);
        this.addGenerator(gen);
        this.xo.append("jsp:getProperty", attrs, true);
    }

    public void handleInclude(Mark start, Mark stop, Attributes attrs, Hashtable param) throws JasperException {
        this.handleInclude(start, stop, attrs, param, false);
    }

    public void handleInclude(Mark start, Mark stop, Attributes attrs, Hashtable param, boolean isXml) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new IncludeGenerator(start, attrs, param, isXml), start, stop);
        this.addGenerator(gen);
        this.xo.append("jsp:include", attrs, false);
        this.xo.append("jsp:param", param);
        this.xo.append("jsp:include");
    }

    public void handleJspCdata(Mark start, Mark stop, char[] data) throws JasperException {
        if (data != null) {
            this.handleCharData(start, stop, data);
            this.xo.append("jsp:text", null, data);
        }
    }

    public void handlePlugin(Mark start, Mark stop, Attributes attrs, Hashtable param, String fallback) throws JasperException {
        this.handlePlugin(start, stop, attrs, param, fallback, false);
    }

    public void handlePlugin(Mark start, Mark stop, Attributes attrs, Hashtable param, String fallback, boolean isXml) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new PluginGenerator(start, attrs, param, fallback, isXml), start, stop);
        this.addGenerator(gen);
    }

    public void handleRootBegin(Attributes attrs) throws JasperException {
        int attrsLength = attrs.getLength();
        int i = 0;
        while (i < attrsLength) {
            String prefix;
            String qName = attrs.getQName(i);
            if (qName.startsWith("xmlns:") && !(prefix = qName.substring(6)).equals("jsp")) {
                String uri = attrs.getValue(i);
                if (uri.startsWith("urn:jsptld:")) {
                    uri = uri.substring(11);
                }
                this.processTaglibDirective(uri, prefix);
            }
            ++i;
        }
        this.xo.addRootAttrs(attrs);
    }

    public void handleRootEnd() {
        this.xo.rootEnd();
    }

    public void handleScriptlet(Mark start, Mark stop, Attributes attrs, char[] text) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new ScriptletGenerator(text), start, stop);
        this.addGenerator(gen);
        this.xo.append("jsp:scriptlet", attrs, text);
    }

    public void handleSetProperty(Mark start, Mark stop, Attributes attrs) throws JasperException {
        this.handleSetProperty(start, stop, attrs, false);
    }

    public void handleSetProperty(Mark start, Mark stop, Attributes attrs, boolean isXml) throws JasperException {
        GeneratorWrapper gen = new GeneratorWrapper(new SetPropertyGenerator(start, stop, attrs, this.beanInfo, isXml), start, stop);
        this.addGenerator(gen);
        this.xo.append("jsp:setProperty", attrs, true);
    }

    public void handleTagBegin(Mark start, Mark stop, Attributes attrs, String prefix, String shortTagName, TagLibraryInfo tli, TagInfo ti, boolean hasBody) throws JasperException {
        this.handleTagBegin(start, stop, attrs, prefix, shortTagName, tli, ti, hasBody, false);
    }

    public void handleTagBegin(Mark start, Mark stop, Attributes attrs, String prefix, String shortTagName, TagLibraryInfo tli, TagInfo ti, boolean hasBody, boolean isXml) throws JasperException {
        TagBeginGenerator tbg = new TagBeginGenerator(start, prefix, shortTagName, attrs, tli, ti, this.libraries, this.getTagHandlerStack(), this.getTagVarNumbers(), hasBody, isXml);
        GeneratorWrapper gen = new GeneratorWrapper(tbg, start, stop);
        this.addGenerator(gen);
        this.xo.append(String.valueOf(prefix) + ":" + shortTagName, attrs, false);
    }

    public void handleTagEnd(Mark start, Mark stop, String prefix, String shortTagName, Attributes attrs, TagLibraryInfo tli, TagInfo ti, boolean hasBody) throws JasperException {
        TagEndGenerator teg = new TagEndGenerator(prefix, shortTagName, attrs, tli, ti, this.libraries, this.getTagHandlerStack(), this.getTagVarNumbers(), hasBody);
        GeneratorWrapper gen = new GeneratorWrapper(teg, start, stop);
        this.addGenerator(gen);
        this.xo.append(String.valueOf(prefix) + ":" + shortTagName);
    }

    public void handleUninterpretedTagBegin(Mark start, Mark stop, String rawName, Attributes attrs) throws JasperException {
        UninterpretedTagBeginGenerator gen = new UninterpretedTagBeginGenerator(rawName, attrs);
        GeneratorWrapper genWrapper = new GeneratorWrapper(gen, start, stop);
        this.addGenerator(genWrapper);
        this.xo.append(rawName, attrs, false);
    }

    public void handleUninterpretedTagEnd(Mark start, Mark stop, String rawName, char[] data) throws JasperException {
        if (data != null) {
            this.handleCharData(start, stop, data);
            this.xo.append(data);
        }
        UninterpretedTagEndGenerator gen = new UninterpretedTagEndGenerator(rawName);
        GeneratorWrapper genWrapper = new GeneratorWrapper(gen, start, stop);
        this.addGenerator(genWrapper);
        this.xo.append(rawName);
    }

    private void processTaglibDirective(String uri, String prefix) throws JasperException {
        TagLibraryInfoImpl tl = null;
        String[] location = this.ctxt.getTldLocation(uri);
        tl = location == null ? new TagLibraryInfoImpl(this.ctxt, prefix, uri) : new TagLibraryInfoImpl(this.ctxt, prefix, uri, location);
        this.libraries.addTagLibrary(prefix, tl);
    }

    public static void setCommentGenerator(CommentGenerator generator) {
        if (commentGenerator == null) {
            throw new IllegalArgumentException("null == generator");
        }
        commentGenerator = generator;
    }

    public void setDefault(boolean isXml) {
        if (isXml) {
            this.defaultType = "text/xml;";
            this.defaultCharset = "UTF-8";
        } else {
            this.defaultType = "text/html;";
            this.defaultCharset = "ISO-8859-1";
        }
    }

    public void setReader(JspReader reader) {
        this.reader = reader;
    }

    public void setTemplateInfo(Mark start, Mark stop) {
    }

    public void validate() throws JasperException {
        StringBuffer errMessage = new StringBuffer();
        Enumeration enumeration = this.libraries.getTagLibInfos();
        boolean hasErrors = false;
        while (enumeration.hasMoreElements()) {
            TagLibraryInfo tli = (TagLibraryInfo)enumeration.nextElement();
            ValidationMessage[] errors = ((TagLibraryInfoImpl)tli).validate(this.xo.getPageData());
            if (errors == null || errors.length == 0) continue;
            hasErrors = true;
            errMessage.append("<h3>");
            errMessage.append(Constants.getString((String)"jsp.error.taglibraryvalidator.invalidpage", (Object[])new Object[]{tli.getShortName()}));
            errMessage.append("</h3>");
            int i = 0;
            while (i < errors.length) {
                String id = errors[i].getId();
                if (id != null) {
                    errMessage.append(errors[i].getId());
                    errMessage.append(": ");
                }
                errMessage.append(errors[i].getMessage());
                ++i;
            }
        }
        if (hasErrors) {
            throw new JasperException(errMessage.toString());
        }
    }

    static interface PageDirectiveHandler {
        public void handlePageDirectiveAttribute(JspParseEventListener var1, String var2, Mark var3, Mark var4) throws JasperException;
    }

    static final class PageDirectiveHandlerInfo {
        String attribute;
        PageDirectiveHandler handler;

        PageDirectiveHandlerInfo(String attribute, PageDirectiveHandler handler) {
            this.attribute = attribute;
            this.handler = handler;
        }
    }

    static final class ContentTypeHandler
    implements PageDirectiveHandler {
        ContentTypeHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String contentType, Mark start, Mark stop) throws JasperException {
            if (listener.contentTypeDir) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.multiple.contenttypes"));
            }
            listener.contentTypeDir = true;
            if (contentType == null) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.invalid.contenttype"));
            }
            listener.servletContentType = contentType;
        }
    }

    static final class PageEncodingHandler
    implements PageDirectiveHandler {
        PageEncodingHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String pageEncoding, Mark start, Mark stop) throws JasperException {
            if (pageEncoding == null) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.invalid.pageencoding"));
            }
            listener.pageEncoding = pageEncoding;
        }
    }

    static final class SessionHandler
    implements PageDirectiveHandler {
        SessionHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String session, Mark start, Mark stop) throws JasperException {
            if (listener.sessionDir) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.multiple.session"));
            }
            listener.sessionDir = true;
            if (session == null) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.invalid.session"));
            }
            if (session.equalsIgnoreCase("true")) {
                listener.genSessionVariable = true;
            } else if (session.equalsIgnoreCase("false")) {
                listener.genSessionVariable = false;
            } else {
                throw new CompileException(start, "Invalid value for session");
            }
        }
    }

    static final class BufferHandler
    implements PageDirectiveHandler {
        BufferHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String buffer, Mark start, Mark stop) throws JasperException {
            if (listener.bufferDir) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.multiple.buffer"));
            }
            listener.bufferDir = true;
            if (buffer != null) {
                if (buffer.equalsIgnoreCase("none")) {
                    listener.bufferSize = 0;
                } else {
                    Integer i = null;
                    try {
                        int ind = buffer.indexOf("k");
                        String num = ind == -1 ? buffer : buffer.substring(0, ind);
                        i = new Integer(num);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new CompileException(start, Constants.getString((String)"jsp.error.page.invalid.buffer"));
                    }
                    listener.bufferSize = i * 1024;
                }
            } else {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.invalid.buffer"));
            }
        }
    }

    static final class AutoFlushHandler
    implements PageDirectiveHandler {
        AutoFlushHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String autoflush, Mark start, Mark stop) throws JasperException {
            if (listener.autoFlushDir) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.multiple.autoflush"));
            }
            listener.autoFlushDir = true;
            if (autoflush == null) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.invalid.autoflush"));
            }
            if (autoflush.equalsIgnoreCase("true")) {
                listener.autoFlush = true;
            } else if (autoflush.equalsIgnoreCase("false")) {
                listener.autoFlush = false;
            } else {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.invalid.autoflush"));
            }
        }
    }

    static final class IsThreadSafeHandler
    implements PageDirectiveHandler {
        IsThreadSafeHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String threadsafe, Mark start, Mark stop) throws JasperException {
            if (listener.threadsafeDir) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.multiple.threadsafe"));
            }
            listener.threadsafeDir = true;
            if (threadsafe == null) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.invalid.threadsafe"));
            }
            if (threadsafe.equalsIgnoreCase("true")) {
                listener.singleThreaded = false;
            } else if (threadsafe.equalsIgnoreCase("false")) {
                listener.singleThreaded = true;
            } else {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.invalid.threadsafe"));
            }
        }
    }

    static final class InfoHandler
    implements PageDirectiveHandler {
        InfoHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String info, Mark start, Mark stop) throws JasperException {
            if (listener.infoDir) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.multiple.info"));
            }
            listener.infoDir = true;
            if (info == null) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.invalid.info"));
            }
            JspParseEventListener jspParseEventListener = listener;
            jspParseEventListener.getClass();
            GeneratorWrapper gen = jspParseEventListener.new GeneratorWrapper(new InfoGenerator(info), start, stop);
            listener.addGenerator(gen);
        }
    }

    static final class IsErrorPageHandler
    implements PageDirectiveHandler {
        IsErrorPageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String iserrorpage, Mark start, Mark stop) throws JasperException {
            if (listener.iserrorpageDir) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.multiple.iserrorpage"));
            }
            listener.iserrorpageDir = true;
            if (iserrorpage == null) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.invalid.iserrorpage"));
            }
            if (iserrorpage.equalsIgnoreCase("true")) {
                listener.ctxt.setErrorPage(true);
            } else if (iserrorpage.equalsIgnoreCase("false")) {
                listener.ctxt.setErrorPage(false);
            } else {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.invalid.iserrorpage"));
            }
        }
    }

    static final class ErrorPageHandler
    implements PageDirectiveHandler {
        ErrorPageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String errorpage, Mark start, Mark stop) throws JasperException {
            if (listener.errorpageDir) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.multiple.errorpage"));
            }
            listener.errorpageDir = true;
            if (errorpage != null) {
                listener.error = errorpage;
            }
        }
    }

    static final class LanguageHandler
    implements PageDirectiveHandler {
        LanguageHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String language, Mark start, Mark stop) throws JasperException {
            if (listener.languageDir) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.multiple.language"));
            }
            listener.languageDir = true;
            if (language != null && !language.equalsIgnoreCase("java")) {
                throw new CompileException(start, String.valueOf(Constants.getString((String)"jsp.error.page.nomapping.language")) + language);
            }
        }
    }

    static final class ImportsHandler
    implements PageDirectiveHandler {
        ImportsHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String importPkgs, Mark start, Mark stop) throws JasperException {
            if (importPkgs != null) {
                StringTokenizer tokenizer = new StringTokenizer(importPkgs, ",");
                while (tokenizer.hasMoreTokens()) {
                    listener.imports.addElement(tokenizer.nextToken());
                }
            }
        }
    }

    static final class ExtendsHandler
    implements PageDirectiveHandler {
        ExtendsHandler() {
        }

        public void handlePageDirectiveAttribute(JspParseEventListener listener, String extendsClzz, Mark start, Mark stop) throws JasperException {
            if (listener.extendsDir) {
                throw new CompileException(start, Constants.getString((String)"jsp.error.page.multiple.extends"));
            }
            listener.extendsDir = true;
            if (extendsClzz != null) {
                listener.extendsClass = extendsClzz;
                if (extendsClzz.indexOf(".") == -1) {
                    listener.imports.addElement(extendsClzz);
                }
            }
        }
    }

    class GeneratorWrapper
    implements Generator,
    ClassDeclarationPhase,
    FileDeclarationPhase,
    ServiceMethodPhase,
    InitMethodPhase,
    StaticInitializerPhase {
        Generator generator;
        Mark start;
        Mark stop;

        GeneratorWrapper(Generator generator, Mark start, Mark stop) {
            this.generator = generator;
            this.start = start;
            this.stop = stop;
        }

        public void generate(ServletWriter out, Class phase) throws JasperException {
            if (phase.isInstance(this.generator)) {
                boolean genCoords = this.generator.generateCoordinates(phase);
                if (genCoords) {
                    commentGenerator.generateStartComment(this.generator, out, this.start, this.stop);
                }
                this.generator.generate(out, phase);
                if (genCoords) {
                    commentGenerator.generateEndComment(this.generator, out, this.start, this.stop);
                }
            }
        }

        public boolean generateCoordinates(Class phase) {
            return this.generator.generateCoordinates(phase);
        }

        public void init(JspCompilationContext ctxt) throws JasperException {
            this.generator.init(ctxt);
        }
    }
}

