/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorHandler;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Localizer;

class DefaultErrorHandler
implements ErrorHandler {
    DefaultErrorHandler() {
    }

    public void jspError(String fname, int line, int column, String errMsg, Exception ex) throws JasperException {
        throw new JasperException(fname + "(" + line + "," + column + ")" + " " + errMsg, (Throwable)ex);
    }

    public void jspError(String errMsg, Exception ex) throws JasperException {
        throw new JasperException(errMsg, (Throwable)ex);
    }

    public void javacError(JavacErrorDetail[] details) throws JasperException {
        Object[] args = null;
        StringBuffer buf = new StringBuffer();
        if (details.length == 1 && details[0].getJavaLineNumber() == -1) {
            buf.append(Localizer.getMessage("jsp.error.nojavac"));
            buf.append('\n');
        } else {
            for (int i = 0; i < details.length; ++i) {
                args = new Object[]{new Integer(details[i].getJspBeginLineNumber()), details[i].getJspFileName()};
                buf.append(Localizer.getMessage("jsp.error.single.line.number", args));
                buf.append(Localizer.getMessage("jsp.error.corresponding.servlet"));
                buf.append(details[i].getErrorMessage());
                buf.append('\n');
            }
        }
        throw new JasperException(Localizer.getMessage("jsp.error.unable.compile") + buf);
    }
}

