/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Stack;
import java.util.jar.JarFile;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JspConfig;
import org.apache.jasper.compiler.JspDocumentParser;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.Parser;
import org.apache.jasper.compiler.TagConstants;
import org.apache.jasper.xmlparser.XMLEncodingDetector;
import org.xml.sax.Attributes;

class ParserController
implements TagConstants {
    private static final String CHARSET = "charset=";
    private JspCompilationContext ctxt;
    private Compiler compiler;
    private ErrorDispatcher err;
    private boolean isXml;
    private Stack baseDirStack = new Stack();
    private boolean isEncodingSpecifiedInProlog;
    private String sourceEnc;
    private boolean isDefaultPageEncoding;
    private boolean isTagFile;
    private boolean directiveOnly;

    public ParserController(JspCompilationContext ctxt, Compiler compiler) {
        this.ctxt = ctxt;
        this.compiler = compiler;
        this.err = compiler.getErrorDispatcher();
    }

    public JspCompilationContext getJspCompilationContext() {
        return this.ctxt;
    }

    public Compiler getCompiler() {
        return this.compiler;
    }

    public Node.Nodes parse(String inFileName) throws FileNotFoundException, JasperException, IOException {
        this.isTagFile = this.ctxt.isTagFile();
        this.directiveOnly = false;
        return this.doParse(inFileName, null, this.ctxt.getTagFileJarUrl());
    }

    public Node.Nodes parse(String inFileName, Node parent, URL jarFileUrl) throws FileNotFoundException, JasperException, IOException {
        return this.doParse(inFileName, parent, jarFileUrl);
    }

    public Node.Nodes parseTagFileDirectives(String inFileName) throws FileNotFoundException, JasperException, IOException {
        boolean isTagFileSave = this.isTagFile;
        boolean directiveOnlySave = this.directiveOnly;
        this.isTagFile = true;
        this.directiveOnly = true;
        Node.Nodes page = this.doParse(inFileName, null, (URL)this.ctxt.getTagFileJarUrls().get(inFileName));
        this.directiveOnly = directiveOnlySave;
        this.isTagFile = isTagFileSave;
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Node.Nodes doParse(String inFileName, Node parent, URL jarFileUrl) throws FileNotFoundException, JasperException, IOException {
        JarFile jarFile;
        Node.Nodes parsedPage;
        block17: {
            parsedPage = null;
            this.isEncodingSpecifiedInProlog = false;
            this.isDefaultPageEncoding = false;
            jarFile = this.getJarFile(jarFileUrl);
            String absFileName = this.resolveFileName(inFileName);
            String jspConfigPageEnc = this.getJspConfigPageEncoding(absFileName);
            this.determineSyntaxAndEncoding(absFileName, jarFile, jspConfigPageEnc);
            if (parent != null) {
                this.compiler.getPageInfo().addDependant(absFileName);
            }
            if (!(!this.isXml || !this.isEncodingSpecifiedInProlog || jspConfigPageEnc == null || jspConfigPageEnc.equals(this.sourceEnc) || jspConfigPageEnc.startsWith("UTF-16") && this.sourceEnc.startsWith("UTF-16"))) {
                this.err.jspError("jsp.error.prolog_config_encoding_mismatch", this.sourceEnc, jspConfigPageEnc);
            }
            if (this.isXml) {
                InputStream inStream = null;
                try {
                    parsedPage = JspDocumentParser.parse(this, absFileName, jarFile, parent, this.isTagFile, this.directiveOnly, this.sourceEnc, jspConfigPageEnc, this.isEncodingSpecifiedInProlog);
                    Object var10_11 = null;
                    if (inStream == null) break block17;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (inStream == null) throw throwable;
                    try {
                        inStream.close();
                        throw throwable;
                    }
                    catch (Exception any) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception any) {}
                inStream.close();
            } else {
                InputStreamReader inStreamReader = null;
                try {
                    inStreamReader = JspUtil.getReader(absFileName, this.sourceEnc, jarFile, this.ctxt, this.err);
                    JspReader jspReader = new JspReader(this.ctxt, absFileName, this.sourceEnc, inStreamReader, this.err);
                    parsedPage = Parser.parse(this, jspReader, parent, this.isTagFile, this.directiveOnly, jarFileUrl, this.sourceEnc, jspConfigPageEnc, this.isDefaultPageEncoding);
                    Object var13_17 = null;
                    if (inStreamReader == null) break block17;
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    if (inStreamReader == null) throw throwable;
                    try {
                        inStreamReader.close();
                        throw throwable;
                    }
                    catch (Exception any) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception any) {}
                inStreamReader.close();
            }
        }
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.baseDirStack.pop();
        return parsedPage;
    }

    private String getJspConfigPageEncoding(String absFileName) throws JasperException {
        JspConfig jspConfig = this.ctxt.getOptions().getJspConfig();
        JspConfig.JspProperty jspProperty = jspConfig.findJspProperty(absFileName);
        return jspProperty.getPageEncoding();
    }

    private void determineSyntaxAndEncoding(String absFileName, JarFile jarFile, String jspConfigPageEnc) throws JasperException, IOException {
        this.isXml = false;
        boolean isExternal = false;
        boolean revert = false;
        JspConfig jspConfig = this.ctxt.getOptions().getJspConfig();
        JspConfig.JspProperty jspProperty = jspConfig.findJspProperty(absFileName);
        if (jspProperty.isXml() != null) {
            this.isXml = JspUtil.booleanValue(jspProperty.isXml());
            isExternal = true;
        } else if (absFileName.endsWith(".jspx") || absFileName.endsWith(".tagx")) {
            this.isXml = true;
            isExternal = true;
        }
        if (isExternal && !this.isXml) {
            this.sourceEnc = jspConfigPageEnc;
            if (this.sourceEnc != null) {
                return;
            }
            this.sourceEnc = "ISO-8859-1";
        } else {
            Object[] ret = XMLEncodingDetector.getEncoding(absFileName, jarFile, this.ctxt, this.err);
            this.sourceEnc = (String)ret[0];
            if (((Boolean)ret[1]).booleanValue()) {
                this.isEncodingSpecifiedInProlog = true;
            }
            if (!this.isXml && this.sourceEnc.equals("UTF-8")) {
                this.sourceEnc = "ISO-8859-1";
                revert = true;
            }
        }
        if (this.isXml) {
            return;
        }
        JspReader jspReader = null;
        try {
            jspReader = new JspReader(this.ctxt, absFileName, this.sourceEnc, jarFile, this.err);
        }
        catch (FileNotFoundException ex) {
            throw new JasperException((Throwable)ex);
        }
        jspReader.setSingleFile(true);
        Mark startMark = jspReader.mark();
        if (!isExternal) {
            jspReader.reset(startMark);
            if (this.hasJspRoot(jspReader)) {
                this.isXml = true;
                if (revert) {
                    this.sourceEnc = "UTF-8";
                }
                return;
            }
            this.isXml = false;
        }
        this.sourceEnc = jspConfigPageEnc;
        if (this.sourceEnc == null) {
            this.sourceEnc = this.getPageEncodingForJspSyntax(jspReader, startMark);
            if (this.sourceEnc == null) {
                this.sourceEnc = "ISO-8859-1";
                this.isDefaultPageEncoding = true;
            }
        }
    }

    private String getPageEncodingForJspSyntax(JspReader jspReader, Mark startMark) throws JasperException {
        Attributes attrs;
        String encoding = null;
        String saveEncoding = null;
        jspReader.reset(startMark);
        while (jspReader.skipUntil("<%@") != null) {
            jspReader.skipSpaces();
            if (!jspReader.matches("tag ") && !jspReader.matches("page")) continue;
            jspReader.skipSpaces();
            attrs = Parser.parseAttributes(this, jspReader);
            encoding = this.getPageEncodingFromDirective(attrs, "pageEncoding");
            if (encoding != null) break;
            encoding = this.getPageEncodingFromDirective(attrs, "contentType");
            if (encoding == null) continue;
            saveEncoding = encoding;
        }
        if (encoding == null) {
            encoding = saveEncoding;
        }
        if (encoding == null) {
            jspReader.reset(startMark);
            while (jspReader.skipUntil("<jsp:directive.page") != null) {
                jspReader.skipSpaces();
                attrs = Parser.parseAttributes(this, jspReader);
                encoding = this.getPageEncodingFromDirective(attrs, "pageEncoding");
                if (encoding != null) break;
                encoding = this.getPageEncodingFromDirective(attrs, "contentType");
                if (encoding == null) continue;
                saveEncoding = encoding;
            }
            if (encoding == null) {
                encoding = saveEncoding;
            }
        }
        return encoding;
    }

    private String getPageEncodingFromDirective(Attributes attrs, String attrName) {
        int loc;
        String value = attrs.getValue(attrName);
        if (attrName.equals("pageEncoding")) {
            return value;
        }
        String contentType = value;
        String encoding = null;
        if (contentType != null && (loc = contentType.indexOf(CHARSET)) != -1) {
            encoding = contentType.substring(loc + CHARSET.length());
        }
        return encoding;
    }

    private String resolveFileName(String inFileName) {
        String fileName = inFileName.replace('\\', '/');
        boolean isAbsolute = fileName.startsWith("/");
        fileName = isAbsolute ? fileName : (String)this.baseDirStack.peek() + fileName;
        String baseDir = fileName.substring(0, fileName.lastIndexOf("/") + 1);
        this.baseDirStack.push(baseDir);
        return fileName;
    }

    private boolean hasJspRoot(JspReader reader) throws JasperException {
        String xmlnsDecl;
        int c;
        Mark start = null;
        while ((start = reader.skipUntil("<")) != null && ((c = reader.nextChar()) == 33 || c == 63)) {
        }
        if (start == null) {
            return false;
        }
        Mark stop = reader.skipUntil(":root");
        if (stop == null) {
            return false;
        }
        String prefix = reader.getText(start, stop).substring(1);
        start = stop;
        stop = reader.skipUntil(">");
        if (stop == null) {
            return false;
        }
        String root = reader.getText(start, stop);
        int index = root.indexOf(xmlnsDecl = "xmlns:" + prefix);
        if (index == -1) {
            return false;
        }
        index += xmlnsDecl.length();
        while (index < root.length() && Character.isWhitespace(root.charAt(index))) {
            ++index;
        }
        if (index < root.length() && root.charAt(index) == '=') {
            ++index;
            while (index < root.length() && Character.isWhitespace(root.charAt(index))) {
                ++index;
            }
            if (index < root.length() && root.charAt(index++) == '\"' && root.regionMatches(index, "http://java.sun.com/JSP/Page", 0, "http://java.sun.com/JSP/Page".length())) {
                return true;
            }
        }
        return false;
    }

    private JarFile getJarFile(URL jarFileUrl) throws IOException {
        JarFile jarFile = null;
        if (jarFileUrl != null) {
            JarURLConnection conn = (JarURLConnection)jarFileUrl.openConnection();
            conn.setUseCaches(false);
            conn.connect();
            jarFile = conn.getJarFile();
        }
        return jarFile;
    }
}

