/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspConfig;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.TagPluginManager;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.servlet.JspCServletContext;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.tools.ant.AntClassLoader;

public class JspC
implements Options {
    public static final String DEFAULT_IE_CLASS_ID = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    private static Log log = LogFactory.getLog((Class)JspC.class);
    private static final String SWITCH_VERBOSE = "-v";
    private static final String SWITCH_HELP = "-help";
    private static final String SWITCH_QUIET = "-q";
    private static final String SWITCH_OUTPUT_DIR = "-d";
    private static final String SWITCH_IE_CLASS_ID = "-ieplugin";
    private static final String SWITCH_PACKAGE_NAME = "-p";
    private static final String SWITCH_CLASS_NAME = "-c";
    private static final String SWITCH_FULL_STOP = "--";
    private static final String SWITCH_COMPILE = "-compile";
    private static final String SWITCH_SOURCE = "-source";
    private static final String SWITCH_TARGET = "-target";
    private static final String SWITCH_URI_BASE = "-uribase";
    private static final String SWITCH_URI_ROOT = "-uriroot";
    private static final String SWITCH_FILE_WEBAPP = "-webapp";
    private static final String SWITCH_WEBAPP_INC = "-webinc";
    private static final String SWITCH_WEBAPP_XML = "-webxml";
    private static final String SWITCH_MAPPED = "-mapped";
    private static final String SWITCH_XPOWERED_BY = "-xpoweredBy";
    private static final String SWITCH_TRIM_SPACES = "-trimSpaces";
    private static final String SWITCH_CLASSPATH = "-classpath";
    private static final String SWITCH_DIE = "-die";
    private static final String SWITCH_POOLING = "-poolingEnabled";
    private static final String SWITCH_ENCODING = "-javaEncoding";
    private static final String SHOW_SUCCESS = "-s";
    private static final String LIST_ERRORS = "-l";
    private static final int NO_WEBXML = 0;
    private static final int INC_WEBXML = 10;
    private static final int ALL_WEBXML = 20;
    private static final int DEFAULT_DIE_LEVEL = 1;
    private static final int NO_DIE_LEVEL = 0;
    private static final String[] insertBefore = new String[]{"</web-app>", "<servlet-mapping>", "<session-config>", "<mime-mapping>", "<welcome-file-list>", "<error-page>", "<taglib>", "<resource-env-ref>", "<resource-ref>", "<security-constraint>", "<login-config>", "<security-role>", "<env-entry>", "<ejb-ref>", "<ejb-local-ref>"};
    private static int die;
    private String classPath = null;
    private URLClassLoader loader = null;
    private boolean trimSpaces = false;
    private boolean genStringAsCharArray = false;
    private boolean xpoweredBy;
    private boolean mappedFile = false;
    private boolean poolingEnabled = true;
    private File scratchDir;
    private String ieClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    private String targetPackage;
    private String targetClassName;
    private String uriBase;
    private String uriRoot;
    private int dieLevel;
    private boolean helpNeeded = false;
    private boolean compile = false;
    private String compiler = null;
    private String compilerTargetVM = "1.4";
    private String compilerSourceVM = "1.4";
    private boolean classDebugInfo = true;
    private List extensions;
    private Vector pages = new Vector();
    private boolean errorOnUseBeanInvalidClassAttribute = true;
    private String javaEncoding = "UTF-8";
    private String webxmlFile;
    private int webxmlLevel;
    private boolean addWebXmlMappings = false;
    private Writer mapout;
    private CharArrayWriter servletout;
    private CharArrayWriter mappingout;
    private JspCServletContext context;
    private JspRuntimeContext rctxt;
    private TldLocationsCache tldLocationsCache = null;
    private JspConfig jspConfig = null;
    private TagPluginManager tagPluginManager = null;
    private boolean verbose = false;
    private boolean listErrors = false;
    private boolean showSuccess = false;
    private int argPos;
    private boolean fullstop = false;
    private String[] args;

    public static void main(String[] arg) {
        block6: {
            if (arg.length == 0) {
                System.out.println(Localizer.getMessage("jspc.usage"));
            } else {
                try {
                    JspC jspc = new JspC();
                    jspc.setArgs(arg);
                    if (jspc.helpNeeded) {
                        System.out.println(Localizer.getMessage("jspc.usage"));
                    } else {
                        jspc.execute();
                    }
                }
                catch (JasperException je) {
                    System.err.println((Object)je);
                    if (die == 0) break block6;
                    System.exit(die);
                }
            }
        }
    }

    public void setArgs(String[] arg) throws JasperException {
        String file;
        String tok;
        this.args = arg;
        die = this.dieLevel = 0;
        while ((tok = this.nextArg()) != null) {
            if (tok.equals(SWITCH_VERBOSE)) {
                this.verbose = true;
                this.showSuccess = true;
                this.listErrors = true;
                continue;
            }
            if (tok.equals(SWITCH_OUTPUT_DIR)) {
                tok = this.nextArg();
                this.setOutputDir(tok);
                continue;
            }
            if (tok.equals(SWITCH_PACKAGE_NAME)) {
                this.targetPackage = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_COMPILE)) {
                this.compile = true;
                continue;
            }
            if (tok.equals(SWITCH_CLASS_NAME)) {
                this.targetClassName = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_URI_BASE)) {
                this.uriBase = this.nextArg();
                continue;
            }
            if (tok.equals(SWITCH_URI_ROOT)) {
                this.setUriroot(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_FILE_WEBAPP)) {
                this.setUriroot(this.nextArg());
                continue;
            }
            if (tok.equals(SHOW_SUCCESS)) {
                this.showSuccess = true;
                continue;
            }
            if (tok.equals(LIST_ERRORS)) {
                this.listErrors = true;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_INC)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 10;
                continue;
            }
            if (tok.equals(SWITCH_WEBAPP_XML)) {
                this.webxmlFile = this.nextArg();
                if (this.webxmlFile == null) continue;
                this.webxmlLevel = 20;
                continue;
            }
            if (tok.equals(SWITCH_MAPPED)) {
                this.mappedFile = true;
                continue;
            }
            if (tok.equals(SWITCH_XPOWERED_BY)) {
                this.xpoweredBy = true;
                continue;
            }
            if (tok.equals(SWITCH_TRIM_SPACES)) {
                this.setTrimSpaces(true);
                continue;
            }
            if (tok.equals(SWITCH_CLASSPATH)) {
                this.setClassPath(this.nextArg());
                continue;
            }
            if (tok.startsWith(SWITCH_DIE)) {
                try {
                    this.dieLevel = Integer.parseInt(tok.substring(SWITCH_DIE.length()));
                }
                catch (NumberFormatException nfe) {
                    this.dieLevel = 1;
                }
                die = this.dieLevel;
                continue;
            }
            if (tok.equals(SWITCH_HELP)) {
                this.helpNeeded = true;
                continue;
            }
            if (tok.equals(SWITCH_POOLING)) {
                tok = this.nextArg();
                if ("false".equals(tok)) {
                    this.poolingEnabled = false;
                    continue;
                }
                this.poolingEnabled = true;
                continue;
            }
            if (tok.equals(SWITCH_ENCODING)) {
                this.setJavaEncoding(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_SOURCE)) {
                this.setCompilerSourceVM(this.nextArg());
                continue;
            }
            if (tok.equals(SWITCH_TARGET)) {
                this.setCompilerTargetVM(this.nextArg());
                continue;
            }
            if (tok.startsWith("-")) {
                throw new JasperException("Unrecognized option: " + tok + ".  Use -help for help.");
            }
            if (this.fullstop) break;
            --this.argPos;
            break;
        }
        while ((file = this.nextFile()) != null) {
            this.pages.addElement(file);
        }
    }

    public boolean getKeepGenerated() {
        return true;
    }

    public boolean getTrimSpaces() {
        return this.trimSpaces;
    }

    public void setTrimSpaces(boolean ts) {
        this.trimSpaces = ts;
    }

    public boolean isPoolingEnabled() {
        return this.poolingEnabled;
    }

    public void setPoolingEnabled(boolean poolingEnabled) {
        this.poolingEnabled = poolingEnabled;
    }

    public boolean isXpoweredBy() {
        return this.xpoweredBy;
    }

    public void setXpoweredBy(boolean xpoweredBy) {
        this.xpoweredBy = xpoweredBy;
    }

    public boolean getErrorOnUseBeanInvalidClassAttribute() {
        return this.errorOnUseBeanInvalidClassAttribute;
    }

    public void setErrorOnUseBeanInvalidClassAttribute(boolean b) {
        this.errorOnUseBeanInvalidClassAttribute = b;
    }

    public int getTagPoolSize() {
        return 5;
    }

    public boolean getMappedFile() {
        return this.mappedFile;
    }

    public Object getProtectionDomain() {
        return null;
    }

    public boolean getSendErrorToClient() {
        return true;
    }

    public void setClassDebugInfo(boolean b) {
        this.classDebugInfo = b;
    }

    public boolean getClassDebugInfo() {
        return this.classDebugInfo;
    }

    public int getCheckInterval() {
        return 0;
    }

    public int getModificationTestInterval() {
        return 0;
    }

    public boolean getDevelopment() {
        return false;
    }

    public boolean isSmapSuppressed() {
        return true;
    }

    public boolean isSmapDumped() {
        return false;
    }

    public void setGenStringAsCharArray(boolean genStringAsCharArray) {
        this.genStringAsCharArray = genStringAsCharArray;
    }

    public boolean genStringAsCharArray() {
        return this.genStringAsCharArray;
    }

    public void setIeClassId(String ieClassId) {
        this.ieClassId = ieClassId;
    }

    public String getIeClassId() {
        return this.ieClassId;
    }

    public File getScratchDir() {
        return this.scratchDir;
    }

    public Class getJspCompilerPlugin() {
        return null;
    }

    public String getJspCompilerPath() {
        return null;
    }

    public String getCompiler() {
        return this.compiler;
    }

    public void setCompiler(String c) {
        this.compiler = c;
    }

    public String getCompilerTargetVM() {
        return this.compilerTargetVM;
    }

    public void setCompilerTargetVM(String vm) {
        this.compilerTargetVM = vm;
    }

    public String getCompilerSourceVM() {
        return this.compilerSourceVM;
    }

    public void setCompilerSourceVM(String vm) {
        this.compilerSourceVM = vm;
    }

    public TldLocationsCache getTldLocationsCache() {
        return this.tldLocationsCache;
    }

    public String getJavaEncoding() {
        return this.javaEncoding;
    }

    public void setJavaEncoding(String encodingName) {
        this.javaEncoding = encodingName;
    }

    public boolean getFork() {
        return false;
    }

    public String getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        return System.getProperty("java.class.path");
    }

    public void setClassPath(String s) {
        this.classPath = s;
    }

    public List getExtensions() {
        return this.extensions;
    }

    protected void addExtension(String extension) {
        if (extension != null) {
            if (this.extensions == null) {
                this.extensions = new Vector();
            }
            this.extensions.add(extension);
        }
    }

    public void setUriroot(String s) {
        if (s == null) {
            this.uriRoot = s;
            return;
        }
        try {
            this.uriRoot = new File(s).getCanonicalPath();
        }
        catch (Exception ex) {
            this.uriRoot = s;
        }
    }

    public void setJspFiles(String jspFiles) {
        StringTokenizer tok = new StringTokenizer(jspFiles, " ,");
        while (tok.hasMoreTokens()) {
            this.pages.addElement(tok.nextToken());
        }
    }

    public void setCompile(boolean b) {
        this.compile = b;
    }

    public void setVerbose(int level) {
        if (level > 0) {
            this.verbose = true;
            this.showSuccess = true;
            this.listErrors = true;
        }
    }

    public void setValidateXml(boolean b) {
        ParserUtils.validating = b;
    }

    public void setListErrors(boolean b) {
        this.listErrors = b;
    }

    public void setOutputDir(String s) {
        this.scratchDir = s != null ? new File(s).getAbsoluteFile() : null;
    }

    public void setPackage(String p) {
        this.targetPackage = p;
    }

    public void setClassName(String p) {
        this.targetClassName = p;
    }

    public void setWebXmlFragment(String s) {
        this.webxmlFile = s;
        this.webxmlLevel = 10;
    }

    public void setWebXml(String s) {
        this.webxmlFile = s;
        this.webxmlLevel = 20;
    }

    public void setAddWebXmlMappings(boolean b) {
        this.addWebXmlMappings = b;
    }

    public JspConfig getJspConfig() {
        return this.jspConfig;
    }

    public TagPluginManager getTagPluginManager() {
        return this.tagPluginManager;
    }

    public void generateWebMapping(String file, JspCompilationContext clctxt) throws IOException {
        String className = clctxt.getServletClassName();
        String packageName = clctxt.getServletPackageName();
        String thisServletName = "".equals(packageName) ? className : packageName + '.' + className;
        if (this.servletout != null) {
            this.servletout.write("\n    <servlet>\n        <servlet-name>");
            this.servletout.write(thisServletName);
            this.servletout.write("</servlet-name>\n        <servlet-class>");
            this.servletout.write(thisServletName);
            this.servletout.write("</servlet-class>\n    </servlet>\n");
        }
        if (this.mappingout != null) {
            this.mappingout.write("\n    <servlet-mapping>\n        <servlet-name>");
            this.mappingout.write(thisServletName);
            this.mappingout.write("</servlet-name>\n        <url-pattern>");
            this.mappingout.write(file.replace('\\', '/'));
            this.mappingout.write("</url-pattern>\n    </servlet-mapping>\n");
        }
    }

    protected void mergeIntoWebXml() throws IOException {
        int n;
        File webappBase = new File(this.uriRoot);
        File webXml = new File(webappBase, "WEB-INF/web.xml");
        File webXml2 = new File(webappBase, "WEB-INF/web2.xml");
        String insertStartMarker = Localizer.getMessage("jspc.webinc.insertStart");
        String insertEndMarker = Localizer.getMessage("jspc.webinc.insertEnd");
        BufferedReader reader = new BufferedReader(new FileReader(webXml));
        BufferedReader fragmentReader = new BufferedReader(new FileReader(this.webxmlFile));
        PrintWriter writer = new PrintWriter(new FileWriter(webXml2));
        int pos = -1;
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(insertStartMarker) >= 0) {
                do {
                    if ((line = reader.readLine()) != null) continue;
                    return;
                } while (line.indexOf(insertEndMarker) < 0);
                line = reader.readLine();
                line = reader.readLine();
                if (line == null) {
                    return;
                }
            }
            for (int i = 0; i < insertBefore.length && (pos = line.indexOf(insertBefore[i])) < 0; ++i) {
            }
            if (pos >= 0) {
                writer.print(line.substring(0, pos));
                break;
            }
            writer.println(line);
        }
        writer.println(insertStartMarker);
        while (true) {
            String line2;
            if ((line2 = fragmentReader.readLine()) == null) break;
            writer.println(line2);
        }
        writer.println();
        writer.println(insertEndMarker);
        writer.println();
        for (int i = 0; i < pos; ++i) {
            writer.print(" ");
        }
        writer.println(line.substring(pos));
        while ((line = reader.readLine()) != null) {
            writer.println(line);
        }
        writer.close();
        reader.close();
        fragmentReader.close();
        FileInputStream fis = new FileInputStream(webXml2);
        FileOutputStream fos = new FileOutputStream(webXml);
        byte[] buf = new byte[512];
        while ((n = fis.read(buf)) >= 0) {
            fos.write(buf, 0, n);
        }
        fis.close();
        fos.close();
        webXml2.delete();
        new File(this.webxmlFile).delete();
    }

    private void processFile(String file) throws JasperException {
        ClassLoader originalClassLoader = null;
        try {
            block16: {
                try {
                    if (this.scratchDir == null) {
                        String temp = System.getProperty("java.io.tmpdir");
                        if (temp == null) {
                            temp = "";
                        }
                        this.scratchDir = new File(new File(temp).getAbsolutePath());
                    }
                    String jspUri = file.replace('\\', '/');
                    JspCompilationContext clctxt = new JspCompilationContext(jspUri, false, this, this.context, null, this.rctxt);
                    if (this.targetClassName != null && this.targetClassName.length() > 0) {
                        clctxt.setServletClassName(this.targetClassName);
                        this.targetClassName = null;
                    }
                    if (this.targetPackage != null) {
                        clctxt.setServletPackageName(this.targetPackage);
                    }
                    originalClassLoader = Thread.currentThread().getContextClassLoader();
                    if (this.loader == null) {
                        this.initClassLoader(clctxt);
                    }
                    Thread.currentThread().setContextClassLoader(this.loader);
                    clctxt.setClassLoader(this.loader);
                    clctxt.setClassPath(this.classPath);
                    Compiler clc = clctxt.createCompiler();
                    if (clc.isOutDated(this.compile)) {
                        clc.compile(this.compile, true);
                    }
                    this.generateWebMapping(file, clctxt);
                    if (!this.showSuccess) break block16;
                    log.info((Object)("Built File: " + file));
                }
                catch (JasperException je) {
                    Throwable rootCause = je;
                    while (rootCause instanceof JasperException && rootCause.getRootCause() != null) {
                        rootCause = rootCause.getRootCause();
                    }
                    if (rootCause != je) {
                        log.error((Object)Localizer.getMessage("jspc.error.generalException", file), rootCause);
                    }
                    throw je;
                }
                catch (Exception e) {
                    if (e instanceof FileNotFoundException && log.isWarnEnabled()) {
                        log.warn((Object)Localizer.getMessage("jspc.error.fileDoesNotExist", e.getMessage()));
                    }
                    throw new JasperException((Throwable)e);
                }
            }
            Object var7_9 = null;
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (originalClassLoader != null) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
            throw throwable;
        }
    }

    public void scanFiles(File base) throws JasperException {
        Stack<Object> dirs = new Stack<Object>();
        dirs.push(base);
        if (this.getExtensions() == null || this.getExtensions().size() < 2) {
            this.addExtension("jsp");
            this.addExtension("jspx");
        }
        while (!dirs.isEmpty()) {
            String s = dirs.pop().toString();
            File f = new File(s);
            if (!f.exists() || !f.isDirectory()) continue;
            String[] files = f.list();
            for (int i = 0; files != null && i < files.length; ++i) {
                File f2 = new File(s, files[i]);
                if (f2.isDirectory()) {
                    dirs.push(f2.getPath());
                    continue;
                }
                String path = f2.getPath();
                String uri = path.substring(this.uriRoot.length());
                String ext = files[i].substring(files[i].lastIndexOf(46) + 1);
                if (!this.getExtensions().contains(ext) && !this.jspConfig.isJspPage(uri)) continue;
                this.pages.addElement(path);
            }
        }
    }

    public void execute() throws JasperException {
        try {
            File uriRootF;
            if (this.uriRoot == null) {
                if (this.pages.size() == 0) {
                    throw new JasperException(Localizer.getMessage("jsp.error.jspc.missingTarget"));
                }
                String firstJsp = (String)this.pages.elementAt(0);
                File firstJspF = new File(firstJsp);
                if (!firstJspF.exists()) {
                    throw new JasperException(Localizer.getMessage("jspc.error.fileDoesNotExist", firstJsp));
                }
                this.locateUriRoot(firstJspF);
            }
            if (this.uriRoot == null) {
                throw new JasperException(Localizer.getMessage("jsp.error.jspc.no_uriroot"));
            }
            if (this.context == null) {
                this.initServletContext();
            }
            if (this.pages.size() == 0) {
                this.scanFiles(new File(this.uriRoot));
            }
            if (!(uriRootF = new File(this.uriRoot)).exists() || !uriRootF.isDirectory()) {
                throw new JasperException(Localizer.getMessage("jsp.error.jspc.uriroot_not_dir"));
            }
            this.initWebXml();
            Enumeration e = this.pages.elements();
            while (e.hasMoreElements()) {
                String nextjsp = e.nextElement().toString();
                File fjsp = new File(nextjsp);
                if (!fjsp.isAbsolute()) {
                    fjsp = new File(uriRootF, nextjsp);
                }
                if (!fjsp.exists()) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)Localizer.getMessage("jspc.error.fileDoesNotExist", fjsp.toString()));
                    continue;
                }
                String s = fjsp.getAbsolutePath();
                if (s.startsWith(this.uriRoot)) {
                    nextjsp = s.substring(this.uriRoot.length());
                }
                if (nextjsp.startsWith("." + File.separatorChar)) {
                    nextjsp = nextjsp.substring(2);
                }
                this.processFile(nextjsp);
            }
            this.completeWebXml();
            if (this.addWebXmlMappings) {
                this.mergeIntoWebXml();
            }
        }
        catch (IOException ioe) {
            throw new JasperException((Throwable)ioe);
        }
        catch (JasperException je) {
            Throwable rootCause = je;
            while (rootCause instanceof JasperException && rootCause.getRootCause() != null) {
                rootCause = rootCause.getRootCause();
            }
            if (rootCause != je) {
                rootCause.printStackTrace();
            }
            throw je;
        }
    }

    private String nextArg() {
        if (this.argPos >= this.args.length || (this.fullstop = SWITCH_FULL_STOP.equals(this.args[this.argPos]))) {
            return null;
        }
        return this.args[this.argPos++];
    }

    private String nextFile() {
        if (this.fullstop) {
            ++this.argPos;
        }
        if (this.argPos >= this.args.length) {
            return null;
        }
        return this.args[this.argPos++];
    }

    private void initWebXml() {
        try {
            if (this.webxmlLevel >= 10) {
                File fmapings = new File(this.webxmlFile);
                this.mapout = new FileWriter(fmapings);
                this.servletout = new CharArrayWriter();
                this.mappingout = new CharArrayWriter();
            } else {
                this.mapout = null;
                this.servletout = null;
                this.mappingout = null;
            }
            if (this.webxmlLevel >= 20) {
                this.mapout.write(Localizer.getMessage("jspc.webxml.header"));
                this.mapout.flush();
            } else if (this.webxmlLevel >= 10 && !this.addWebXmlMappings) {
                this.mapout.write(Localizer.getMessage("jspc.webinc.header"));
                this.mapout.flush();
            }
        }
        catch (IOException ioe) {
            this.mapout = null;
            this.servletout = null;
            this.mappingout = null;
        }
    }

    private void completeWebXml() {
        if (this.mapout != null) {
            try {
                this.servletout.writeTo(this.mapout);
                this.mappingout.writeTo(this.mapout);
                if (this.webxmlLevel >= 20) {
                    this.mapout.write(Localizer.getMessage("jspc.webxml.footer"));
                } else if (this.webxmlLevel >= 10 && !this.addWebXmlMappings) {
                    this.mapout.write(Localizer.getMessage("jspc.webinc.footer"));
                }
                this.mapout.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void initServletContext() {
        try {
            this.context = new JspCServletContext(new PrintWriter(System.out), new URL("file:" + this.uriRoot.replace('\\', '/') + '/'));
            this.tldLocationsCache = new TldLocationsCache(this.context, true);
        }
        catch (MalformedURLException me) {
            System.out.println("**" + me);
        }
        this.rctxt = new JspRuntimeContext(this.context, this);
        this.jspConfig = new JspConfig(this.context);
        this.tagPluginManager = new TagPluginManager(this.context);
    }

    private void initClassLoader(JspCompilationContext clctxt) throws IOException {
        this.classPath = this.getClassPath();
        ClassLoader jspcLoader = this.getClass().getClassLoader();
        if (jspcLoader instanceof AntClassLoader) {
            this.classPath = this.classPath + File.pathSeparator + ((AntClassLoader)jspcLoader).getClasspath();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(this.classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken();
            try {
                File libFile = new File(path);
                urls.add(libFile.toURL());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
        }
        File webappBase = new File(this.uriRoot);
        if (webappBase.exists()) {
            File classes = new File(webappBase, "/WEB-INF/classes");
            try {
                if (classes.exists()) {
                    this.classPath = this.classPath + File.pathSeparator + classes.getCanonicalPath();
                    urls.add(classes.getCanonicalFile().toURL());
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.toString());
            }
            File lib = new File(webappBase, "/WEB-INF/lib");
            if (lib.exists() && lib.isDirectory()) {
                String[] libs = lib.list();
                for (int i = 0; i < libs.length; ++i) {
                    if (libs[i].length() < 5) continue;
                    String ext = libs[i].substring(libs[i].length() - 4);
                    if (!".jar".equalsIgnoreCase(ext)) {
                        if (!".tld".equalsIgnoreCase(ext)) continue;
                        log.warn((Object)"TLD files should not be placed in /WEB-INF/lib");
                        continue;
                    }
                    try {
                        File libFile = new File(lib, libs[i]);
                        this.classPath = this.classPath + File.pathSeparator + libFile.getCanonicalPath();
                        urls.add(libFile.getCanonicalFile().toURL());
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe.toString());
                    }
                }
            }
        }
        urls.add(new File(clctxt.getRealPath("/")).getCanonicalFile().toURL());
        URL[] urlsA = new URL[urls.size()];
        urls.toArray(urlsA);
        this.loader = new URLClassLoader(urlsA, this.getClass().getClassLoader());
    }

    private void locateUriRoot(File f) {
        String tUriBase = this.uriBase;
        if (tUriBase == null) {
            tUriBase = "/";
        }
        try {
            if (f.exists()) {
                f = new File(f.getCanonicalPath());
                while (f != null) {
                    String fParent;
                    File g = new File(f, "WEB-INF");
                    if (g.exists() && g.isDirectory()) {
                        this.uriRoot = f.getCanonicalPath();
                        this.uriBase = tUriBase;
                        if (!log.isInfoEnabled()) break;
                        log.info((Object)Localizer.getMessage("jspc.implicit.uriRoot", this.uriRoot));
                        break;
                    }
                    if (f.exists() && f.isDirectory()) {
                        tUriBase = "/" + f.getName() + "/" + tUriBase;
                    }
                    if ((fParent = f.getParent()) == null) break;
                    f = new File(fParent);
                }
                if (this.uriRoot != null) {
                    File froot = new File(this.uriRoot);
                    this.uriRoot = froot.getCanonicalPath();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

