/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.ServiceMethodPhase;
import org.apache.jasper.compiler.ServletWriter;

public class CharDataGenerator
extends GeneratorBase
implements ServiceMethodPhase {
    char[] chars;
    private static final int MAXSIZE = 32768;

    public CharDataGenerator(char[] chars) {
        this.chars = chars;
    }

    public void generate(ServletWriter writer, Class phase) {
        writer.indent();
        int current = 0;
        int limit = this.chars.length;
        while (current < limit) {
            int from = current;
            int to = Math.min(current + 32768, limit);
            this.generateChunk(writer, from, to);
            current = to;
            writer.println();
        }
    }

    private void generateChunk(ServletWriter writer, int from, int to) {
        writer.print("out.write(\"");
        StringBuffer sb = new StringBuffer();
        block7: for (int i = from; i < to; ++i) {
            char ch = this.chars[i];
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                default: {
                    this.writeChar(ch, sb);
                }
            }
        }
        writer.print(sb.toString());
        writer.print("\");");
        writer.println();
    }

    protected void writeChar(char c, StringBuffer buf) {
        if (c < '\u0080') {
            buf.append(c);
        } else {
            buf.append("\\u");
            String hexa = Integer.toHexString(c);
            for (int i = hexa.length(); i < 4; ++i) {
                buf.append('0');
            }
            buf.append(hexa);
        }
    }
}

