/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Hashtable;
import java.util.Stack;
import javax.servlet.jsp.tagext.VariableInfo;
import org.apache.jasper.compiler.GeneratorBase;
import org.apache.jasper.compiler.ServletWriter;

abstract class TagGeneratorBase
extends GeneratorBase {
    private Stack tagHandlerStack;
    private Hashtable tagVarNumbers;

    TagGeneratorBase() {
    }

    protected void setTagHandlerStack(Stack tagHandlerStack) {
        this.tagHandlerStack = tagHandlerStack;
    }

    protected void setTagVarNumbers(Hashtable tagVarNumbers) {
        this.tagVarNumbers = tagVarNumbers;
    }

    protected void tagBegin(TagVariableData tvd) {
        this.tagHandlerStack.push(tvd);
    }

    protected TagVariableData tagEnd() {
        return (TagVariableData)this.tagHandlerStack.pop();
    }

    protected TagVariableData topTag() {
        if (this.tagHandlerStack.empty()) {
            return null;
        }
        return (TagVariableData)this.tagHandlerStack.peek();
    }

    private String substitute(String name, char from, String to) {
        StringBuffer s = new StringBuffer();
        int begin = 0;
        int last = name.length();
        while (true) {
            int end;
            if ((end = name.indexOf(from, begin)) < 0) {
                end = last;
            }
            s.append(name.substring(begin, end));
            if (end == last) break;
            s.append(to);
            begin = end + 1;
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getTagVarName(String prefix, String shortTagName) {
        if (prefix.indexOf(45) >= 0) {
            prefix = this.substitute(prefix, '-', "$1");
        }
        if (prefix.indexOf(46) >= 0) {
            prefix = this.substitute(prefix, '.', "$2");
        }
        if (shortTagName.indexOf(45) >= 0) {
            shortTagName = this.substitute(shortTagName, '-', "$1");
        }
        if (shortTagName.indexOf(46) >= 0) {
            shortTagName = this.substitute(shortTagName, '.', "$2");
        }
        if (shortTagName.indexOf(58) >= 0) {
            shortTagName = this.substitute(shortTagName, ':', "$3");
        }
        Hashtable hashtable = this.tagVarNumbers;
        synchronized (hashtable) {
            String tag = prefix + ":" + shortTagName;
            String varName = prefix + "_" + shortTagName + "_";
            if (this.tagVarNumbers.get(tag) != null) {
                Integer i = (Integer)this.tagVarNumbers.get(tag);
                varName = varName + i;
                this.tagVarNumbers.put(tag, new Integer(i + 1));
                return varName;
            }
            this.tagVarNumbers.put(tag, new Integer(1));
            return varName + "0";
        }
    }

    protected void declareVariables(ServletWriter writer, VariableInfo[] vi, boolean declare, boolean update, int scope) {
        if (vi != null) {
            for (int i = 0; i < vi.length; ++i) {
                if (vi[i].getScope() != scope) continue;
                if (vi[i].getDeclare() && declare) {
                    writer.println(vi[i].getClassName() + " " + vi[i].getVarName() + " = null;");
                }
                if (!update) continue;
                writer.println(vi[i].getVarName() + " = (" + vi[i].getClassName() + ") pageContext.findAttribute(" + writer.quoteString(vi[i].getVarName()) + ");");
            }
        }
    }

    class TagVariableData {
        String tagHandlerInstanceName;
        String tagEvalVarName;
        String tagExceptionCheckName;

        TagVariableData(String tagHandlerInstanceName, String tagEvalVarName) {
            this.tagHandlerInstanceName = tagHandlerInstanceName;
            this.tagEvalVarName = tagEvalVarName;
            this.tagExceptionCheckName = tagHandlerInstanceName + "_exceptionCheck";
        }
    }
}

