/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.jasper.Constants;

public class JspWriterImpl
extends JspWriter {
    protected Writer out;
    protected ServletResponse response;
    protected char[] cb;
    protected int nextChar;
    protected static int defaultCharBufferSize = 8192;
    protected boolean flushed = false;
    static String lineSeparator;

    public JspWriterImpl() {
        super(defaultCharBufferSize, true);
    }

    public JspWriterImpl(ServletResponse response) {
        this(response, defaultCharBufferSize, true);
    }

    public JspWriterImpl(ServletResponse response, int sz, boolean autoFlush) {
        super(sz, autoFlush);
        if (sz < 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.response = response;
        this.cb = sz == 0 ? null : new char[sz];
        this.nextChar = 0;
    }

    void init(ServletResponse response, int sz, boolean autoFlush) {
        this.response = response;
        if (sz > 0 && (this.cb == null || sz > this.cb.length)) {
            this.cb = new char[sz];
        }
        this.nextChar = 0;
        this.autoFlush = autoFlush;
        this.bufferSize = sz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bufferSize == 0) {
                return;
            }
            this.flushed = true;
            this.ensureOpen();
            if (this.nextChar == 0) {
                return;
            }
            this.initOut();
            this.out.write(this.cb, 0, this.nextChar);
            this.nextChar = 0;
        }
    }

    protected void initOut() throws IOException {
        if (this.out == null) {
            this.out = this.response.getWriter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bufferSize == 0) {
                throw new IllegalStateException(Constants.getString("jsp.error.ise_on_clear"));
            }
            if (this.flushed) {
                throw new IOException(Constants.getString("jsp.error.attempt_to_clear_flushed_buffer"));
            }
            this.ensureOpen();
            this.nextChar = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.bufferSize == 0) {
                throw new IllegalStateException(Constants.getString("jsp.error.ise_on_clear"));
            }
            this.ensureOpen();
            this.nextChar = 0;
        }
    }

    private final void bufferOverflow() throws IOException {
        throw new IOException(Constants.getString("jsp.error.overflow"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            if (this.out != null) {
                this.out.flush();
                this.response.flushBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.response == null) {
                return;
            }
            this.flush();
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
    }

    public int getRemaining() {
        return this.bufferSize - this.nextChar;
    }

    protected void ensureOpen() throws IOException {
        if (this.response == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.bufferSize == 0) {
                this.initOut();
                this.out.write(c);
            } else {
                if (this.nextChar >= this.bufferSize) {
                    if (this.autoFlush) {
                        this.flushBuffer();
                    } else {
                        this.bufferOverflow();
                    }
                }
                this.cb[this.nextChar++] = (char)c;
            }
        }
    }

    private int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.bufferSize == 0) {
                this.initOut();
                this.out.write(cbuf, off, len);
                return;
            }
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (len >= this.bufferSize) {
                if (this.autoFlush) {
                    this.flushBuffer();
                } else {
                    this.bufferOverflow();
                }
                this.initOut();
                this.out.write(cbuf, off, len);
                return;
            }
            int b = off;
            int t = off + len;
            while (b < t) {
                int d = this.min(this.bufferSize - this.nextChar, t - b);
                System.arraycopy(cbuf, b, this.cb, this.nextChar, d);
                b += d;
                this.nextChar += d;
                if (this.nextChar < this.bufferSize) continue;
                if (this.autoFlush) {
                    this.flushBuffer();
                    continue;
                }
                this.bufferOverflow();
            }
        }
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.bufferSize == 0) {
                this.initOut();
                this.out.write(s, off, len);
                return;
            }
            int b = off;
            int t = off + len;
            while (b < t) {
                int d = this.min(this.bufferSize - this.nextChar, t - b);
                s.getChars(b, b + d, this.cb, this.nextChar);
                b += d;
                this.nextChar += d;
                if (this.nextChar < this.bufferSize) continue;
                if (this.autoFlush) {
                    this.flushBuffer();
                    continue;
                }
                this.bufferOverflow();
            }
        }
    }

    public void write(String s) throws IOException {
        this.write(s, 0, s.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.write(lineSeparator);
        }
    }

    public void print(boolean b) throws IOException {
        this.write(b ? "true" : "false");
    }

    public void print(char c) throws IOException {
        this.write(String.valueOf(c));
    }

    public void print(int i) throws IOException {
        this.write(String.valueOf(i));
    }

    public void print(long l) throws IOException {
        this.write(String.valueOf(l));
    }

    public void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) throws IOException {
        this.write(s);
    }

    public void print(String s) throws IOException {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object obj) throws IOException {
        this.write(String.valueOf(obj));
    }

    public void println() throws IOException {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object x) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    void recycle() {
        this.flushed = false;
        this.nextChar = 0;
    }

    static {
        try {
            lineSeparator = System.getProperty("line.separator");
        }
        catch (RuntimeException ex) {
            lineSeparator = "\r\n";
        }
    }
}

