/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.util.ArrayList;
import org.apache.coyote.RequestInfo;

public class RequestGroupInfo {
    ArrayList processors = new ArrayList();

    public synchronized void addRequestProcessor(RequestInfo rp) {
        this.processors.add(rp);
    }

    public synchronized void removeRequestProcessor(RequestInfo rp) {
        this.processors.remove(rp);
    }

    public synchronized long getMaxTime() {
        long maxTime = 0L;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            if (maxTime >= rp.getMaxTime()) continue;
            maxTime = rp.getMaxTime();
        }
        return maxTime;
    }

    public synchronized void setMaxTime(long maxTime) {
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            rp.setMaxTime(maxTime);
        }
    }

    public synchronized long getProcessingTime() {
        long time = 0L;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            time += rp.getProcessingTime();
        }
        return time;
    }

    public synchronized void setProcessingTime(long totalTime) {
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            rp.setProcessingTime(totalTime);
        }
    }

    public synchronized int getRequestCount() {
        int requestCount = 0;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            requestCount += rp.getRequestCount();
        }
        return requestCount;
    }

    public synchronized void setRequestCount(int requestCount) {
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            rp.setRequestCount(requestCount);
        }
    }

    public synchronized int getErrorCount() {
        int requestCount = 0;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            requestCount += rp.getErrorCount();
        }
        return requestCount;
    }

    public synchronized void setErrorCount(int errorCount) {
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            rp.setErrorCount(errorCount);
        }
    }

    public synchronized long getBytesReceived() {
        long bytes = 0L;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            bytes += rp.getBytesReceived();
        }
        return bytes;
    }

    public synchronized void setBytesReceived(long bytesReceived) {
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            rp.setBytesReceived(bytesReceived);
        }
    }

    public synchronized long getBytesSent() {
        long bytes = 0L;
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            bytes += rp.getBytesSent();
        }
        return bytes;
    }

    public synchronized void setBytesSent(long bytesSent) {
        for (int i = 0; i < this.processors.size(); ++i) {
            RequestInfo rp = (RequestInfo)this.processors.get(i);
            rp.setBytesSent(bytesSent);
        }
    }

    public void resetCounters() {
        this.setBytesReceived(0L);
        this.setBytesSent(0L);
        this.setRequestCount(0);
        this.setProcessingTime(0L);
        this.setMaxTime(0L);
        this.setErrorCount(0);
    }
}

