/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.http.ContentType;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.Parameters;

public final class Request {
    private int serverPort = -1;
    private MessageBytes serverNameMB = new MessageBytes();
    private String localHost;
    private MessageBytes schemeMB = new MessageBytes();
    private MessageBytes methodMB = new MessageBytes();
    private MessageBytes unparsedURIMB = new MessageBytes();
    private MessageBytes uriMB = new MessageBytes();
    private MessageBytes decodedUriMB = new MessageBytes();
    private MessageBytes queryMB = new MessageBytes();
    private MessageBytes protoMB = new MessageBytes();
    private MessageBytes remoteAddrMB = new MessageBytes();
    private MessageBytes remoteHostMB = new MessageBytes();
    private MimeHeaders headers = new MimeHeaders();
    private MessageBytes instanceId = new MessageBytes();
    private Object[] notes = new Object[32];
    private InputBuffer inputBuffer = null;
    private UDecoder urlDecoder = new UDecoder();
    private int contentLength = -1;
    private int available = -1;
    private MessageBytes contentTypeMB = null;
    private String charEncoding = null;
    private Cookies cookies = new Cookies(this.headers);
    private Parameters parameters = new Parameters();
    private MessageBytes remoteUser = new MessageBytes();
    private MessageBytes authType = new MessageBytes();
    private Hashtable attributes = new Hashtable();
    private Response response;
    private ActionHook hook;

    public Request() {
        this.recycle();
        this.parameters.setQuery(this.queryMB);
        this.parameters.setURLDecoder(this.urlDecoder);
        this.parameters.setHeaders(this.headers);
    }

    public void action(ActionCode actionCode, Object param) {
        if (this.hook == null && this.response != null) {
            this.hook = this.response.getHook();
        }
        if (this.hook != null) {
            if (param == null) {
                this.hook.action(actionCode, this);
            } else {
                this.hook.action(actionCode, param);
            }
        }
    }

    public MessageBytes contentType() {
        if (this.contentTypeMB == null) {
            this.contentTypeMB = this.headers.getValue("content-type");
        }
        return this.contentTypeMB;
    }

    public MessageBytes decodedURI() {
        return this.decodedUriMB;
    }

    public int doRead(ByteChunk chunk) throws IOException {
        int n = this.inputBuffer.doRead(chunk, this);
        if (n > 0) {
            this.available -= n;
        }
        return n;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }

    public MessageBytes getAuthType() {
        return this.authType;
    }

    public String getCharacterEncoding() {
        if (this.charEncoding != null) {
            return this.charEncoding;
        }
        this.charEncoding = ContentType.getCharsetFromContentType((String)this.getContentType());
        return this.charEncoding;
    }

    public int getContentLength() {
        if (this.contentLength > -1) {
            return this.contentLength;
        }
        MessageBytes clB = this.headers.getValue("content-length");
        this.available = this.contentLength = clB == null || clB.isNull() ? -1 : clB.getInt();
        return this.contentLength;
    }

    public String getContentType() {
        this.contentType();
        if (this.contentTypeMB == null || this.contentTypeMB.isNull()) {
            return null;
        }
        return this.contentTypeMB.toString();
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public final Object getNote(int pos) {
        return this.notes[pos];
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public MessageBytes getRemoteUser() {
        return this.remoteUser;
    }

    public Response getResponse() {
        return this.response;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public UDecoder getURLDecoder() {
        return this.urlDecoder;
    }

    public MessageBytes instanceId() {
        return this.instanceId;
    }

    public MessageBytes method() {
        return this.methodMB;
    }

    public MessageBytes protocol() {
        return this.protoMB;
    }

    public MessageBytes query() {
        return this.queryMB;
    }

    public MessageBytes queryString() {
        return this.queryMB;
    }

    public void recycle() {
        this.contentLength = -1;
        this.contentTypeMB = null;
        this.charEncoding = null;
        this.headers.recycle();
        this.serverNameMB.recycle();
        this.serverPort = -1;
        this.cookies.recycle();
        this.parameters.recycle();
        this.unparsedURIMB.recycle();
        this.uriMB.recycle();
        this.decodedUriMB.recycle();
        this.queryMB.recycle();
        this.methodMB.recycle();
        this.protoMB.recycle();
        this.schemeMB.setString("http");
        this.methodMB.setString("GET");
        this.uriMB.setString("/");
        this.queryMB.setString("");
        this.protoMB.setString("HTTP/1.0");
        this.instanceId.recycle();
        this.remoteUser.recycle();
        this.authType.recycle();
        this.attributes.clear();
    }

    public MessageBytes remoteAddr() {
        return this.remoteAddrMB;
    }

    public MessageBytes remoteHost() {
        return this.remoteHostMB;
    }

    public MessageBytes requestURI() {
        return this.uriMB;
    }

    public MessageBytes scheme() {
        return this.schemeMB;
    }

    public MessageBytes serverName() {
        return this.serverNameMB;
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void setCharacterEncoding(String enc) {
        this.charEncoding = enc;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
        this.available = len;
    }

    public void setContentType(String type) {
        this.contentTypeMB.setString(type);
    }

    public void setContentType(MessageBytes mb) {
        this.contentTypeMB = mb;
    }

    public void setInputBuffer(InputBuffer inputBuffer) {
        this.inputBuffer = inputBuffer;
    }

    public void setLocalHost(String host) {
        this.localHost = host;
    }

    public final void setNote(int pos, Object value) {
        this.notes[pos] = value;
    }

    public void setResponse(Response response) {
        this.response = response;
        response.setRequest(this);
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String toString() {
        return "R( " + this.requestURI().toString() + ")";
    }

    public MessageBytes unparsedURI() {
        return this.unparsedURIMB;
    }
}

