/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.util.Locale;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Constants;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.http.ContentType;
import org.apache.tomcat.util.http.MimeHeaders;

public final class Response {
    protected int status = 200;
    protected String message = null;
    protected MimeHeaders headers = new MimeHeaders();
    protected OutputBuffer outputBuffer;
    protected Object[] notes = new Object[32];
    protected boolean commited = false;
    public ActionHook hook;
    protected String contentType = "text/plain";
    protected String contentLanguage = null;
    protected String characterEncoding = "ISO-8859-1";
    protected int contentLength = -1;
    private Locale locale = Constants.DEFAULT_LOCALE;
    protected Exception errorException = null;
    protected String errorURI = null;
    protected Request req;

    public void acknowledge() throws IOException {
        this.action(ActionCode.ACTION_ACK, this);
    }

    public void action(ActionCode actionCode, Object param) {
        if (this.hook != null) {
            if (param == null) {
                this.hook.action(actionCode, this);
            } else {
                this.hook.action(actionCode, param);
            }
        }
    }

    public void addHeader(String name, String value) {
        char cc = name.charAt(0);
        if ((cc == 'C' || cc == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        this.headers.addValue(name).setString(value);
    }

    private boolean checkSpecialHeader(String name, String value) {
        if (name.equalsIgnoreCase("Content-Type")) {
            this.setContentType(value);
            return true;
        }
        if (name.equalsIgnoreCase("Content-Length")) {
            try {
                int cL = Integer.parseInt(value);
                this.setContentLength(cL);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        name.equalsIgnoreCase("Content-Language");
        return false;
    }

    public boolean containsHeader(String name) {
        return this.headers.getHeader(name) != null;
    }

    public void doWrite(ByteChunk chunk) throws IOException {
        this.outputBuffer.doWrite(chunk, this);
    }

    public void finish() throws IOException {
        this.action(ActionCode.ACTION_CLOSE, this);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public String getErrorURI() {
        return this.errorURI;
    }

    public ActionHook getHook() {
        return this.hook;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getMessage() {
        return this.message;
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public final Object getNote(int pos) {
        return this.notes[pos];
    }

    public OutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    public Request getRequest() {
        return this.req;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isCommitted() {
        return this.commited;
    }

    public boolean isExceptionPresent() {
        return this.errorException != null;
    }

    public void recycle() {
        this.contentType = "text/plain";
        this.contentLanguage = null;
        this.locale = Constants.DEFAULT_LOCALE;
        this.characterEncoding = "ISO-8859-1";
        this.contentLength = -1;
        this.status = 200;
        this.message = null;
        this.commited = false;
        this.errorException = null;
        this.errorURI = null;
        this.headers.clear();
    }

    public void reset() throws IllegalStateException {
        this.contentType = "text/plain";
        this.locale = Constants.DEFAULT_LOCALE;
        this.characterEncoding = "ISO-8859-1";
        this.contentLength = -1;
        this.status = 200;
        this.message = null;
        this.headers.clear();
        if (this.commited) {
            throw new IllegalStateException();
        }
        this.action(ActionCode.ACTION_RESET, this);
    }

    public void sendHeaders() throws IOException {
        this.action(ActionCode.ACTION_COMMIT, this);
        this.commited = true;
    }

    public void setCommitted(boolean v) {
        this.commited = v;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
        this.headers.setValue("Content-Length").setInt(contentLength);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        String encoding = ContentType.getCharsetFromContentType((String)contentType);
        if (encoding != null) {
            this.characterEncoding = encoding;
        }
        this.headers.setValue("Content-Type").setString(contentType);
    }

    public void setErrorException(Exception ex) {
        this.errorException = ex;
    }

    public void setErrorURI(String uri) {
        this.errorURI = uri;
    }

    public void setHeader(String name, String value) {
        char cc = name.charAt(0);
        if ((cc == 'C' || cc == 'c') && this.checkSpecialHeader(name, value)) {
            return;
        }
        this.headers.setValue(name).setString(value);
    }

    public void setHook(ActionHook hook) {
        this.hook = hook;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            return;
        }
        this.locale = locale;
        this.contentLanguage = locale.getLanguage();
        if (this.contentLanguage != null && this.contentLanguage.length() > 0) {
            String country = locale.getCountry();
            StringBuffer value = new StringBuffer(this.contentLanguage);
            if (country != null && country.length() > 0) {
                value.append('-');
                value.append(country);
            }
            this.headers.setValue("Content-Language").setString(value.toString());
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public final void setNote(int pos, Object value) {
        this.notes[pos] = value;
    }

    public void setOutputBuffer(OutputBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    public void setRequest(Request req) {
        this.req = req;
    }

    public void setStatus(int status) {
        this.status = status;
    }
}

