/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat4;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Connector;
import org.apache.catalina.Context;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Request;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.Response;
import org.apache.coyote.tomcat4.CoyoteOutputStream;
import org.apache.coyote.tomcat4.CoyoteRequest;
import org.apache.coyote.tomcat4.CoyoteResponseFacade;
import org.apache.coyote.tomcat4.CoyoteWriter;
import org.apache.coyote.tomcat4.OutputBuffer;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.UEncoder;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ServerCookie;

public class CoyoteResponse
implements HttpResponse,
HttpServletResponse {
    protected final SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected static final String info = "org.apache.coyote.tomcat4.CoyoteResponse/1.0";
    protected static StringManager sm;
    protected Connector connector;
    protected Response coyoteResponse;
    protected Context context = null;
    protected OutputBuffer outputBuffer = new OutputBuffer();
    protected CoyoteOutputStream outputStream = new CoyoteOutputStream(this.outputBuffer);
    protected CoyoteWriter writer = new CoyoteWriter(this.outputBuffer);
    protected boolean appCommitted = false;
    protected boolean included = false;
    protected boolean error = false;
    protected ArrayList cookies = new ArrayList();
    protected boolean usingOutputStream = false;
    protected boolean usingWriter = false;
    protected UEncoder urlEncoder = new UEncoder();
    protected CharChunk redirectURLCC = new CharChunk();
    protected CoyoteRequest request = null;
    protected CoyoteResponseFacade facade = null;

    public CoyoteResponse() {
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.urlEncoder.addSafeCharacter('/');
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public void setCoyoteResponse(Response coyoteResponse) {
        this.coyoteResponse = coyoteResponse;
        this.outputBuffer.setResponse(coyoteResponse);
    }

    public Response getCoyoteResponse() {
        return this.coyoteResponse;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void recycle() {
        this.outputBuffer.recycle();
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.appCommitted = false;
        this.included = false;
        this.error = false;
        this.cookies.clear();
        if (this.facade != null) {
            this.facade.clear();
            this.facade = null;
        }
    }

    public int getContentCount() {
        return this.outputBuffer.getBytesWritten();
    }

    public void setAppCommitted(boolean appCommitted) {
        this.appCommitted = appCommitted;
    }

    public boolean isAppCommitted() {
        return this.appCommitted || this.isCommitted();
    }

    public boolean getIncluded() {
        return this.included;
    }

    public void setIncluded(boolean included) {
        this.included = included;
    }

    public String getInfo() {
        return info;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = (CoyoteRequest)request;
    }

    public ServletResponse getResponse() {
        if (this.facade == null) {
            this.facade = new CoyoteResponseFacade(this);
        }
        return this.facade;
    }

    public OutputStream getStream() {
        return this.outputStream;
    }

    public void setStream(OutputStream stream) {
    }

    public void setSuspended(boolean suspended) {
        this.outputBuffer.setSuspended(suspended);
    }

    public boolean isSuspended() {
        return this.outputBuffer.isSuspended();
    }

    public void setError() {
        this.error = true;
    }

    public boolean isError() {
        return this.error;
    }

    public ServletOutputStream createOutputStream() throws IOException {
        return this.outputStream;
    }

    public void finishResponse() throws IOException {
        try {
            this.outputBuffer.close();
        }
        catch (IOException e) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.coyoteResponse.finish();
    }

    public int getContentLength() {
        return this.coyoteResponse.getContentLength();
    }

    public String getContentType() {
        return this.coyoteResponse.getContentType();
    }

    public PrintWriter getReporter() {
        if (this.outputBuffer.isNew()) {
            return this.writer;
        }
        return null;
    }

    public void flushBuffer() throws IOException {
        this.outputBuffer.flush();
    }

    public int getBufferSize() {
        return this.outputBuffer.getBufferSize();
    }

    public String getCharacterEncoding() {
        return this.coyoteResponse.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.usingWriter) {
            throw new IllegalStateException(sm.getString("coyoteResponse.getOutputStream.ise"));
        }
        this.usingOutputStream = true;
        return this.outputStream;
    }

    public Locale getLocale() {
        return this.coyoteResponse.getLocale();
    }

    public PrintWriter getWriter() throws IOException {
        if (this.usingOutputStream) {
            throw new IllegalStateException(sm.getString("coyoteResponse.getWriter.ise"));
        }
        this.usingWriter = true;
        return this.writer;
    }

    public boolean isCommitted() {
        return this.coyoteResponse.isCommitted();
    }

    public void reset() {
        if (this.included) {
            return;
        }
        this.coyoteResponse.reset();
        this.outputBuffer.reset();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.resetBuffer.ise"));
        }
        this.outputBuffer.reset();
    }

    public void setBufferSize(int size) {
        if (this.isCommitted() || !this.outputBuffer.isNew()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.setBufferSize.ise"));
        }
        this.outputBuffer.setBufferSize(size);
    }

    public void setContentLength(int length) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.setContentLength(length);
    }

    public void setContentType(String type) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.setContentType(type);
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.setLocale(locale);
    }

    public Cookie[] getCookies() {
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public String getHeader(String name) {
        return this.coyoteResponse.getMimeHeaders().getHeader(name);
    }

    public String[] getHeaderNames() {
        MimeHeaders headers = this.coyoteResponse.getMimeHeaders();
        int n = headers.size();
        String[] result = new String[n];
        int i = 0;
        while (i < n) {
            result[i] = headers.getName(i).toString();
            ++i;
        }
        return result;
    }

    public String[] getHeaderValues(String name) {
        MimeHeaders headers = this.coyoteResponse.getMimeHeaders();
        int n = headers.size();
        String[] result = new String[n];
        int i = 0;
        while (i < n) {
            result[i] = headers.getValue(i).toString();
            ++i;
        }
        return result;
    }

    public String getMessage() {
        return this.coyoteResponse.getMessage();
    }

    public int getStatus() {
        return this.coyoteResponse.getStatus();
    }

    public void reset(int status, String message) {
        this.reset();
        this.setStatus(status, message);
    }

    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.cookies.add(cookie);
        StringBuffer sb = new StringBuffer();
        ServerCookie.appendCookieValue((StringBuffer)sb, (int)cookie.getVersion(), (String)cookie.getName(), (String)cookie.getValue(), (String)cookie.getPath(), (String)cookie.getDomain(), (String)cookie.getComment(), (int)cookie.getMaxAge(), (boolean)cookie.getSecure());
        this.addHeader("Set-Cookie", sb.toString());
    }

    public void addDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(name, this.format.format(new Date(value)));
    }

    public void addHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.addHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.addHeader(name, "" + value);
    }

    public boolean containsHeader(String name) {
        return this.coyoteResponse.containsHeader(name);
    }

    public String encodeRedirectURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            HttpServletRequest hreq = (HttpServletRequest)this.request.getRequest();
            return this.toEncoded(url, hreq.getSession().getId());
        }
        return url;
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url))) {
            HttpServletRequest hreq = (HttpServletRequest)this.request.getRequest();
            return this.toEncoded(url, hreq.getSession().getId());
        }
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public void sendAcknowledgement() throws IOException {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.acknowledge();
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.sendError.ise"));
        }
        if (this.included) {
            return;
        }
        this.setError();
        this.coyoteResponse.setStatus(status);
        this.coyoteResponse.setMessage(message);
        this.resetBuffer();
        this.setSuspended(true);
    }

    public void sendRedirect(String location) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException(sm.getString("coyoteResponse.sendRedirect.ise"));
        }
        if (this.included) {
            return;
        }
        this.resetBuffer();
        try {
            String absolute = this.toAbsolute(location);
            this.setStatus(302);
            this.setHeader("Location", absolute);
        }
        catch (IllegalArgumentException e) {
            this.setStatus(404);
        }
        this.setSuspended(true);
    }

    public void setDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(name, this.format.format(new Date(value)));
    }

    public void setHeader(String name, String value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.setHeader(name, "" + value);
    }

    public void setStatus(int status) {
        this.setStatus(status, null);
    }

    public void setStatus(int status, String message) {
        if (this.isCommitted()) {
            return;
        }
        if (this.included) {
            return;
        }
        this.coyoteResponse.setStatus(status);
        this.coyoteResponse.setMessage(message);
    }

    protected boolean isEncodeable(String location) {
        int urlPort;
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        HttpServletRequest hreq = (HttpServletRequest)this.request.getRequest();
        HttpSession session = hreq.getSession(false);
        if (session == null) {
            return false;
        }
        if (hreq.isRequestedSessionIdFromCookie()) {
            return false;
        }
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!hreq.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!hreq.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = hreq.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(hreq.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        String contextPath = this.getContext().getPath();
        if (contextPath != null && contextPath.length() > 0) {
            String file = url.getFile();
            if (file == null || !file.startsWith(contextPath)) {
                return false;
            }
            if (file.indexOf(";jsessionid=" + session.getId()) >= 0) {
                return false;
            }
        }
        return true;
    }

    private String toAbsolute(String location) {
        if (location == null) {
            return location;
        }
        boolean leadingSlash = location.startsWith("/");
        if (leadingSlash || !leadingSlash && location.indexOf("://") == -1) {
            this.redirectURLCC.recycle();
            String scheme = this.request.getScheme();
            String name = this.request.getServerName();
            int port = this.request.getServerPort();
            try {
                this.redirectURLCC.append(scheme, 0, scheme.length());
                this.redirectURLCC.append("://", 0, 3);
                this.redirectURLCC.append(name, 0, name.length());
                if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                    this.redirectURLCC.append(':');
                    String portS = port + "";
                    this.redirectURLCC.append(portS, 0, portS.length());
                }
                if (!leadingSlash) {
                    String relativePath = this.request.getDecodedRequestURI();
                    int pos = relativePath.lastIndexOf(47);
                    relativePath = relativePath.substring(0, pos);
                    String encodedURI = this.urlEncoder.encodeURL(relativePath);
                    this.redirectURLCC.append(encodedURI, 0, encodedURI.length());
                    this.redirectURLCC.append('/');
                }
                this.redirectURLCC.append(location, 0, location.length());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(location);
            }
            return this.redirectURLCC.toString();
        }
        return location;
    }

    private String toEncoded(String url, String sessionId) {
        StringBuffer sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuffer(path)).length() > 0) {
            sb.append(";jsessionid=");
            sb.append(sessionId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    static {
        info = info;
        sm = StringManager.getManager((String)"org.apache.coyote.tomcat4");
    }
}

