/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.modeler.Registry;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.http11.Http11BaseProtocol;
import org.apache.coyote.http11.Http11Processor;
import org.apache.tomcat.util.threads.ThreadPool;
import org.apache.tomcat.util.threads.ThreadWithAttributes;

public class Http11Protocol
extends Http11BaseProtocol
implements MBeanRegistration {
    ObjectName tpOname;
    ObjectName rgOname;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    public void start() throws Exception {
        if (this.domain != null) {
            try {
                this.tpOname = new ObjectName(this.domain + ":" + "type=ThreadPool,name=" + this.getName());
                if ("ms".equals(this.getStrategy())) {
                    Registry.getRegistry(null, null).registerComponent((Object)this.ep, this.tpOname, null);
                } else {
                    Registry.getRegistry(null, null).registerComponent((Object)this.tp, this.tpOname, null);
                }
                this.tp.setName(this.getName());
                this.tp.setDaemon(false);
                this.tp.addThreadPoolListener((ThreadPool.ThreadPoolListener)new MXPoolListener(this, this.tp));
            }
            catch (Exception e) {
                log.error((Object)"Can't register threadpool");
            }
            this.rgOname = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this.cHandler.global, this.rgOname, null);
        }
        super.start();
    }

    public void destroy() throws Exception {
        super.destroy();
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    static class JmxHttp11ConnectionHandler
    extends Http11BaseProtocol.Http11ConnectionHandler {
        Http11Protocol proto;
        static int count = 0;
        RequestGroupInfo global = new RequestGroupInfo();

        JmxHttp11ConnectionHandler(Http11Protocol proto) {
            super(proto);
        }

        public void setAttribute(String name, Object value) {
        }

        public void setServer(Object o) {
        }

        public Object[] init() {
            Object[] thData = super.init();
            Http11Processor processor = (Http11Processor)thData[1];
            if (this.proto.getDomain() != null) {
                try {
                    RequestInfo rp = processor.getRequest().getRequestProcessor();
                    rp.setGlobalProcessor(this.global);
                    ObjectName rpName = new ObjectName(this.proto.getDomain() + ":type=RequestProcessor,worker=" + this.proto.getName() + ",name=HttpRequest" + count++);
                    Registry.getRegistry(null, null).registerComponent((Object)rp, rpName, null);
                    thData[2] = rpName;
                }
                catch (Exception ex) {
                    Http11BaseProtocol.log.warn((Object)"Error registering request");
                }
            }
            return thData;
        }
    }

    static class MXPoolListener
    implements ThreadPool.ThreadPoolListener {
        MXPoolListener(Http11Protocol proto, ThreadPool control) {
        }

        public void threadStart(ThreadPool tp, Thread t) {
        }

        public void threadEnd(ThreadPool tp, Thread t) {
            ObjectName oname;
            ThreadWithAttributes ta = (ThreadWithAttributes)t;
            Object[] tpData = ta.getThreadData((Object)tp);
            if (tpData == null) {
                return;
            }
            if (tpData[1] instanceof Object[]) {
                tpData = (Object[])tpData[1];
            }
            if ((oname = (ObjectName)tpData[2]) == null) {
                return;
            }
            Registry.getRegistry(null, null).unregisterComponent(oname);
            Http11Processor processor = (Http11Processor)tpData[1];
            RequestInfo rp = processor.getRequest().getRequestProcessor();
            rp.setGlobalProcessor(null);
        }
    }
}

