/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.jk.common.JkInputStream;
import org.apache.jk.common.MsgAjp;
import org.apache.jk.core.JkHandler;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;
import org.apache.jk.server.JkMain;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.C2BConverter;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;

public class JkCoyoteHandler
extends JkHandler
implements ProtocolHandler,
ActionHook,
OutputBuffer,
InputBuffer {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$jk$server$JkCoyoteHandler == null ? (class$org$apache$jk$server$JkCoyoteHandler = JkCoyoteHandler.class$("org.apache.jk.server.JkCoyoteHandler")) : class$org$apache$jk$server$JkCoyoteHandler));
    private static Log logTime = LogFactory.getLog((String)"org.apache.jk.REQ_TIME");
    int headersMsgNote;
    int c2bConvertersNote;
    int tmpMessageBytesNote;
    int utfC2bNote;
    int obNote;
    int epNote;
    int inputStreamNote;
    Adapter adapter;
    protected JkMain jkMain = null;
    public final int JK_STATUS_NEW = 0;
    public final int JK_STATUS_HEAD = 1;
    public final int JK_STATUS_CLOSED = 2;
    boolean started = false;
    static /* synthetic */ Class class$org$apache$jk$server$JkCoyoteHandler;

    public void setProperty(String name, String value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("setProperty " + name + " " + value));
        }
        this.getJkMain().setProperty(name, value);
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public void setAttribute(String name, Object value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setAttribute " + name + " " + value));
        }
        if (value instanceof String) {
            this.setProperty(name, (String)value);
        }
    }

    public Object getAttribute(String name) {
        return this.getJkMain().getProperty(name);
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public JkMain getJkMain() {
        if (this.jkMain == null) {
            this.jkMain = new JkMain();
            this.jkMain.setWorkerEnv(this.wEnv);
            if (this.oname != null) {
                try {
                    Registry.getRegistry().registerComponent((Object)this.jkMain, this.oname.getDomain(), "JkMain", "type=JkMain");
                }
                catch (Exception e) {
                    log.error((Object)("Error registering jkmain " + e));
                }
            }
        }
        return this.jkMain;
    }

    public void init() {
        if (this.started) {
            return;
        }
        this.started = true;
        if (this.wEnv == null) {
            this.wEnv = this.getJkMain().getWorkerEnv();
            this.wEnv.addHandler("container", this);
        }
        try {
            this.getJkMain().init();
            this.headersMsgNote = this.wEnv.getNoteId(0, "headerMsg");
            this.tmpMessageBytesNote = this.wEnv.getNoteId(0, "tmpMessageBytes");
            this.utfC2bNote = this.wEnv.getNoteId(0, "utfC2B");
            this.epNote = this.wEnv.getNoteId(0, "ep");
            this.obNote = this.wEnv.getNoteId(0, "coyoteBuffer");
            this.inputStreamNote = this.wEnv.getNoteId(0, "jkInputStream");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void start() {
        try {
            this.getJkMain().start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void destroy() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.getJkMain().stop();
    }

    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (!res.isCommitted()) {
            res.sendHeaders();
        }
        MsgContext ep = (MsgContext)res.getNote(this.epNote);
        MsgAjp msg = (MsgAjp)ep.getNote(this.headersMsgNote);
        int len = chunk.getLength();
        byte[] buf = msg.getBuffer();
        int chunkSize = buf.length - msg.getHeaderLength() - 4;
        int off = 0;
        while (len > 0) {
            int thisTime = len;
            if (thisTime > chunkSize) {
                thisTime = chunkSize;
            }
            len -= thisTime;
            msg.reset();
            msg.appendByte(3);
            if (log.isDebugEnabled()) {
                log.debug((Object)("doWrite " + off + " " + thisTime + " " + len));
            }
            msg.appendBytes(chunk.getBytes(), chunk.getOffset() + off, thisTime);
            off += thisTime;
            ep.setType(11);
            ep.getSource().invoke(msg, ep);
        }
        return 0;
    }

    public int doRead(ByteChunk chunk, Request req) throws IOException {
        Response res = req.getResponse();
        if (log.isDebugEnabled()) {
            log.debug((Object)("doRead " + chunk.getBytes() + " " + chunk.getOffset() + " " + chunk.getLength()));
        }
        MsgContext ep = (MsgContext)res.getNote(this.epNote);
        JkInputStream jkIS = (JkInputStream)ep.getNote(this.inputStreamNote);
        return jkIS.doRead(chunk);
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        if (logTime.isDebugEnabled()) {
            ep.setLong(1, System.currentTimeMillis());
        }
        Request req = (Request)ep.getRequest();
        Response res = req.getResponse();
        res.setHook((ActionHook)this);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Invoke " + req + " " + res + " " + req.requestURI().toString()));
        }
        res.setOutputBuffer((OutputBuffer)this);
        req.setInputBuffer((InputBuffer)this);
        if (ep.getNote(this.headersMsgNote) == null) {
            MsgAjp msg2 = new MsgAjp();
            ep.setNote(this.headersMsgNote, msg2);
        }
        res.setNote(this.epNote, (Object)ep);
        ep.setStatus(1);
        try {
            this.adapter.service(req, res);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (ep.getStatus() != 2) {
            res.finish();
        }
        ep.setStatus(0);
        req.recycle();
        req.updateCounters();
        res.recycle();
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private void appendHead(Response res) throws IOException {
        if (JkCoyoteHandler.log.isDebugEnabled()) {
            JkCoyoteHandler.log.debug((Object)("COMMIT sending headers " + res + " " + res.getMimeHeaders()));
        }
        if ((c2b = (C2BConverter)res.getNote(this.utfC2bNote)) == null) {
            if (System.getSecurityManager() != null) {
                try {
                    c2b = (C2BConverter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return new C2BConverter("UTF8");
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    ex = pae.getException();
                    if (!(ex instanceof IOException)) ** GOTO lbl13
                    throw (IOException)ex;
                }
            } else {
                c2b = new C2BConverter("UTF8");
            }
lbl13:
            // 3 sources

            res.setNote(this.utfC2bNote, (Object)c2b);
        }
        ep = (MsgContext)res.getNote(this.epNote);
        msg = (MsgAjp)ep.getNote(this.headersMsgNote);
        msg.reset();
        msg.appendByte(4);
        msg.appendInt(res.getStatus());
        mb = (MessageBytes)ep.getNote(this.tmpMessageBytesNote);
        if (mb == null) {
            mb = new MessageBytes();
            ep.setNote(this.tmpMessageBytesNote, mb);
        }
        message = (message = res.getMessage()) == null ? (System.getSecurityManager() != null ? (String)AccessController.doPrivileged(new StatusLinePrivilegedAction(res.getStatus())) : HttpMessages.getMessage((int)res.getStatus())) : message.replace('\n', ' ').replace('\r', ' ');
        mb.setString(message);
        c2b.convert(mb);
        msg.appendBytes(mb);
        headers = res.getMimeHeaders();
        contentType = res.getContentType();
        if (contentType != null) {
            headers.setValue("Content-Type").setString(contentType);
        }
        if ((contentLanguage = res.getContentLanguage()) != null) {
            headers.setValue("Content-Language").setString(contentLanguage);
        }
        if ((contentLength = res.getContentLength()) >= 0) {
            headers.setValue("Content-Length").setInt(contentLength);
        }
        numHeaders = headers.size();
        msg.appendInt(numHeaders);
        for (i = 0; i < numHeaders; ++i) {
            hN = headers.getName(i);
            c2b.convert(hN);
            msg.appendBytes(hN);
            hV = headers.getValue(i);
            c2b.convert(hV);
            msg.appendBytes(hV);
        }
        ep.setType(11);
        ep.getSource().invoke(msg, ep);
    }

    public void action(ActionCode actionCode, Object param) {
        block24: {
            try {
                if (actionCode == ActionCode.ACTION_COMMIT) {
                    Response res;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"COMMIT ");
                    }
                    if ((res = (Response)param).isCommitted()) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Response already commited ");
                        }
                    } else {
                        this.appendHead(res);
                    }
                    break block24;
                }
                if (actionCode == ActionCode.ACTION_RESET) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"RESET ");
                    }
                    break block24;
                }
                if (actionCode == ActionCode.ACTION_CLIENT_FLUSH) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"CLIENT_FLUSH ");
                    }
                    Response res = (Response)param;
                    MsgContext ep = (MsgContext)res.getNote(this.epNote);
                    ep.setType(12);
                    ep.getSource().invoke(null, ep);
                    break block24;
                }
                if (actionCode == ActionCode.ACTION_CLOSE) {
                    Response res;
                    MsgContext ep;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"CLOSE ");
                    }
                    if ((ep = (MsgContext)(res = (Response)param).getNote(this.epNote)).getStatus() == 2) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Double CLOSE - forward ? " + res.getRequest().requestURI()));
                        }
                        return;
                    }
                    if (!res.isCommitted()) {
                        this.action(ActionCode.ACTION_COMMIT, param);
                    }
                    MsgAjp msg = (MsgAjp)ep.getNote(this.headersMsgNote);
                    msg.reset();
                    msg.appendByte(5);
                    msg.appendByte(1);
                    ep.setType(11);
                    ep.getSource().invoke(msg, ep);
                    ep.setType(12);
                    ep.getSource().invoke(msg, ep);
                    ep.setStatus(2);
                    if (logTime.isDebugEnabled()) {
                        this.logTime(res.getRequest(), res);
                    }
                    break block24;
                }
                if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
                    Request req = (Request)param;
                    MessageBytes certString = (MessageBytes)req.getNote(16);
                    if (certString == null || certString.isNull()) break block24;
                    ByteChunk certData = certString.getByteChunk();
                    ByteArrayInputStream bais = new ByteArrayInputStream(certData.getBytes(), certData.getStart(), certData.getLength());
                    X509Certificate[] jsseCerts = null;
                    try {
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                        jsseCerts = new X509Certificate[]{cert};
                    }
                    catch (CertificateException e) {
                        log.error((Object)"Certificate convertion failed", (Throwable)e);
                        return;
                    }
                    req.setAttribute("javax.servlet.request.X509Certificate", (Object)jsseCerts);
                    break block24;
                }
                if (actionCode == ActionCode.ACTION_REQ_HOST_ATTRIBUTE) {
                    Request req = (Request)param;
                    if (req.remoteHost().isNull()) {
                        req.remoteHost().setString(InetAddress.getByName(req.remoteAddr().toString()).getHostName());
                    }
                } else if (actionCode == ActionCode.ACTION_ACK && log.isDebugEnabled()) {
                    log.debug((Object)"ACK ");
                }
            }
            catch (Exception ex) {
                log.error((Object)"Error in action code ", (Throwable)ex);
            }
        }
    }

    private void logTime(Request req, Response res) {
        MsgContext ep = (MsgContext)res.getNote(this.epNote);
        String uri = req.requestURI().toString();
        if (uri.indexOf(".gif") > 0) {
            return;
        }
        ep.setLong(2, System.currentTimeMillis());
        long t1 = ep.getLong(1) - ep.getLong(0);
        long t2 = ep.getLong(2) - ep.getLong(1);
        logTime.debug((Object)("Time pre=" + t1 + "/ service=" + t2 + " " + res.getContentLength() + " " + uri));
    }

    public ObjectName preRegister(MBeanServer server, ObjectName oname) throws Exception {
        this.name = "container";
        return super.preRegister(server, oname);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class StatusLinePrivilegedAction
    implements PrivilegedAction {
        int status;

        StatusLinePrivilegedAction(int status) {
            this.status = status;
        }

        public Object run() {
            return HttpMessages.getMessage((int)this.status);
        }
    }
}

