/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.io.Serializable;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.CharChunk;

public final class ByteChunk
implements Cloneable,
Serializable {
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private byte[] buff;
    private int start = 0;
    private int end;
    private String enc;
    private boolean isSet = false;
    private int limit = -1;
    private ByteOutputChannel out = null;
    private boolean isOutput = false;

    public ByteChunk() {
    }

    public ByteChunk(int initial) {
        this.allocate(initial, -1);
    }

    public ByteChunk getClone() {
        try {
            return (ByteChunk)this.clone();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isNull() {
        return !this.isSet;
    }

    public void recycle() {
        this.enc = null;
        this.start = 0;
        this.end = 0;
        this.isSet = false;
    }

    public void reset() {
        this.buff = null;
    }

    public void allocate(int initial, int limit) {
        this.isOutput = true;
        if (this.buff == null || this.buff.length < initial) {
            this.buff = new byte[initial];
        }
        this.limit = limit;
        this.start = 0;
        this.end = 0;
        this.isSet = true;
    }

    public void setBytes(byte[] b, int off, int len) {
        this.buff = b;
        this.start = off;
        this.end = this.start + len;
        this.isSet = true;
    }

    public void setEncoding(String enc) {
        this.enc = enc;
    }

    public byte[] getBytes() {
        return this.getBuffer();
    }

    public byte[] getBuffer() {
        return this.buff;
    }

    public int getStart() {
        return this.start;
    }

    public int getOffset() {
        return this.getStart();
    }

    public void setOffset(int off) {
        if (this.end < off) {
            this.end = off;
        }
        this.start = off;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setByteOutputChannel(ByteOutputChannel out) {
        this.out = out;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int i) {
        this.end = i;
    }

    public void append(char c) throws IOException {
        this.append((byte)c);
    }

    public void append(byte b) throws IOException {
        this.makeSpace(1);
        if (this.limit > 0 && this.end >= this.limit) {
            this.flushBuffer();
        }
        this.buff[this.end++] = b;
    }

    public void append(ByteChunk src) throws IOException {
        this.append(src.getBytes(), src.getStart(), src.getLength());
    }

    public void append(byte[] src, int off, int len) throws IOException {
        this.makeSpace(len);
        if (this.limit < 0) {
            System.arraycopy(src, off, this.buff, this.end, len);
            this.end += len;
            return;
        }
        if (len <= this.limit - this.end) {
            System.arraycopy(src, off, this.buff, this.end, len);
            this.end += len;
            return;
        }
        if (len + this.end < 2 * this.limit) {
            int avail = this.limit - this.end;
            System.arraycopy(src, off, this.buff, this.end, avail);
            this.end += avail;
            this.flushBuffer();
            System.arraycopy(src, off + avail, this.buff, this.end, len - avail);
            this.end += len - avail;
        } else {
            this.flushBuffer();
            this.out.realWriteBytes(src, off, len);
        }
    }

    public void flushBuffer() throws IOException {
        if (this.out == null) {
            throw new IOException("Buffer overflow, no sink " + this.limit + " " + this.buff.length);
        }
        this.out.realWriteBytes(this.buff, this.start, this.end - this.start);
        this.end = this.start;
    }

    private void makeSpace(int count) {
        byte[] tmp = null;
        int desiredSize = this.end + count;
        if (this.limit > 0 && desiredSize > this.limit - this.start) {
            desiredSize = this.limit - this.start;
        }
        if (this.buff == null) {
            if (desiredSize < 256) {
                desiredSize = 256;
            }
            this.buff = new byte[desiredSize];
        }
        if (desiredSize < this.buff.length) {
            return;
        }
        if (desiredSize < 2 * this.buff.length) {
            int newSize = this.buff.length * 2;
            if (this.limit > 0 && newSize > this.limit) {
                newSize = this.limit;
            }
            tmp = new byte[newSize];
        } else {
            int newSize = this.buff.length * 2 + count;
            if (this.limit > 0 && newSize > this.limit) {
                newSize = this.limit;
            }
            tmp = new byte[newSize];
        }
        System.arraycopy(this.buff, this.start, tmp, 0, this.end - this.start);
        this.buff = tmp;
        tmp = null;
        this.end -= this.start;
        this.start = 0;
    }

    public String toString() {
        if (null == this.buff) {
            return null;
        }
        Object strValue = null;
        try {
            if (this.enc == null) {
                this.enc = DEFAULT_CHARACTER_ENCODING;
            }
            return new String(this.buff, this.start, this.end - this.start, this.enc);
        }
        catch (IOException e) {
            return null;
        }
    }

    public int getInt() {
        return Ascii.parseInt(this.buff, this.start, this.end - this.start);
    }

    public boolean equals(String s) {
        byte[] b = this.buff;
        int blen = this.end - this.start;
        if (b == null || blen != s.length()) {
            return false;
        }
        int boff = this.start;
        int i = 0;
        while (i < blen) {
            if (b[boff++] != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String s) {
        byte[] b = this.buff;
        int blen = this.end - this.start;
        if (b == null || blen != s.length()) {
            return false;
        }
        int boff = this.start;
        int i = 0;
        while (i < blen) {
            if (Ascii.toLower(b[boff++]) != Ascii.toLower(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(ByteChunk bb) {
        return this.equals(bb.getBytes(), bb.getStart(), bb.getLength());
    }

    public boolean equals(byte[] b2, int off2, int len2) {
        byte[] b1 = this.buff;
        if (b1 == null && b2 == null) {
            return true;
        }
        int len = this.end - this.start;
        if (len2 != len || b1 == null || b2 == null) {
            return false;
        }
        int off1 = this.start;
        while (len-- > 0) {
            if (b1[off1++] == b2[off2++]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(CharChunk cc) {
        return this.equals(cc.getChars(), cc.getStart(), cc.getLength());
    }

    public boolean equals(char[] c2, int off2, int len2) {
        byte[] b1 = this.buff;
        if (c2 == null && b1 == null) {
            return true;
        }
        if (b1 == null || c2 == null || this.end - this.start != len2) {
            return false;
        }
        int off1 = this.start;
        int len = this.end - this.start;
        while (len-- > 0) {
            if ((char)b1[off1++] == c2[off2++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String s) {
        byte[] b = this.buff;
        int blen = s.length();
        if (b == null || blen > this.end - this.start) {
            return false;
        }
        int boff = this.start;
        int i = 0;
        while (i < blen) {
            if (b[boff++] != s.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean startsWith(byte[] b2) {
        byte[] b1 = this.buff;
        if (b1 == null && b2 == null) {
            return true;
        }
        int len = this.end - this.start;
        if (b1 == null || b2 == null || b2.length > len) {
            return false;
        }
        int i = this.start;
        int j = 0;
        while (i < this.end && j < b2.length) {
            if (b1[i++] == b2[j++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String s, int pos) {
        byte[] b = this.buff;
        int len = s.length();
        if (b == null || len + pos > this.end - this.start) {
            return false;
        }
        int off = this.start + pos;
        int i = 0;
        while (i < len) {
            if (Ascii.toLower(b[off++]) != Ascii.toLower(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int indexOf(String src, int srcOff, int srcLen, int myOff) {
        char first = src.charAt(srcOff);
        int srcEnd = srcOff + srcLen;
        int i = myOff + this.start;
        while (i <= this.end - srcLen) {
            if (this.buff[i] == first) {
                int myPos = i + 1;
                int srcPos = srcOff + 1;
                while (srcPos < srcEnd) {
                    if (this.buff[myPos++] != src.charAt(srcPos++)) break;
                    if (srcPos != srcEnd) continue;
                    return i - this.start;
                }
            }
            ++i;
        }
        return -1;
    }

    public int hash() {
        return ByteChunk.hashBytes(this.buff, this.start, this.end - this.start);
    }

    public int hashIgnoreCase() {
        return ByteChunk.hashBytesIC(this.buff, this.start, this.end - this.start);
    }

    private static int hashBytes(byte[] buff, int start, int bytesLen) {
        int max = start + bytesLen;
        byte[] bb = buff;
        int code = 0;
        int i = start;
        while (i < max) {
            code = code * 37 + bb[i];
            ++i;
        }
        return code;
    }

    private static int hashBytesIC(byte[] bytes, int start, int bytesLen) {
        int max = start + bytesLen;
        byte[] bb = bytes;
        int code = 0;
        int i = start;
        while (i < max) {
            code = code * 37 + Ascii.toLower(bb[i]);
            ++i;
        }
        return code;
    }

    public int indexOf(char c, int starting) {
        int ret = ByteChunk.indexOf(this.buff, this.start + starting, this.end, c);
        return ret >= this.start ? ret - this.start : -1;
    }

    public static int indexOf(byte[] bytes, int off, int end, char qq) {
        while (off < end) {
            byte b = bytes[off];
            if (b == qq) {
                return off;
            }
            ++off;
        }
        return -1;
    }

    public static int findChar(byte[] buf, int start, int end, char c) {
        byte b = (byte)c;
        int offset = start;
        while (offset < end) {
            if (buf[offset] == b) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static int findChars(byte[] buf, int start, int end, byte[] c) {
        int clen = c.length;
        int offset = start;
        while (offset < end) {
            int i = 0;
            while (i < clen) {
                if (buf[offset] == c[i]) {
                    return offset;
                }
                ++i;
            }
            ++offset;
        }
        return -1;
    }

    public static int findNotChars(byte[] buf, int start, int end, byte[] c) {
        int clen = c.length;
        int offset = start;
        while (offset < end) {
            boolean found = true;
            int i = 0;
            while (i < clen) {
                if (buf[offset] == c[i]) {
                    found = false;
                    break;
                }
                ++i;
            }
            if (found) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static interface ByteOutputChannel {
        public void realWriteBytes(byte[] var1, int var2, int var3) throws IOException;
    }
}

