/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.collections;

import java.util.Vector;

public class Queue {
    private Vector vector = new Vector();
    private boolean stopWaiting = false;
    private boolean waiting = false;

    public synchronized void put(Object object) {
        this.vector.addElement(object);
        this.notify();
    }

    public synchronized void stop() {
        this.stopWaiting = true;
        if (this.waiting) {
            this.notify();
        }
    }

    public synchronized Object pull() {
        while (this.isEmpty()) {
            try {
                this.waiting = true;
                this.wait();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this.waiting = false;
            if (!this.stopWaiting) continue;
            return null;
        }
        return this.get();
    }

    public synchronized Object get() {
        Object object = this.peek();
        if (object != null) {
            this.vector.removeElementAt(0);
        }
        return object;
    }

    public Object peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.vector.elementAt(0);
    }

    public boolean isEmpty() {
        return this.vector.isEmpty();
    }

    public int size() {
        return this.vector.size();
    }
}

