/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.log;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.log.LogHandler;

public class CommonLogHandler
extends LogHandler {
    private Hashtable loggers = new Hashtable();

    public void log(String prefix, String msg, Throwable t, int verbosityLevel) {
        Log l;
        if (prefix == null) {
            prefix = "tomcat";
        }
        if ((l = (Log)this.loggers.get(prefix)) == null) {
            l = LogFactory.getLog((String)prefix);
            this.loggers.put(prefix, l);
        }
        if (verbosityLevel > this.level) {
            return;
        }
        if (t == null) {
            switch (verbosityLevel) {
                case -2147483648: {
                    l.fatal((Object)msg);
                    break;
                }
                case 1: {
                    l.error((Object)msg);
                    break;
                }
                case 2: {
                    l.warn((Object)msg);
                    break;
                }
                case 3: {
                    l.info((Object)msg);
                    break;
                }
                case 4: {
                    l.debug((Object)msg);
                }
            }
        } else {
            switch (verbosityLevel) {
                case -2147483648: {
                    l.fatal((Object)msg, t);
                    break;
                }
                case 1: {
                    l.error((Object)msg, t);
                    break;
                }
                case 2: {
                    l.warn((Object)msg, t);
                    break;
                }
                case 3: {
                    l.info((Object)msg, t);
                    break;
                }
                case 4: {
                    l.debug((Object)msg, t);
                }
            }
        }
    }

    public void flush() {
    }

    public synchronized void close() {
    }
}

