/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.IOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.tomcat.util.net.jsse.JSSEKeyManager;
import org.apache.tomcat.util.net.jsse.JSSESocketFactory;
import org.apache.tomcat.util.res.StringManager;

public class JSSE14SocketFactory
extends JSSESocketFactory {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.util.net.jsse.res");
    protected boolean requireClientAuth = false;
    protected boolean wantClientAuth = false;

    void init() throws IOException {
        try {
            String trustAlgorithm;
            String keystoreType;
            String algorithm;
            String clientAuthStr = (String)this.attributes.get("clientauth");
            if ("true".equalsIgnoreCase(clientAuthStr) || "yes".equalsIgnoreCase(clientAuthStr)) {
                this.requireClientAuth = true;
            } else if ("want".equalsIgnoreCase(clientAuthStr)) {
                this.wantClientAuth = true;
            }
            String protocol = (String)this.attributes.get("protocol");
            if (protocol == null) {
                protocol = defaultProtocol;
            }
            if ((algorithm = (String)this.attributes.get("algorithm")) == null) {
                algorithm = defaultAlgorithm;
            }
            if ((keystoreType = (String)this.attributes.get("keystoreType")) == null) {
                keystoreType = defaultKeystoreType;
            }
            if ((trustAlgorithm = (String)this.attributes.get("truststoreAlgorithm")) == null) {
                trustAlgorithm = algorithm;
            }
            SSLContext context = SSLContext.getInstance(protocol);
            context.init(this.getKeyManagers(keystoreType, algorithm, (String)this.attributes.get("keyAlias")), this.getTrustManagers(keystoreType, trustAlgorithm), new SecureRandom());
            this.sslProxy = context.getServerSocketFactory();
            String requestedCiphers = (String)this.attributes.get("ciphers");
            this.enabledCiphers = this.getEnabledCiphers(requestedCiphers, this.sslProxy.getSupportedCipherSuites());
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    protected KeyManager[] getKeyManagers(String keystoreType, String algorithm, String keyAlias) throws Exception {
        KeyManager[] kms = null;
        String keystorePass = this.getKeystorePassword();
        KeyStore ks = this.getKeystore(keystoreType, keystorePass);
        if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
            throw new IOException(sm.getString("jsse.alias_no_key_entry", keyAlias));
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keystorePass.toCharArray());
        kms = kmf.getKeyManagers();
        if (keyAlias != null) {
            if (JSSESocketFactory.defaultKeystoreType.equals(keystoreType)) {
                keyAlias = keyAlias.toLowerCase();
            }
            for (int i = 0; i < kms.length; ++i) {
                kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], keyAlias);
            }
        }
        return kms;
    }

    protected TrustManager[] getTrustManagers(String keystoreType, String algorithm) throws Exception {
        KeyStore trustStore;
        TrustManager[] tms = null;
        String truststoreType = (String)this.attributes.get("truststoreType");
        if (truststoreType == null) {
            truststoreType = keystoreType;
        }
        if ((trustStore = this.getTrustStore(truststoreType)) != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(trustStore);
            tms = tmf.getTrustManagers();
        }
        return tms;
    }

    protected void setEnabledProtocols(SSLServerSocket socket, String[] protocols) {
        if (protocols != null) {
            socket.setEnabledProtocols(protocols);
        }
    }

    protected String[] getEnabledProtocols(SSLServerSocket socket, String requestedProtocols) {
        String[] supportedProtocols = socket.getSupportedProtocols();
        Object[] enabledProtocols = null;
        if (requestedProtocols != null) {
            Vector<String> vec = null;
            String protocol = requestedProtocols;
            int index = requestedProtocols.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    protocol = requestedProtocols.substring(fromIndex, index).trim();
                    if (protocol.length() > 0) {
                        for (int i = 0; supportedProtocols != null && i < supportedProtocols.length; ++i) {
                            if (!supportedProtocols[i].equals(protocol)) continue;
                            if (vec == null) {
                                vec = new Vector();
                            }
                            vec.addElement(protocol);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedProtocols.indexOf(44, fromIndex);
                }
                protocol = requestedProtocols.substring(fromIndex);
            }
            if (protocol != null && (protocol = protocol.trim()).length() > 0) {
                for (int i = 0; supportedProtocols != null && i < supportedProtocols.length; ++i) {
                    if (!supportedProtocols[i].equals(protocol)) continue;
                    if (vec == null) {
                        vec = new Vector<String>();
                    }
                    vec.addElement(protocol);
                    break;
                }
            }
            if (vec != null) {
                enabledProtocols = new String[vec.size()];
                vec.copyInto(enabledProtocols);
            }
        }
        return enabledProtocols;
    }

    protected void configureClientAuth(SSLServerSocket socket) {
        if (this.wantClientAuth) {
            socket.setWantClientAuth(this.wantClientAuth);
        } else {
            socket.setNeedClientAuth(this.requireClientAuth);
        }
    }

    protected void configureClientAuth(SSLSocket socket) {
    }
}

