/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat3;

import java.io.IOException;
import java.util.Locale;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.ByteChunk;

class Tomcat3Response
extends org.apache.tomcat.core.Response {
    String reportedname = null;
    Response coyoteResponse = null;
    ByteChunk outputChunk = new ByteChunk();
    boolean acknowledged = false;

    public void setCoyoteResponse(Response cRes) {
        this.coyoteResponse = cRes;
        this.headers = this.coyoteResponse.getMimeHeaders();
    }

    public void init() {
        super.init();
    }

    public void recycle() {
        super.recycle();
        if (this.coyoteResponse != null) {
            this.coyoteResponse.recycle();
        }
        this.outputChunk.recycle();
        this.acknowledged = false;
    }

    public void setReported(String reported) {
        this.reportedname = reported;
    }

    public void endHeaders() throws IOException {
        super.endHeaders();
        this.coyoteResponse.setStatus(this.getStatus());
        int cLen = this.getContentLength();
        if (cLen >= 0) {
            this.coyoteResponse.setContentLength(cLen);
        }
        this.coyoteResponse.sendHeaders();
    }

    public void clientFlush() throws IOException {
        this.coyoteResponse.action(ActionCode.ACTION_CLIENT_FLUSH, (Object)this.coyoteResponse);
    }

    public void doWrite(byte[] buffer, int pos, int count) throws IOException {
        if (count > 0) {
            this.outputChunk.setBytes(buffer, pos, count);
            this.coyoteResponse.doWrite(this.outputChunk);
        }
    }

    public void reset() throws IllegalStateException {
        super.reset();
        if (!this.included) {
            this.coyoteResponse.reset();
        }
    }

    public void finish() throws IOException {
        super.finish();
        this.coyoteResponse.finish();
    }

    public void sendAcknowledgement() throws IOException {
        if (this.status >= 300) {
            this.acknowledged = true;
        }
        if (this.acknowledged) {
            return;
        }
        if (this.isIncluded()) {
            return;
        }
        if (this.isBufferCommitted()) {
            throw new IllegalStateException(sm.getString("hsrf.error.ise"));
        }
        this.coyoteResponse.acknowledge();
        this.acknowledged = true;
    }

    public void setLocale(Locale locale) {
        if (locale == null || this.included) {
            return;
        }
        this.locale = locale;
        this.coyoteResponse.setLocale(locale);
        this.contentLanguage = this.coyoteResponse.getContentLanguage();
        this.headers.setValue("Content-Language").setString(this.contentLanguage);
    }

    public void setContentType(String contentType) {
        if (this.included) {
            return;
        }
        this.coyoteResponse.setContentType(contentType);
        this.contentType = this.coyoteResponse.getContentType();
        this.characterEncoding = this.coyoteResponse.getCharacterEncoding();
        this.haveCharacterEncoding = true;
        this.headers.setValue("Content-Type").setString(contentType);
    }
}

