/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.WrappedIOException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ClassPathIterator
implements Iterator {
    private LinkedList parts = new LinkedList();
    private static final FileFilter FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory() || ClassPathIterator.isClassFile(ClassPathIterator.getName(pathname));
        }
    };
    private File parent;
    private Enumeration entries;
    private Map sources = new HashMap();
    private ZipFile zip;
    private Object next;

    public ClassPathIterator(String classPath) {
        this(new File(System.getProperty("user.dir")), classPath);
    }

    public ClassPathIterator(File parent, String classPath) {
        this.parent = parent;
        StringTokenizer st = new StringTokenizer(classPath, System.getProperty("path.separator"));
        while (st.hasMoreTokens()) {
            this.parts.add(st.nextElement());
        }
        this.advance();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public void close() throws IOException {
        if (this.sources != null) {
            Iterator it = this.sources.values().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof ZipFile)) continue;
                ((ZipFile)obj).close();
            }
        }
    }

    public InputStream getInputStream(Object obj) throws IOException {
        if (obj instanceof ZipEntry) {
            return ((ZipFile)this.sources.get(obj)).getInputStream((ZipEntry)obj);
        }
        return new BufferedInputStream(new FileInputStream((File)obj));
    }

    public Object getSource(Object obj) {
        return this.sources.get(obj);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object result = this.next;
        this.advance();
        return result;
    }

    private void advance() {
        try {
            if (this.entries == null) {
                int len;
                if (this.parts.size() == 0) {
                    this.next = null;
                    return;
                }
                this.zip = null;
                String part = (String)this.parts.removeFirst();
                File file = new File(part);
                if (!file.isAbsolute()) {
                    file = new File(this.parent, part);
                }
                if ((len = part.length()) >= 4) {
                    String ext = part.substring(len - 4, len);
                    if (ext.equalsIgnoreCase(".jar")) {
                        this.zip = new JarFile(file);
                    } else if (ext.equalsIgnoreCase(".zip")) {
                        this.zip = new ZipFile(file);
                    }
                    if (this.zip != null) {
                        this.entries = this.zip.entries();
                    }
                }
                if (this.entries == null) {
                    if (file.isDirectory()) {
                        List classes = ClassPathIterator.findClasses(file);
                        Iterator it = classes.iterator();
                        while (it.hasNext()) {
                            this.sources.put(it.next(), file);
                        }
                        this.entries = Collections.enumeration(classes);
                    } else {
                        throw new IllegalArgumentException("Do not know how to handle " + part);
                    }
                }
            }
            boolean foundClass = false;
            while (this.entries.hasMoreElements()) {
                this.next = this.entries.nextElement();
                foundClass = ClassPathIterator.isClassFile(ClassPathIterator.getName(this.next));
                if (!foundClass) continue;
                if (this.zip == null) break;
                this.sources.put(this.next, this.zip);
                break;
            }
            if (!foundClass) {
                this.entries = null;
                this.advance();
            }
        }
        catch (IOException e) {
            throw new WrappedIOException(e);
        }
    }

    private static List findClasses(File root) {
        ArrayList collect = new ArrayList();
        ClassPathIterator.findClassesHelper(root, collect);
        return collect;
    }

    private static void findClassesHelper(File dir, List collect) {
        File[] files = dir.listFiles(FILTER);
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                ClassPathIterator.findClassesHelper(files[i], collect);
                continue;
            }
            collect.add(files[i]);
        }
    }

    private static String getName(Object obj) {
        return obj instanceof ZipEntry ? ((ZipEntry)obj).getName() : ((File)obj).getName();
    }

    private static boolean isClassFile(String name) {
        int len = name.length();
        return len >= 6 && name.substring(len - 6, len).equalsIgnoreCase(".class");
    }
}

