/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.ClassTransformer;
import com.tonicsystems.jarjar.PatternElement;
import com.tonicsystems.jarjar.Wildcard;
import com.tonicsystems.jarjar.asm.Attribute;
import com.tonicsystems.jarjar.asm.ClassAdapter;
import com.tonicsystems.jarjar.asm.ClassVisitor;
import com.tonicsystems.jarjar.asm.FieldVisitor;
import com.tonicsystems.jarjar.asm.Label;
import com.tonicsystems.jarjar.asm.MethodAdapter;
import com.tonicsystems.jarjar.asm.MethodVisitor;
import com.tonicsystems.jarjar.asm.Type;
import java.util.ArrayList;
import java.util.List;

class DepKillTransformer
extends ClassAdapter
implements ClassTransformer {
    private static final Type TYPE_OBJECT = Type.getType(class$java$lang$Object == null ? (class$java$lang$Object = DepKillTransformer.class$("java.lang.Object")) : class$java$lang$Object);
    private Wildcard[] wildcards;
    static /* synthetic */ Class class$java$lang$Object;

    public DepKillTransformer(List patterns) {
        super(null);
        this.wildcards = PatternElement.createWildcards(patterns);
    }

    public void setTarget(ClassVisitor target) {
        this.cv = target;
    }

    private boolean checkDesc(String desc) {
        for (int i = 0; i < this.wildcards.length; ++i) {
            if (!this.wildcards[i].matches(desc, 0)) continue;
            return true;
        }
        return false;
    }

    private String fixMethodDesc(String methodDesc) {
        if (this.wildcards.length == 0) {
            return methodDesc;
        }
        Type[] args = Type.getArgumentTypes(methodDesc);
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.eraseType(args[i]);
        }
        return Type.getMethodDescriptor(this.eraseType(Type.getReturnType(methodDesc)), args);
    }

    private Type eraseType(Type type) {
        return this.checkDesc(type.getDescriptor()) ? TYPE_OBJECT : type;
    }

    private boolean checkName(String name) {
        if (this.wildcards.length == 0) {
            return false;
        }
        return this.checkDesc("L" + name + ";");
    }

    private static void replace(MethodVisitor mv, String desc) {
        switch (desc.charAt(0)) {
            case 'V': {
                break;
            }
            case 'D': {
                mv.visitInsn(14);
                break;
            }
            case 'F': {
                mv.visitInsn(11);
                break;
            }
            case 'J': {
                mv.visitInsn(9);
                break;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                mv.visitInsn(3);
                break;
            }
            case 'L': 
            case '[': {
                mv.visitInsn(1);
            }
        }
    }

    private static void pop(MethodVisitor mv, String desc) {
        switch (desc.charAt(0)) {
            case 'D': 
            case 'J': {
                mv.visitInsn(88);
            }
        }
        mv.visitInsn(87);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (exceptions != null && this.wildcards.length > 0) {
            ArrayList<String> exceptionList = new ArrayList<String>(exceptions.length);
            for (int i = 0; i < exceptions.length; ++i) {
                if (this.checkName(exceptions[i])) continue;
                exceptionList.add(exceptions[i]);
            }
            exceptions = exceptionList.toArray(new String[exceptionList.size()]);
        }
        return new DepKillMethodVisitor(this.cv.visitMethod(access, name, this.fixMethodDesc(desc), signature, exceptions));
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.checkDesc(desc)) {
            desc = TYPE_OBJECT.getDescriptor();
        }
        return super.visitField(access, name, desc, signature, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DepKillMethodVisitor
    extends MethodAdapter {
        public DepKillMethodVisitor(MethodVisitor mv) {
            super(mv);
        }

        public void visitTypeInsn(int opcode, String desc) {
            if (desc.charAt(0) == '[' ? DepKillTransformer.this.checkDesc(desc) : DepKillTransformer.this.checkName(desc)) {
                switch (opcode) {
                    case 187: 
                    case 189: {
                        this.mv.visitInsn(1);
                        break;
                    }
                    case 192: 
                    case 193: {
                        this.mv.visitInsn(3);
                    }
                }
            } else {
                this.mv.visitTypeInsn(opcode, desc);
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (DepKillTransformer.this.checkName(owner) || DepKillTransformer.this.checkDesc(desc)) {
                switch (opcode) {
                    case 180: {
                        this.mv.visitInsn(87);
                        DepKillTransformer.replace(this.mv, desc);
                        break;
                    }
                    case 181: {
                        DepKillTransformer.pop(this.mv, desc);
                        this.mv.visitInsn(87);
                        break;
                    }
                    case 178: {
                        DepKillTransformer.replace(this.mv, desc);
                        break;
                    }
                    case 179: {
                        DepKillTransformer.pop(this.mv, desc);
                    }
                }
            } else {
                this.mv.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (DepKillTransformer.this.checkName(owner)) {
                switch (opcode) {
                    case 182: 
                    case 185: {
                        this.mv.visitInsn(87);
                        break;
                    }
                    case 183: {
                        throw new IllegalStateException("Cannot remove invocation of " + owner + "." + desc);
                    }
                }
                Type[] args = Type.getArgumentTypes(desc);
                for (int i = 0; i < args.length; ++i) {
                    this.mv.visitInsn(args[i].getSize() == 2 ? 88 : 87);
                }
                DepKillTransformer.replace(this.mv, Type.getReturnType(desc).getDescriptor());
            } else {
                this.mv.visitMethodInsn(opcode, owner, name, DepKillTransformer.this.fixMethodDesc(desc));
            }
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            if (DepKillTransformer.this.checkDesc(desc)) {
                this.mv.visitInsn(1);
            } else {
                this.mv.visitMultiANewArrayInsn(desc, dims);
            }
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (!DepKillTransformer.this.checkName(type)) {
                this.mv.visitTryCatchBlock(start, end, handler, type);
            }
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (DepKillTransformer.this.checkDesc(desc)) {
                desc = TYPE_OBJECT.getDescriptor();
            }
            this.mv.visitLocalVariable(name, desc, signature, start, end, index);
        }

        public void visitAttribute(Attribute attr) {
            this.mv.visitAttribute(attr);
        }
    }
}

