/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.ClassTransformer;
import com.tonicsystems.jarjar.Rules;
import com.tonicsystems.jarjar.SignatureAdapter;
import com.tonicsystems.jarjar.asm.AnnotationVisitor;
import com.tonicsystems.jarjar.asm.Attribute;
import com.tonicsystems.jarjar.asm.ClassAdapter;
import com.tonicsystems.jarjar.asm.ClassVisitor;
import com.tonicsystems.jarjar.asm.FieldVisitor;
import com.tonicsystems.jarjar.asm.Label;
import com.tonicsystems.jarjar.asm.MethodAdapter;
import com.tonicsystems.jarjar.asm.MethodVisitor;
import com.tonicsystems.jarjar.asm.signature.SignatureReader;
import com.tonicsystems.jarjar.asm.signature.SignatureWriter;

class PackageTransformer
extends ClassAdapter
implements ClassTransformer {
    private Rules rules;
    private String className;

    public PackageTransformer(Rules rules) {
        super(null);
        this.rules = rules;
    }

    public void setTarget(ClassVisitor target) {
        this.cv = target;
    }

    private String[] fixNames(String[] names) {
        if (names == null) {
            return null;
        }
        String[] fixed = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            fixed[i] = this.rules.fixName(names[i]);
        }
        return fixed;
    }

    private Object fixValue(Object value) {
        if (value instanceof String) {
            return this.rules.fixString(this.className, (String)value);
        }
        return value;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name.replace('/', '.');
        this.cv.visit(version, access, this.rules.fixName(name), this.fixSignature(signature, false), this.rules.fixName(superName), this.fixNames(interfaces));
    }

    public void visitAttribute(Attribute attr) {
        this.cv.visitAttribute(this.rules.fixAttribute(attr));
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new AnnotationFixer(this.cv.visitAnnotation(this.rules.fixDesc(desc), visible));
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldFixer fv = new FieldFixer(this.cv.visitField(access, name, this.rules.fixDesc(desc), this.fixSignature(signature, true), this.fixValue(value)));
        return fv != null ? new FieldFixer(fv) : null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.cv.visitInnerClass(this.rules.fixName(name), this.rules.fixName(outerName), innerName, access);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, this.rules.fixMethodDesc(desc), this.fixSignature(signature, false), this.fixNames(exceptions));
        return mv != null ? new MethodFixer(mv) : null;
    }

    private AnnotationVisitor fixAnnotation(AnnotationVisitor av) {
        return av != null ? new AnnotationFixer(av) : null;
    }

    private String fixSignature(String signature, boolean type) {
        if (signature == null) {
            return null;
        }
        SignatureReader reader = new SignatureReader(signature);
        SignatureWriter writer = new SignatureWriter();
        SignatureFixer fixer = new SignatureFixer(writer);
        if (type) {
            reader.acceptType(fixer);
        } else {
            reader.accept(fixer);
        }
        return writer.toString();
    }

    private class SignatureFixer
    extends SignatureAdapter {
        public SignatureFixer(SignatureWriter sw) {
            super(sw);
        }

        public void visitTypeVariable(String name) {
            this.sw.visitTypeVariable(PackageTransformer.this.rules.fixName(name));
        }

        public void visitClassType(String name) {
            this.sw.visitClassType(PackageTransformer.this.rules.fixName(name));
        }

        public void visitInnerClassType(String name) {
            this.sw.visitInnerClassType(PackageTransformer.this.rules.fixName(name));
        }
    }

    private class AnnotationFixer
    implements AnnotationVisitor {
        private AnnotationVisitor av;

        public AnnotationFixer(AnnotationVisitor av) {
            this.av = av;
        }

        public void visit(String name, Object value) {
            this.av.visit(name, PackageTransformer.this.fixValue(value));
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return PackageTransformer.this.fixAnnotation(this.av.visitAnnotation(name, PackageTransformer.this.rules.fixDesc(desc)));
        }

        public AnnotationVisitor visitArray(String name) {
            return PackageTransformer.this.fixAnnotation(this.av.visitArray(name));
        }

        public void visitEnum(String name, String desc, String value) {
            this.av.visitEnum(name, PackageTransformer.this.rules.fixDesc(desc), (String)PackageTransformer.this.fixValue(value));
        }

        public void visitEnd() {
            this.av.visitEnd();
        }
    }

    private class MethodFixer
    extends MethodAdapter {
        public MethodFixer(MethodVisitor mv) {
            super(mv);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return PackageTransformer.this.fixAnnotation(this.mv.visitAnnotation(PackageTransformer.this.rules.fixDesc(desc), visible));
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return PackageTransformer.this.fixAnnotation(this.mv.visitAnnotationDefault());
        }

        public void visitTypeInsn(int opcode, String desc) {
            this.mv.visitTypeInsn(opcode, desc.charAt(0) == '[' ? PackageTransformer.this.rules.fixDesc(desc) : PackageTransformer.this.rules.fixName(desc));
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.mv.visitFieldInsn(opcode, PackageTransformer.this.rules.fixName(owner), name, PackageTransformer.this.rules.fixDesc(desc));
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.mv.visitMethodInsn(opcode, PackageTransformer.this.rules.fixName(owner), name, PackageTransformer.this.rules.fixMethodDesc(desc));
        }

        public void visitLdcInsn(Object cst) {
            this.mv.visitLdcInsn(PackageTransformer.this.fixValue(cst));
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.mv.visitMultiANewArrayInsn(PackageTransformer.this.rules.fixDesc(desc), dims);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.mv.visitTryCatchBlock(start, end, handler, PackageTransformer.this.rules.fixName(type));
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            this.mv.visitLocalVariable(name, PackageTransformer.this.rules.fixDesc(desc), PackageTransformer.this.fixSignature(signature, true), start, end, index);
        }

        public void visitAttribute(Attribute attr) {
            this.mv.visitAttribute(PackageTransformer.this.rules.fixAttribute(attr));
        }
    }

    private class FieldFixer
    implements FieldVisitor {
        private FieldVisitor fv;

        public FieldFixer(FieldVisitor fv) {
            this.fv = fv;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationFixer(this.fv.visitAnnotation(PackageTransformer.this.rules.fixDesc(desc), visible));
        }

        public void visitAttribute(Attribute attr) {
            this.fv.visitAttribute(PackageTransformer.this.rules.fixAttribute(attr));
        }

        public void visitEnd() {
            this.fv.visitEnd();
        }
    }
}

